/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class TypeAnnotationParameter
extends Recipe {
    private static final AnnotationMatcher FQN_TYPE_ANNOTATION = new AnnotationMatcher("@org.hibernate.annotations.Type");
    private static final Set<String> REMOVED_FQNS = new HashSet<String>(Arrays.asList("org.hibernate.type.EnumType", "org.hibernate.type.SerializableType", "org.hibernate.type.SerializableToBlobType", "org.hibernate.type.TextType"));

    public String getDisplayName() {
        return "@Type annotation type parameter migration";
    }

    public String getDescription() {
        return "Hibernate 6.x has 'type' parameter of type String replaced with 'value' of type class.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
                if (FQN_TYPE_ANNOTATION.matches(a)) {
                    if (a.getArguments().stream().anyMatch(arg -> {
                        J.Assignment assignment;
                        if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "type".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal) {
                            String fqTypeName = (String)((J.Literal)assignment.getAssignment()).getValue();
                            return REMOVED_FQNS.contains(fqTypeName);
                        }
                        return false;
                    })) {
                        this.maybeRemoveImport("org.hibernate.annotations.Type");
                        return null;
                    }
                    boolean isOnlyParameter = a.getArguments().size() == 1;
                    a = a.withArguments(ListUtils.map((List)a.getArguments(), arg -> {
                        J.Assignment assignment;
                        if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "type".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal) {
                            String fqTypeName = (String)((J.Literal)assignment.getAssignment()).getValue();
                            J.Identifier identifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), TypeAnnotationParameter.getSimpleName(fqTypeName), JavaType.buildType((String)fqTypeName), null);
                            J.FieldAccess fa = new J.FieldAccess(Tree.randomId(), isOnlyParameter ? Space.EMPTY : assignment.getAssignment().getPrefix(), assignment.getAssignment().getMarkers(), (Expression)identifier, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "class", null, null)), JavaType.buildType((String)"java.lang.Class"));
                            this.maybeAddImport(fqTypeName);
                            if (isOnlyParameter) {
                                return fa;
                            }
                            return assignment.withVariable((Expression)((J.Identifier)assignment.getVariable()).withSimpleName("value")).withAssignment((Expression)fa);
                        }
                        return arg;
                    }));
                }
                return a;
            }
        };
    }

    private static String getSimpleName(String fqName) {
        int idx = fqName.lastIndexOf(46);
        if (idx > 0 && idx < fqName.length() - 1) {
            return fqName.substring(idx + 1);
        }
        return fqName;
    }
}

