/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import io.micrometer.core.instrument.util.StringUtils;
import java.beans.ConstructorProperties;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

public final class AboutJavaVersion
extends Recipe {
    @Option(required=false, description="Only mark the Java version when this type is in use.", example="lombok.val")
    @Nullable
    private final String whenUsesType;

    public String getDisplayName() {
        return "List calculated information about Java version on source files";
    }

    public String getDescription() {
        return "A diagnostic for studying the applicability of Java version constraints.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return StringUtils.isBlank((String)this.whenUsesType) ? null : new UsesType(this.whenUsesType);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                return cu.getMarkers().findFirst(JavaVersion.class).map(version -> (JavaSourceFile)SearchResult.found((Tree)cu, (String)("Java version: " + version.getMajorVersion()))).orElse(cu);
            }
        };
    }

    @ConstructorProperties(value={"whenUsesType"})
    public AboutJavaVersion(@Nullable String whenUsesType) {
        this.whenUsesType = whenUsesType;
    }

    @Nullable
    public String getWhenUsesType() {
        return this.whenUsesType;
    }

    @NonNull
    public String toString() {
        return "AboutJavaVersion(whenUsesType=" + this.getWhenUsesType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AboutJavaVersion)) {
            return false;
        }
        AboutJavaVersion other = (AboutJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$whenUsesType = this.getWhenUsesType();
        String other$whenUsesType = other.getWhenUsesType();
        return !(this$whenUsesType == null ? other$whenUsesType != null : !this$whenUsesType.equals(other$whenUsesType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AboutJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $whenUsesType = this.getWhenUsesType();
        result = result * 59 + ($whenUsesType == null ? 43 : $whenUsesType.hashCode());
        return result;
    }
}

