/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Refaster style Guava to Java migration recipes", description="Recipes that migrate from Guava to Java, using Refaster style templates for cases beyond what declarative recipes can cover.")
public class NoGuavaRefaster {

    @RecipeDescriptor(name="`Preconditions.checkNotNull` with `Object` message to `Objects.requireNonNull` with `String.valueOf`", description="Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.")
    public static class PreconditionsCheckNotNullWithMessageToObjectsRequireNonNullMessageTypeObject {
        Object before(Object object, Object message) {
            return Preconditions.checkNotNull((Object)object, (Object)message);
        }

        Object after(Object object, Object message) {
            return Objects.requireNonNull(object, String.valueOf(message));
        }
    }

    @RecipeDescriptor(name="`Preconditions.checkNotNull` with `String` message to `Objects.requireNonNull`", description="Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.")
    public static class PreconditionsCheckNotNullWithMessageToObjectsRequireNonNull {
        Object before(Object object, String message) {
            return Preconditions.checkNotNull((Object)object, (Object)message);
        }

        Object after(Object object, String message) {
            return Objects.requireNonNull(object, message);
        }
    }

    @RecipeDescriptor(name="`Preconditions.checkNotNull` to `Objects.requireNonNull`", description="Migrate from Guava `Preconditions.checkNotNull` to Java 8 `java.util.Objects.requireNonNull`.")
    public static class PreconditionsCheckNotNullToObjectsRequireNonNull {
        Object before(Object object) {
            return Preconditions.checkNotNull((Object)object);
        }

        Object after(Object object) {
            return Objects.requireNonNull(object);
        }
    }
}

