/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import fj.data.Option;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.analysis.dataflow.Dataflow;
import org.openrewrite.analysis.dataflow.analysis.SinkFlowSummary;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.joda.JodaTimeFlowSpec;
import org.openrewrite.java.migrate.joda.JodaTimeRecipe;
import org.openrewrite.java.migrate.joda.JodaTimeVisitor;
import org.openrewrite.java.migrate.joda.SafeCheckMarker;
import org.openrewrite.java.migrate.joda.ScopeAwareVisitor;
import org.openrewrite.java.migrate.joda.templates.TimeClassNames;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.Marker;

class JodaTimeScanner
extends ScopeAwareVisitor {
    private final JodaTimeRecipe.Accumulator acc;
    private final Map<J.VariableDeclarations.NamedVariable, Set<J.VariableDeclarations.NamedVariable>> varDependencies = new HashMap<J.VariableDeclarations.NamedVariable, Set<J.VariableDeclarations.NamedVariable>>();
    private final Map<JavaType, Set<String>> unsafeVarsByType = new HashMap<JavaType, Set<String>>();

    public JodaTimeScanner(JodaTimeRecipe.Accumulator acc) {
        super(new LinkedList<ScopeAwareVisitor.VariablesInScope>());
        this.acc = acc;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
        super.visitCompilationUnit(cu, (Object)ctx);
        HashSet<J.VariableDeclarations.NamedVariable> allReachable = new HashSet<J.VariableDeclarations.NamedVariable>();
        for (J.VariableDeclarations.NamedVariable var : this.acc.getUnsafeVars()) {
            this.dfs(var, allReachable);
        }
        this.acc.getUnsafeVars().addAll(allReachable);
        return cu;
    }

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
        if (!variable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return variable;
        }
        if (this.isClassVar(variable)) {
            this.acc.getUnsafeVars().add(variable);
            return variable;
        }
        if (!(variable = (J.VariableDeclarations.NamedVariable)super.visitVariable(variable, (Object)ctx)).getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return variable;
        }
        boolean isMethodParam = this.getCursor().getParentTreeCursor().getParentTreeCursor().getValue() instanceof J.MethodDeclaration;
        Cursor cursor = null;
        if (isMethodParam) {
            cursor = this.getCursor();
        } else if (variable.getInitializer() != null) {
            cursor = new Cursor(this.getCursor(), (Object)variable.getInitializer());
        }
        if (cursor == null) {
            return variable;
        }
        List<Expression> sinks = this.findSinks(cursor);
        Cursor currentScope = this.getCurrentScope();
        new AddSafeCheckMarker(sinks).visit((Tree)currentScope.getValue(), ctx, currentScope.getParentOrThrow());
        this.processMarkersOnExpression(sinks, variable);
        return variable;
    }

    public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
        Expression var = assignment.getVariable();
        if (!this.isJodaExpr(var) || !(var instanceof J.Identifier)) {
            return assignment;
        }
        J.Identifier ident = (J.Identifier)var;
        Optional<J.VariableDeclarations.NamedVariable> mayBeVar = this.findVarInScope(ident.getSimpleName());
        if (!mayBeVar.isPresent()) {
            return assignment;
        }
        J.VariableDeclarations.NamedVariable variable = mayBeVar.get();
        Cursor varScope = this.findScope(variable);
        List<Expression> sinks = this.findSinks(new Cursor(this.getCursor(), (Object)assignment.getAssignment()));
        new AddSafeCheckMarker(sinks).visit((Tree)varScope.getValue(), ctx, varScope.getParentOrThrow());
        this.processMarkersOnExpression(sinks, variable);
        return assignment;
    }

    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
        this.acc.getVarTable().addVars(method);
        this.unsafeVarsByType.getOrDefault(method.getMethodType(), Collections.emptySet()).forEach(varName -> {
            J.VariableDeclarations.NamedVariable var = this.acc.getVarTable().getVarByName((JavaType)method.getMethodType(), (String)varName);
            if (var != null) {
                this.acc.getUnsafeVars().add(var);
            }
        });
        return (J.MethodDeclaration)super.visitMethodDeclaration(method, (Object)ctx);
    }

    private void processMarkersOnExpression(List<Expression> expressions, J.VariableDeclarations.NamedVariable var) {
        for (Expression expr : expressions) {
            Optional mayBeMarker = expr.getMarkers().findFirst(SafeCheckMarker.class);
            if (!mayBeMarker.isPresent()) continue;
            SafeCheckMarker marker = (SafeCheckMarker)mayBeMarker.get();
            if (!marker.isSafe()) {
                this.acc.getUnsafeVars().add(var);
            }
            if (marker.getReferences().isEmpty()) continue;
            this.varDependencies.compute(var, (k, v) -> v == null ? new HashSet() : v).addAll(marker.getReferences());
            for (J.VariableDeclarations.NamedVariable ref : marker.getReferences()) {
                this.varDependencies.compute(ref, (k, v) -> v == null ? new HashSet() : v).add(var);
            }
        }
    }

    private boolean isJodaExpr(Expression expression) {
        return expression.getType() != null && expression.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN);
    }

    private List<Expression> findSinks(Cursor cursor) {
        Option mayBeSinks = Dataflow.startingAt((Cursor)cursor).findSinks((DataFlowSpec)new JodaTimeFlowSpec());
        if (mayBeSinks.isNone()) {
            return Collections.emptyList();
        }
        return ((SinkFlowSummary)mayBeSinks.some()).getExpressionSinks();
    }

    private boolean isClassVar(J.VariableDeclarations.NamedVariable variable) {
        return variable.getVariableType().getOwner() instanceof JavaType.Class;
    }

    private void dfs(J.VariableDeclarations.NamedVariable root, Set<J.VariableDeclarations.NamedVariable> visited) {
        if (visited.contains(root)) {
            return;
        }
        visited.add(root);
        for (J.VariableDeclarations.NamedVariable dep : this.varDependencies.getOrDefault(root, Collections.emptySet())) {
            this.dfs(dep, visited);
        }
    }

    @Generated
    public JodaTimeRecipe.Accumulator getAcc() {
        return this.acc;
    }

    private class AddSafeCheckMarker
    extends JavaIsoVisitor<ExecutionContext> {
        @NonNull
        private List<Expression> expressions;

        public Expression visitExpression(Expression expression, ExecutionContext ctx) {
            Optional<Cursor> mayBeArgCursor;
            int index = this.expressions.indexOf(expression);
            if (index == -1) {
                return super.visitExpression(expression, (Object)ctx);
            }
            SafeCheckMarker marker = this.getMarker(expression, ctx);
            if (!marker.isSafe() && (mayBeArgCursor = this.findArgumentExprCursor()).isPresent()) {
                MethodCall parentMethod = (MethodCall)mayBeArgCursor.get().getParentTreeCursor().getValue();
                int argPos = parentMethod.getArguments().indexOf(mayBeArgCursor.get().getValue());
                String paramName = (String)parentMethod.getMethodType().getParameterNames().get(argPos);
                JodaTimeScanner.this.unsafeVarsByType.computeIfAbsent(parentMethod.getMethodType(), k -> new HashSet()).add(paramName);
            }
            Expression withMarker = (Expression)expression.withMarkers(expression.getMarkers().addIfAbsent((Marker)marker));
            this.expressions.set(index, withMarker);
            return withMarker;
        }

        private SafeCheckMarker getMarker(Expression expr, ExecutionContext ctx) {
            Optional mayBeMarker = expr.getMarkers().findFirst(SafeCheckMarker.class);
            if (mayBeMarker.isPresent()) {
                return (SafeCheckMarker)mayBeMarker.get();
            }
            Cursor boundary = this.findBoundaryCursorForJodaExpr();
            boolean isSafe = true;
            if (boundary.getParentTreeCursor().getValue() instanceof J.Return) {
                isSafe = false;
            }
            Expression boundaryExpr = (Expression)boundary.getValue();
            J j = (J)new JodaTimeVisitor(new JodaTimeRecipe.Accumulator(), false, JodaTimeScanner.this.scopes).visit((Tree)boundaryExpr, ctx, boundary.getParentTreeCursor());
            HashSet<// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.VariableDeclarations.NamedVariable> referencedVars = new HashSet<J.VariableDeclarations.NamedVariable>();
            new FindVarReferences().visit((Tree)expr, referencedVars, this.getCursor().getParentTreeCursor());
            AtomicBoolean hasJodaType = new AtomicBoolean();
            new HasJodaType().visit((Tree)j, hasJodaType);
            isSafe = isSafe && !hasJodaType.get() && !referencedVars.contains(null);
            referencedVars.remove(null);
            return new SafeCheckMarker(UUID.randomUUID(), isSafe, referencedVars);
        }

        private Cursor findBoundaryCursorForJodaExpr() {
            Cursor cursor = this.getCursor();
            while (cursor.getValue() instanceof Expression && JodaTimeScanner.this.isJodaExpr((Expression)cursor.getValue())) {
                Cursor parent = cursor.getParentTreeCursor();
                if (parent.getValue() instanceof J && !(parent.getValue() instanceof Expression)) {
                    return cursor;
                }
                cursor = parent;
            }
            return cursor;
        }

        private Optional<Cursor> findArgumentExprCursor() {
            Cursor cursor = this.getCursor();
            while (cursor.getValue() instanceof Expression && JodaTimeScanner.this.isJodaExpr((Expression)cursor.getValue())) {
                Cursor parentCursor = cursor.getParentTreeCursor();
                if (parentCursor.getValue() instanceof MethodCall && ((MethodCall)parentCursor.getValue()).getArguments().contains(cursor.getValue())) {
                    return Optional.of(cursor);
                }
                cursor = parentCursor;
            }
            return Optional.empty();
        }

        @ConstructorProperties(value={"expressions"})
        @Generated
        public AddSafeCheckMarker(List<Expression> expressions) {
            if (expressions == null) {
                throw new NullPointerException("expressions is marked non-null but is null");
            }
            this.expressions = expressions;
        }
    }

    private static class HasJodaType
    extends JavaIsoVisitor<AtomicBoolean> {
        private HasJodaType() {
        }

        public Expression visitExpression(Expression expression, AtomicBoolean hasJodaType) {
            if (hasJodaType.get()) {
                return expression;
            }
            if (expression.getType() != null && expression.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
                hasJodaType.set(true);
            }
            return super.visitExpression(expression, (Object)hasJodaType);
        }
    }

    private class FindVarReferences
    extends JavaIsoVisitor<Set<J.VariableDeclarations.NamedVariable>> {
        private FindVarReferences() {
        }

        public J.Identifier visitIdentifier(J.Identifier ident, Set<// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.VariableDeclarations.NamedVariable> vars) {
            if (!JodaTimeScanner.this.isJodaExpr((Expression)ident) || ident.getFieldType() == null) {
                return ident;
            }
            if (ident.getFieldType().getOwner() instanceof JavaType.Class) {
                vars.add(null);
            }
            JodaTimeScanner.this.findVarInScope(ident.getSimpleName()).ifPresent(vars::add);
            return ident;
        }
    }
}

