/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.time.Duration;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodTargetToStatic;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class MockUtilsToStatic
extends Recipe {
    public String getDisplayName() {
        return "Use static form of Mockito `MockUtil`";
    }

    public String getDescription() {
        return "Best-effort attempt to remove Mockito `MockUtil` instances.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MockUtilsToStaticVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.mockito.internal.util.MockUtil");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public static class MockUtilsToStaticVisitor
    extends JavaVisitor<ExecutionContext> {
        private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("org.mockito.internal.util.MockUtil <constructor>()");
        private final ChangeMethodTargetToStatic changeMethodTargetToStatic = new ChangeMethodTargetToStatic("org.mockito.internal.util.MockUtil *(..)", "org.mockito.internal.util.MockUtil", null, null);

        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.doAfterVisit((Recipe)this.changeMethodTargetToStatic);
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            if (METHOD_MATCHER.matches(newClass)) {
                Cursor parent = this.getCursor().dropParentUntil(J.class::isInstance);
                if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable) {
                    Object namedVar = parent.dropParentUntil(J.class::isInstance).getValue();
                    if (namedVar instanceof J.VariableDeclarations) {
                        this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)((J.VariableDeclarations)namedVar)));
                    }
                }
            }
            return super.visitNewClass(newClass, (Object)ctx);
        }
    }
}

