/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.DistinctGitProvenance;

public class FindGitProvenance
extends Recipe {
    private final DistinctGitProvenance distinct = new DistinctGitProvenance(this);

    @Override
    public String getDisplayName() {
        return "Show Git source control metadata";
    }

    @Override
    public String getDescription() {
        return "List out the contents of each unique `GitProvenance` marker in the set of source files. When everything is working correctly, exactly one such marker should be printed as all source files are expected to come from the same repository / branch / commit hash.";
    }

    @Override
    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        HashSet provenances = new HashSet();
        UUID dontConsiderIdInHashCode = UUID.randomUUID();
        return ListUtils.map(before, sourceFile -> {
            GitProvenance provenance = sourceFile.getMarkers().findFirst(GitProvenance.class).orElse(null);
            if (provenance == null || !provenances.add(provenance.withId(dontConsiderIdInHashCode))) {
                return sourceFile;
            }
            this.distinct.insertRow(ctx, new DistinctGitProvenance.Row(provenance.getOrigin(), provenance.getBranch(), provenance.getChange(), provenance.getAutocrlf(), provenance.getEol()));
            return Markup.info(sourceFile, String.format("GitProvenance:\n    origin: %s\n    branch: %s\n    changeset: %s\n    autocrlf: %s\n    eol: %s", provenance.getOrigin(), provenance.getBranch(), provenance.getChange(), provenance.getAutocrlf() != null ? provenance.getAutocrlf().toString() : "null", provenance.getEol() != null ? provenance.getEol().toString() : "null"));
        });
    }
}

