/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;

public class InMemoryExecutionContext
implements ExecutionContext {
    private final Map<String, Object> messages = new ConcurrentHashMap<String, Object>();
    private final Consumer<Throwable> onError;
    private final BiConsumer<Throwable, ExecutionContext> onTimeout;

    public InMemoryExecutionContext() {
        this(t -> {});
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError) {
        this(onError, Duration.ofHours(2L));
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError, Duration runTimeout) {
        this(onError, runTimeout, (throwable, ctx) -> {});
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError, Duration runTimeout, BiConsumer<Throwable, ExecutionContext> onTimeout) {
        this.onError = onError;
        this.onTimeout = onTimeout;
        this.putMessage("org.openrewrite.runTimeout", runTimeout);
    }

    @Override
    public void putMessage(String key, @Nullable Object value) {
        if (value == null) {
            this.messages.remove(key);
        } else {
            this.messages.put(key, value);
        }
    }

    @Override
    public <T> @Nullable T getMessage(String key) {
        return (T)this.messages.get(key);
    }

    @Override
    public <T> @Nullable T pollMessage(String key) {
        return (T)this.messages.remove(key);
    }

    @Override
    public Consumer<Throwable> getOnError() {
        return this.onError;
    }

    @Override
    public BiConsumer<Throwable, ExecutionContext> getOnTimeout() {
        return this.onTimeout;
    }
}

