/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.function.Consumer;
import java.util.function.Function;

public class MetricsHelper {
    public static void record(String timerName, Consumer<Timer.Builder> f) {
        Timer.Builder timer = Timer.builder((String)timerName);
        Timer.Sample sample = Timer.start();
        try {
            f.accept(timer);
            sample.stop(MetricsHelper.successTags(timer).register((MeterRegistry)Metrics.globalRegistry));
        }
        catch (Throwable t) {
            sample.stop(MetricsHelper.errorTags(timer, t).register((MeterRegistry)Metrics.globalRegistry));
            throw t;
        }
    }

    public static <U> U record(String timerName, Function<Timer.Builder, U> f) {
        Timer.Builder timer = Timer.builder((String)timerName);
        Timer.Sample sample = Timer.start();
        try {
            U returnVal = f.apply(timer);
            sample.stop(MetricsHelper.successTags(timer).register((MeterRegistry)Metrics.globalRegistry));
            return returnVal;
        }
        catch (Throwable t) {
            sample.stop(MetricsHelper.errorTags(timer, t).register((MeterRegistry)Metrics.globalRegistry));
            throw t;
        }
    }

    public static Timer.Builder successTags(Timer.Builder timer) {
        return MetricsHelper.successTags(timer, "none");
    }

    public static Timer.Builder successTags(Timer.Builder timer, String reason) {
        return timer.tag("outcome", "success").tag("reason", reason).tag("exception", "none").tag("exception.line", "none").tag("exception.declaring.class", "none");
    }

    public static Timer.Builder errorTags(Timer.Builder timer, Throwable t) {
        return MetricsHelper.errorTags(timer, "none", t);
    }

    public static Timer.Builder errorTags(Timer.Builder timer, String reason, Throwable t) {
        StackTraceElement stackTraceElement = null;
        if (t.getStackTrace().length > 0) {
            stackTraceElement = t.getStackTrace()[0];
        }
        String exceptionLine = "none";
        String exceptionDeclaringClass = "none";
        if (stackTraceElement != null) {
            exceptionLine = Integer.toString(stackTraceElement.getLineNumber());
            exceptionDeclaringClass = stackTraceElement.getClassName();
        }
        return timer.tag("outcome", "error").tag("reason", reason).tag("exception", t.getClass().getSimpleName()).tag("exception.line", exceptionLine).tag("exception.declaring.class", exceptionDeclaringClass);
    }
}

