/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.BitSet;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplacePrinter {
    private final Options options;

    public RecipeMarketplacePrinter() {
        this.options = Options.builder().build();
    }

    public RecipeMarketplacePrinter(Consumer<Options.Builder> optionsConfigurer) {
        Options.Builder builder = Options.builder();
        optionsConfigurer.accept(builder);
        this.options = builder.build();
    }

    public String print(RecipeMarketplace marketplace) {
        StringJoiner out = new StringJoiner("\n");
        this.print(marketplace, out, 0, this.options, new BitSet());
        return out.toString();
    }

    private void print(RecipeMarketplace marketplace, StringJoiner out, int level, Options options, BitSet lastCategoryMask) {
        StringBuilder line = new StringBuilder();
        RecipeMarketplacePrinter.printTreeLines(line, level, lastCategoryMask);
        if (level > 0) {
            line.append("|-");
        }
        line.append(marketplace.isRoot() ? "\u221a" : "\ud83d\udcc1");
        String displayName = marketplace.getDisplayName();
        switch (options.getNameStyle().ordinal()) {
            case 0: 
            case 1: {
                line.append(displayName);
                break;
            }
            case 2: {
                line.append(displayName);
                if (marketplace.getDescription().isEmpty()) break;
                line.append(" (").append(marketplace.getDescription()).append(')');
            }
        }
        out.add(line);
        Collection<RecipeMarketplace> categories = marketplace.getCategories();
        if (options.isOmitEmptyCategories()) {
            categories = categories.stream().filter(cat -> !cat.getRecipes().isEmpty() || !cat.getCategories().isEmpty()).collect(Collectors.toList());
        }
        int i = 0;
        for (RecipeMarketplace category : categories) {
            if (++i == categories.size()) {
                lastCategoryMask.set(level, true);
            }
            this.print(category, out, level + 1, options, (BitSet)lastCategoryMask.clone());
        }
        lastCategoryMask.set(level, true);
        ++level;
        for (RecipeListing recipe : marketplace.getRecipes()) {
            StringBuilder recipeLine = new StringBuilder();
            RecipeMarketplacePrinter.printTreeLines(recipeLine, level, lastCategoryMask);
            recipeLine.append("|-\ud83e\udd16");
            switch (options.getNameStyle().ordinal()) {
                case 0: {
                    recipeLine.append(recipe.getDisplayName());
                    break;
                }
                case 1: {
                    recipeLine.append(recipe.getName());
                    break;
                }
                case 2: {
                    recipeLine.append(recipe.getDisplayName()).append(" (").append(recipe.getName()).append(')');
                }
            }
            out.add(recipeLine);
        }
    }

    private static void printTreeLines(StringBuilder line, int level, BitSet lastCategoryMask) {
        for (int i = 0; i < level - 1; ++i) {
            if (lastCategoryMask.get(i)) {
                line.append("   ");
                continue;
            }
            line.append("\u2502  ");
        }
    }

    @Generated
    public RecipeMarketplacePrinter(Options options) {
        this.options = options;
    }

    public static final class Options {
        private final boolean omitEmptyCategories;
        private final NameStyle nameStyle;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Options(boolean omitEmptyCategories, NameStyle nameStyle) {
            this.omitEmptyCategories = omitEmptyCategories;
            this.nameStyle = nameStyle;
        }

        @Generated
        public boolean isOmitEmptyCategories() {
            return this.omitEmptyCategories;
        }

        @Generated
        public NameStyle getNameStyle() {
            return this.nameStyle;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (this.isOmitEmptyCategories() != other.isOmitEmptyCategories()) {
                return false;
            }
            NameStyle this$nameStyle = this.getNameStyle();
            NameStyle other$nameStyle = other.getNameStyle();
            return !(this$nameStyle == null ? other$nameStyle != null : !((Object)((Object)this$nameStyle)).equals((Object)other$nameStyle));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOmitEmptyCategories() ? 79 : 97);
            NameStyle $nameStyle = this.getNameStyle();
            result = result * 59 + ($nameStyle == null ? 43 : ((Object)((Object)$nameStyle)).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeMarketplacePrinter.Options(omitEmptyCategories=" + this.isOmitEmptyCategories() + ", nameStyle=" + (Object)((Object)this.getNameStyle()) + ")";
        }

        public static class Builder {
            private boolean omitEmptyCategories = true;
            private NameStyle nameStyle = NameStyle.ID;

            public Builder omitEmptyCategories(boolean omitEmptyCategories) {
                this.omitEmptyCategories = omitEmptyCategories;
                return this;
            }

            public Builder nameStyle(NameStyle nameStyle) {
                this.nameStyle = nameStyle;
                return this;
            }

            public Options build() {
                return new Options(this.omitEmptyCategories, this.nameStyle);
            }
        }
    }

    public static enum NameStyle {
        DISPLAY_NAME,
        ID,
        BOTH;

    }
}

