/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;

@Deprecated
public class CategoryTree<G> {
    static final String CORE = "core";
    final Object lock = new Object();
    private final List<G> groups = new ArrayList<G>(3);
    private final Collection<CategoryTree<G>> subtrees = new ArrayList<CategoryTree<G>>();
    private final Map<G, CategoryDescriptor> descriptorsByGroup = new HashMap<G, CategoryDescriptor>();
    private final Map<G, Collection<RecipeDescriptor>> recipesByGroup = new HashMap<G, Collection<RecipeDescriptor>>();

    CategoryTree() {
    }

    private CategoryTree(G group, CategoryDescriptor descriptor) {
        this.descriptorsByGroup.put(group, descriptor);
        this.groups.add(group);
    }

    public static <G> Root<G> build() {
        return new Root();
    }

    public CategoryDescriptor getDescriptor() {
        CategoryDescriptor categoryDescriptor = null;
        int currentPriority = -1;
        for (G group : this.groups) {
            CategoryDescriptor test = this.descriptorsByGroup.get(group);
            if (test.isSynthetic() || test.getPriority() <= currentPriority) continue;
            categoryDescriptor = test;
            currentPriority = test.getPriority();
        }
        if (categoryDescriptor == null) {
            Iterator<G> iterator = this.groups.iterator();
            if (iterator.hasNext()) {
                G group;
                group = iterator.next();
                categoryDescriptor = this.descriptorsByGroup.get(group);
            }
            if (categoryDescriptor == null) {
                throw new IllegalStateException("Unable to find a descriptor for category. This represents a bug in CategoryTree, since it should never occur.");
            }
        }
        return categoryDescriptor;
    }

    public Integer getRecipeCount() {
        int sum = 0;
        for (Collection<RecipeDescriptor> collection : this.getRecipesByGroup().values()) {
            sum += collection.size();
        }
        for (CategoryTree categoryTree : this.subtrees) {
            sum += categoryTree.getRecipeCount().intValue();
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable CategoryTree<G> getCategory(String subcategory) {
        String packageName = this.getDescriptor().getPackageName();
        Object object = this.lock;
        synchronized (object) {
            String[] split = subcategory.split("\\.", 2);
            for (CategoryTree<G> t : this.getCategories(false, true)) {
                String tPackage = t.getDescriptor().getPackageName();
                int endIndex = tPackage.indexOf(46, packageName.length() + 1);
                String test = tPackage.substring(packageName.isEmpty() ? 0 : packageName.length() + 1, endIndex < 0 ? tPackage.length() : endIndex);
                if (!split[0].equals(test)) continue;
                if (split.length == 1) {
                    return t;
                }
                return t.getCategory(split[1]);
            }
        }
        return null;
    }

    public @Nullable CategoryTree<G> getCategory(String ... subcategories) {
        CategoryTree<G> acc = this;
        for (String subcategory : subcategories) {
            if (acc == null) {
                return null;
            }
            acc = acc.getCategory(subcategory);
        }
        return acc;
    }

    public CategoryTree<G> getCategoryOrThrow(String subcategory) {
        CategoryTree<G> subtree = this.getCategory(subcategory);
        if (subtree == null) {
            throw new IllegalArgumentException("No subcategory of " + this.getDescriptor().getPackageName() + " named '" + subcategory + "'");
        }
        return subtree;
    }

    public CategoryTree<G> getCategoryOrThrow(String ... subcategories) {
        CategoryTree<G> acc = this;
        for (String subcategory : subcategories) {
            for (String subsubcategory : subcategory.split("\\.")) {
                acc = acc.getCategoryOrThrow(subsubcategory);
            }
        }
        return acc;
    }

    public @Nullable RecipeDescriptor getRecipe(String id) {
        if (id.contains(".")) {
            String[] split = id.split("\\.", 2);
            CategoryTree<G> subcategory = this.getCategory(split[0]);
            return subcategory == null ? null : subcategory.getRecipe(split[1]);
        }
        for (Collection<RecipeDescriptor> recipeDescriptors : this.recipesByGroup.values()) {
            for (RecipeDescriptor r : recipeDescriptors) {
                if (!r.getName().substring(r.getName().lastIndexOf(46) + 1).equals(id)) continue;
                return r;
            }
        }
        return null;
    }

    public @Nullable G getRecipeGroup(String id) {
        if (id.contains(".")) {
            String[] split = id.split("\\.", 2);
            CategoryTree<G> subcategory = this.getCategory(split[0]);
            return subcategory == null ? null : (G)subcategory.getRecipeGroup(split[1]);
        }
        for (Map.Entry<G, Collection<RecipeDescriptor>> g : this.recipesByGroup.entrySet()) {
            for (RecipeDescriptor r : g.getValue()) {
                if (!r.getName().substring(r.getName().lastIndexOf(46) + 1).equals(id)) continue;
                return g.getKey();
            }
        }
        return null;
    }

    CategoryTree<G> findOrAddCategory(G group, CategoryDescriptor category) {
        String packageName = this.getDescriptor().getPackageName();
        String categoryPackage = category.getPackageName();
        if (categoryPackage.equals(packageName)) {
            if (!this.groups.contains(group)) {
                this.groups.add(0, group);
                this.descriptorsByGroup.put(group, category);
            }
            if (!category.isSynthetic()) {
                this.descriptorsByGroup.put(group, category);
            }
            return this;
        }
        if (packageName.isEmpty() || categoryPackage.startsWith(packageName + ".") && categoryPackage.charAt(packageName.length()) == '.') {
            String subpackage;
            CategoryTree<G> subtree2;
            for (CategoryTree<G> subtree2 : this.subtrees) {
                String subtreePackage = subtree2.getDescriptor().getPackageName();
                if (!subtreePackage.equals(categoryPackage) && !categoryPackage.startsWith(subtreePackage + ".")) continue;
                if (!subtree2.groups.contains(group)) {
                    subtree2.groups.add(0, group);
                    subtree2.descriptorsByGroup.put(group, new CategoryDescriptor(StringUtils.capitalize(subtreePackage.substring(subtreePackage.lastIndexOf(46) + 1)), subtreePackage, "", Collections.emptySet(), false, -1, true));
                }
                return subtree2.findOrAddCategory(group, category);
            }
            String string = subpackage = packageName.isEmpty() ? category.getPackageName() : category.getPackageName().substring(packageName.length() + 1);
            if (subpackage.contains(".")) {
                String displayName = subpackage.substring(0, subpackage.indexOf(46));
                StringJoiner intermediatePackage = new StringJoiner(".");
                if (!packageName.isEmpty()) {
                    intermediatePackage.add(packageName);
                }
                intermediatePackage.add(displayName);
                return this.findOrAddCategory(group, new CategoryDescriptor(StringUtils.capitalize(displayName), intermediatePackage.toString(), "", Collections.emptySet(), false, -1, true)).findOrAddCategory(group, category);
            }
            subtree2 = new CategoryTree<G>(group, category);
            this.subtrees.add(subtree2);
            return subtree2;
        }
        throw new IllegalStateException("Attempted to add a category with package '" + category.getPackageName() + "' as a subcategory of '" + packageName + "'. This represents a bug in CategoryTree, as it should not be possible to add a category to a CategoryTree root that cannot be placed somewhere in the tree.");
    }

    void addRecipe(G group, RecipeDescriptor recipe) {
        if (recipe.getName() == null) {
            throw new IllegalArgumentException("Expected recipe to have a name");
        }
        if (!recipe.getName().contains(".")) {
            throw new IllegalArgumentException("Expected recipe with name '" + recipe.getName() + "' to have a package, but it did not.");
        }
        String category = recipe.getName().substring(0, recipe.getName().lastIndexOf(46));
        CategoryTree<G> categoryTree = this.findOrAddCategory(group, new CategoryDescriptor(StringUtils.capitalize(category.substring(category.lastIndexOf(46) + 1)), category, "", Collections.emptySet(), false, -1, true));
        categoryTree.recipesByGroup.computeIfAbsent(group, g -> new CopyOnWriteArrayList()).add(recipe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CategoryTree<G> removeAll(G group) {
        Object object = this.lock;
        synchronized (object) {
            this.groups.remove(group);
            this.descriptorsByGroup.remove(group);
            this.recipesByGroup.remove(group);
            for (CategoryTree<G> subtree2 : this.subtrees) {
                subtree2.removeAll(group);
            }
            this.subtrees.removeIf(subtree -> subtree.groups.isEmpty());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RecipeDescriptor> getRecipes() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.subtrees.isEmpty()) {
                return Collections.emptyList();
            }
            return this.getRecipesByGroup().values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<G, Collection<RecipeDescriptor>> getRecipesByGroup() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(new HashMap<G, Collection<RecipeDescriptor>>(this.recipesByGroup));
        }
    }

    public Collection<CategoryTree<G>> getCategories() {
        return this.getCategories(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CategoryTree<G>> getCategories(boolean omitCategoryRoots, boolean omitEmptyCategories) {
        Object object = this.lock;
        synchronized (object) {
            CategoryTree<G> core;
            ArrayList<CategoryTree<G>> cats = new ArrayList<CategoryTree<G>>(this.subtrees.size());
            for (CategoryTree<G> subtree : this.subtrees) {
                if (omitCategoryRoots && subtree.getDescriptor().isRoot()) {
                    cats.addAll(subtree.getCategories());
                    continue;
                }
                if (omitEmptyCategories && subtree.getRecipes().isEmpty() && subtree.getCategories().isEmpty()) continue;
                cats.add(subtree);
            }
            if (!this.subtrees.isEmpty() && (core = this.maybeAddCore(this.getDescriptor())) != null) {
                cats.add(core);
            }
            return cats;
        }
    }

    private @Nullable CategoryTree<G> maybeAddCore(final CategoryDescriptor parent) {
        if (this.recipesByGroup.isEmpty()) {
            return null;
        }
        return new CategoryTree<G>(){

            @Override
            public CategoryDescriptor getDescriptor() {
                return new CategoryDescriptor("Core", parent.getPackageName() + "." + CategoryTree.CORE, "", Collections.emptySet(), false, -1, true);
            }

            @Override
            public Map<G, Collection<RecipeDescriptor>> getRecipesByGroup() {
                return CategoryTree.this.recipesByGroup;
            }
        };
    }

    public String toString() {
        return "CategoryTree{packageName=" + this.getDescriptor().getPackageName() + "}";
    }

    void toString(StringJoiner out, int level, PrintOptions printOptions, BitSet lastCategoryMask) {
        if (level > printOptions.getMaxDepth()) {
            return;
        }
        CategoryDescriptor descriptor = this.getDescriptor();
        if (!printOptions.isOmitCategoryRoots() || !descriptor.isRoot()) {
            StringBuilder line = new StringBuilder();
            this.printTreeLines(line, level, lastCategoryMask);
            if (level > 0) {
                line.append("|-");
            }
            line.append(descriptor.isRoot() ? "\u221a" : "\ud83d\udcc1");
            String packageName = descriptor.getPackageName().isEmpty() ? "\u03b5" : descriptor.getPackageName();
            switch (printOptions.getNameStyle().ordinal()) {
                case 0: {
                    line.append(descriptor.getDisplayName());
                    break;
                }
                case 1: {
                    line.append(packageName);
                    break;
                }
                case 2: {
                    if (descriptor.getPackageName().isEmpty()) {
                        line.append(packageName);
                        break;
                    }
                    line.append(descriptor.getDisplayName()).append(" (").append(packageName).append(')');
                }
            }
            out.add(line);
        }
        Collection<CategoryTree<G>> categories = this.getCategories(printOptions.isOmitCategoryRoots(), printOptions.isOmitEmptyCategories());
        int i = 0;
        for (CategoryTree<G> subtree : categories) {
            if (++i == categories.size()) {
                lastCategoryMask.set(level, true);
            }
            subtree.toString(out, descriptor.isRoot() && printOptions.isOmitCategoryRoots() ? level : level + 1, printOptions, (BitSet)lastCategoryMask.clone());
        }
        lastCategoryMask.set(level, true);
        ++level;
        for (RecipeDescriptor recipe : this.getRecipes()) {
            StringBuilder line = new StringBuilder();
            this.printTreeLines(line, level, lastCategoryMask);
            line.append("|-\ud83e\udd16");
            switch (printOptions.getNameStyle().ordinal()) {
                case 0: {
                    line.append(recipe.getDisplayName());
                    break;
                }
                case 1: {
                    line.append(recipe.getName());
                    break;
                }
                case 2: {
                    line.append(recipe.getDisplayName()).append(" (").append(recipe.getName()).append(')');
                }
            }
            out.add(line);
        }
    }

    private void printTreeLines(StringBuilder line, int level, BitSet lastCategoryMask) {
        for (int i = 0; i < level - 1; ++i) {
            if (lastCategoryMask.get(i)) {
                line.append("   ");
                continue;
            }
            line.append("\u2502  ");
        }
    }

    public static class Root<G>
    extends CategoryTree<G> {
        private static final CategoryDescriptor ROOT_DESCRIPTOR = new CategoryDescriptor("\u03b5", "", "", Collections.emptySet(), true, -1, true);

        private Root() {
        }

        @Override
        public Root<G> removeAll(G group) {
            return (Root)super.removeAll(group);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Root<G> putAll(G group, Environment environment) {
            Object object = this.lock;
            synchronized (object) {
                return ((Root)this.removeAll((Object)group)).putRecipes(group, environment.listRecipeDescriptors().toArray(new RecipeDescriptor[0])).putCategories(group, environment.listCategoryDescriptors().toArray(new CategoryDescriptor[0]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Root<G> putRecipes(G group, RecipeDescriptor ... recipes) {
            Object object = this.lock;
            synchronized (object) {
                for (RecipeDescriptor recipe : recipes) {
                    this.addRecipe(group, recipe);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Root<G> putCategories(G group, CategoryDescriptor ... categories) {
            Object object = this.lock;
            synchronized (object) {
                for (CategoryDescriptor category : categories) {
                    this.findOrAddCategory(group, category);
                }
            }
            return this;
        }

        @Override
        public CategoryDescriptor getDescriptor() {
            return ROOT_DESCRIPTOR;
        }

        @Override
        public String toString() {
            return "CategoryTree{ROOT}";
        }

        public String print(PrintOptions printOptions) {
            StringJoiner out = new StringJoiner("\n");
            this.toString(out, 0, printOptions, new BitSet());
            return out.toString();
        }
    }

    public static final class PrintOptions {
        private final int maxDepth;
        private final boolean omitCategoryRoots;
        private final boolean omitEmptyCategories;
        private final PrintNameStyle nameStyle;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public PrintOptions(int maxDepth, boolean omitCategoryRoots, boolean omitEmptyCategories, PrintNameStyle nameStyle) {
            this.maxDepth = maxDepth;
            this.omitCategoryRoots = omitCategoryRoots;
            this.omitEmptyCategories = omitEmptyCategories;
            this.nameStyle = nameStyle;
        }

        @Generated
        public int getMaxDepth() {
            return this.maxDepth;
        }

        @Generated
        public boolean isOmitCategoryRoots() {
            return this.omitCategoryRoots;
        }

        @Generated
        public boolean isOmitEmptyCategories() {
            return this.omitEmptyCategories;
        }

        @Generated
        public PrintNameStyle getNameStyle() {
            return this.nameStyle;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrintOptions)) {
                return false;
            }
            PrintOptions other = (PrintOptions)o;
            if (this.getMaxDepth() != other.getMaxDepth()) {
                return false;
            }
            if (this.isOmitCategoryRoots() != other.isOmitCategoryRoots()) {
                return false;
            }
            if (this.isOmitEmptyCategories() != other.isOmitEmptyCategories()) {
                return false;
            }
            PrintNameStyle this$nameStyle = this.getNameStyle();
            PrintNameStyle other$nameStyle = other.getNameStyle();
            return !(this$nameStyle == null ? other$nameStyle != null : !((Object)((Object)this$nameStyle)).equals((Object)other$nameStyle));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxDepth();
            result = result * 59 + (this.isOmitCategoryRoots() ? 79 : 97);
            result = result * 59 + (this.isOmitEmptyCategories() ? 79 : 97);
            PrintNameStyle $nameStyle = this.getNameStyle();
            result = result * 59 + ($nameStyle == null ? 43 : ((Object)((Object)$nameStyle)).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "CategoryTree.PrintOptions(maxDepth=" + this.getMaxDepth() + ", omitCategoryRoots=" + this.isOmitCategoryRoots() + ", omitEmptyCategories=" + this.isOmitEmptyCategories() + ", nameStyle=" + (Object)((Object)this.getNameStyle()) + ")";
        }

        public static class Builder {
            private int maxDepth = Integer.MAX_VALUE;
            private boolean omitCategoryRoots = true;
            private boolean omitEmptyCategories = true;
            private PrintNameStyle nameStyle = PrintNameStyle.ID;

            public Builder maxDepth(int maxDepth) {
                this.maxDepth = maxDepth;
                return this;
            }

            public Builder omitCategoryRoots(boolean omitCategoryRoots) {
                this.omitCategoryRoots = omitCategoryRoots;
                return this;
            }

            public Builder omitEmptyCategories(boolean omitEmptyCategories) {
                this.omitEmptyCategories = omitEmptyCategories;
                return this;
            }

            public Builder nameStyle(PrintNameStyle nameStyle) {
                this.nameStyle = nameStyle;
                return this;
            }

            public PrintOptions build() {
                return new PrintOptions(this.maxDepth, this.omitCategoryRoots, this.omitEmptyCategories, this.nameStyle);
            }
        }
    }

    public static enum PrintNameStyle {
        DISPLAY_NAME,
        ID,
        BOTH;

    }
}

