/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeException;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.style.NamedStyles;

public class Environment {
    private final Collection<? extends ResourceLoader> resourceLoaders;
    private final Collection<? extends ResourceLoader> dependencyResourceLoaders;

    public List<Recipe> listRecipes() {
        ArrayList<Recipe> dependencyRecipes = new ArrayList<Recipe>();
        for (ResourceLoader resourceLoader : this.dependencyResourceLoaders) {
            dependencyRecipes.addAll(resourceLoader.listRecipes());
        }
        HashMap dependencyRecipeMap = new HashMap();
        dependencyRecipes.forEach(r -> dependencyRecipeMap.putIfAbsent(r.getName(), r));
        HashMap<String, List<RecipeExample>> hashMap = new HashMap<String, List<RecipeExample>>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            if (!(resourceLoader instanceof YamlResourceLoader)) continue;
            hashMap.putAll(resourceLoader.listRecipeExamples());
        }
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            recipes.addAll(resourceLoader.listRecipes());
        }
        for (Recipe recipe : dependencyRecipes) {
            if (!(recipe instanceof DeclarativeRecipe)) continue;
            ((DeclarativeRecipe)recipe).initialize(dependencyRecipeMap::get);
        }
        HashMap hashMap2 = new HashMap(dependencyRecipeMap);
        recipes.forEach(r -> availableRecipeMap.putIfAbsent(r.getName(), r));
        for (Recipe recipe : recipes) {
            if (hashMap.containsKey(recipe.getName())) {
                recipe.setExamples((List)hashMap.get(recipe.getName()));
            }
            if (!(recipe instanceof DeclarativeRecipe)) continue;
            ((DeclarativeRecipe)recipe).initialize(hashMap2::get);
        }
        return recipes;
    }

    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.resourceLoaders.stream().flatMap(r -> r.listCategoryDescriptors().stream()).collect(Collectors.toList());
    }

    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        HashMap<String, List<RecipeExample>> recipeToExamples = new HashMap<String, List<RecipeExample>>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            if (resourceLoader instanceof YamlResourceLoader) {
                recipeToExamples.putAll(resourceLoader.listRecipeExamples());
                continue;
            }
            if (!(resourceLoader instanceof ClasspathScanningLoader)) continue;
            ClasspathScanningLoader classpathScanningLoader = (ClasspathScanningLoader)resourceLoader;
            Map<String, List<RecipeExample>> examplesMap = classpathScanningLoader.listRecipeExamples();
            for (String key : examplesMap.keySet()) {
                if (recipeToExamples.containsKey(key)) {
                    ((List)recipeToExamples.get(key)).addAll((Collection)examplesMap.get(key));
                    continue;
                }
                recipeToExamples.put(key, examplesMap.get(key));
            }
        }
        ArrayList<RecipeDescriptor> result = new ArrayList<RecipeDescriptor>();
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            if (resourceLoader instanceof YamlResourceLoader) {
                result.addAll(((YamlResourceLoader)resourceLoader).listRecipeDescriptors(Collections.emptyList(), recipeToExamples));
                continue;
            }
            Collection<RecipeDescriptor> descriptors = resourceLoader.listRecipeDescriptors();
            for (RecipeDescriptor descriptor : descriptors) {
                if (!recipeToExamples.containsKey(descriptor.getName())) continue;
                descriptor.getExamples().addAll((Collection)recipeToExamples.get(descriptor.getName()));
            }
            result.addAll(descriptors);
        }
        return result;
    }

    @Deprecated
    public Recipe activateRecipes(Iterable<String> activeRecipes) {
        ArrayList<String> asList = new ArrayList<String>();
        for (String activeRecipe : activeRecipes) {
            asList.add(activeRecipe);
        }
        return this.activateRecipes((Collection<String>)asList);
    }

    public Recipe activateRecipes(Collection<String> activeRecipes) {
        List<Object> recipes;
        if (activeRecipes.isEmpty()) {
            recipes = Collections.emptyList();
        } else if (activeRecipes.size() == 1) {
            Recipe recipe = this.loadRecipe(activeRecipes.iterator().next(), ResourceLoader.RecipeDetail.EXAMPLES);
            if (recipe != null) {
                return recipe;
            }
            recipes = this.listRecipes();
        } else {
            recipes = this.listRecipes();
        }
        Map recipesByName = recipes.stream().collect(Collectors.toMap(Recipe::getName, Function.identity()));
        ArrayList<String> recipesNotFound = new ArrayList<String>();
        ArrayList<Recipe> activatedRecipes = new ArrayList<Recipe>();
        for (String activeRecipe : activeRecipes) {
            Recipe recipe = (Recipe)recipesByName.get(activeRecipe);
            if (recipe == null) {
                recipesNotFound.add(activeRecipe);
                continue;
            }
            activatedRecipes.add(recipe);
        }
        if (!recipesNotFound.isEmpty()) {
            List suggestions = recipesNotFound.stream().map(r -> recipesByName.keySet().stream().min(Comparator.comparingInt(a -> LevenshteinDistance.getDefaultInstance().apply((CharSequence)a, (CharSequence)r))).orElse((String)r)).collect(Collectors.toList());
            String message = String.format("Recipe(s) not found: %s\nDid you mean: %s", String.join((CharSequence)", ", recipesNotFound), String.join((CharSequence)", ", suggestions));
            throw new RecipeException(message);
        }
        if (activatedRecipes.isEmpty()) {
            return Recipe.noop();
        }
        if (activatedRecipes.size() == 1) {
            return (Recipe)activatedRecipes.get(0);
        }
        return new CompositeRecipe(activatedRecipes);
    }

    public Recipe activateRecipes(String ... activeRecipes) {
        return this.activateRecipes((Collection<String>)Arrays.asList(activeRecipes));
    }

    private @Nullable Recipe loadRecipe(String recipeName, ResourceLoader.RecipeDetail ... details) {
        ResourceLoader loader;
        Recipe recipe = null;
        Iterator<? extends ResourceLoader> iterator = this.resourceLoaders.iterator();
        while (iterator.hasNext() && (recipe = (loader = iterator.next()).loadRecipe(recipeName, details)) == null) {
        }
        if (recipe == null) {
            return null;
        }
        boolean includeExamples = ResourceLoader.RecipeDetail.EXAMPLES.includedIn(details);
        HashMap<String, List<RecipeExample>> recipeExamples = new HashMap<String, List<RecipeExample>>();
        if (includeExamples) {
            for (ResourceLoader resourceLoader : this.resourceLoaders) {
                if (!(resourceLoader instanceof YamlResourceLoader)) continue;
                recipeExamples.putAll(resourceLoader.listRecipeExamples());
            }
        }
        HashMap<String, Recipe> dependencyRecipes = new HashMap<String, Recipe>();
        for (ResourceLoader resourceLoader : this.dependencyResourceLoaders) {
            for (Recipe listedRecipe : resourceLoader.listRecipes()) {
                dependencyRecipes.putIfAbsent(listedRecipe.getName(), listedRecipe);
            }
        }
        for (Recipe recipe2 : dependencyRecipes.values()) {
            if (!(recipe2 instanceof DeclarativeRecipe)) continue;
            ((DeclarativeRecipe)recipe2).initialize(dependencyRecipes::get);
        }
        if (includeExamples && recipeExamples.containsKey(recipe.getName())) {
            recipe.setExamples((List)recipeExamples.get(recipe.getName()));
        }
        if (recipe instanceof DeclarativeRecipe) {
            Function<String, @Nullable Recipe> function = key -> {
                if (dependencyRecipes.containsKey(key)) {
                    return (Recipe)dependencyRecipes.get(key);
                }
                for (ResourceLoader resourceLoader : this.resourceLoaders) {
                    Recipe r = resourceLoader.loadRecipe((String)key, details);
                    if (r == null) continue;
                    return r;
                }
                return null;
            };
            ((DeclarativeRecipe)recipe).initialize(function);
        }
        return recipe;
    }

    public List<NamedStyles> listStyles() {
        return this.resourceLoaders.stream().flatMap(r -> r.listStyles().stream()).collect(Collectors.toList());
    }

    public List<NamedStyles> activateStyles(Iterable<String> activeStyles) {
        ArrayList<NamedStyles> activated = new ArrayList<NamedStyles>();
        List<NamedStyles> styles = this.listStyles();
        for (String activeStyle : activeStyles) {
            for (NamedStyles style : styles) {
                if (!style.getName().equals(activeStyle)) continue;
                activated.add(style);
            }
        }
        return activated;
    }

    public List<NamedStyles> activateStyles(String ... activeStyles) {
        return this.activateStyles(Arrays.asList(activeStyles));
    }

    public Environment(Collection<? extends ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
        this.dependencyResourceLoaders = Collections.emptyList();
    }

    public Environment(Collection<? extends ResourceLoader> resourceLoaders, Collection<? extends ResourceLoader> dependencyResourceLoaders) {
        this.resourceLoaders = resourceLoaders;
        this.dependencyResourceLoaders = dependencyResourceLoaders;
    }

    public static Builder builder(Properties properties) {
        return new Builder(properties);
    }

    public static Builder builder() {
        return new Builder(new Properties());
    }

    public static class Builder {
        private final Properties properties;
        private final Collection<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();
        private final Collection<ResourceLoader> dependencyResourceLoaders = new ArrayList<ResourceLoader>();

        public Builder(Properties properties) {
            this.properties = properties;
        }

        public Builder scanRuntimeClasspath(String ... acceptPackages) {
            return this.load(new ClasspathScanningLoader(this.properties, acceptPackages));
        }

        public Builder scanClassLoader(ClassLoader classLoader) {
            return this.load(new ClasspathScanningLoader(this.properties, classLoader));
        }

        public Builder scanYamlResources() {
            return this.load(ClasspathScanningLoader.onlyYaml(this.properties));
        }

        public Builder scanJar(Path jar, Collection<Path> dependencies, ClassLoader classLoader) {
            ArrayList<ClasspathScanningLoader> firstPassLoaderList = new ArrayList<ClasspathScanningLoader>();
            for (Path dep : dependencies) {
                firstPassLoaderList.add(new ClasspathScanningLoader(dep, this.properties, Collections.emptyList(), classLoader));
            }
            ArrayList<ClasspathScanningLoader> secondPassLoaderList = new ArrayList<ClasspathScanningLoader>();
            for (Path dep : dependencies) {
                secondPassLoaderList.add(new ClasspathScanningLoader(dep, this.properties, firstPassLoaderList, classLoader));
            }
            return this.load(new ClasspathScanningLoader(jar, this.properties, secondPassLoaderList, classLoader), secondPassLoaderList);
        }

        public Builder scanUserHome() {
            File userHomeRewriteConfig = new File(System.getProperty("user.home") + "/.rewrite/rewrite.yml");
            if (userHomeRewriteConfig.exists()) {
                Builder builder;
                FileInputStream is = new FileInputStream(userHomeRewriteConfig);
                try {
                    builder = this.load(new YamlResourceLoader(is, userHomeRewriteConfig.toURI(), this.properties));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                is.close();
                return builder;
            }
            return this;
        }

        public Builder load(ResourceLoader resourceLoader) {
            this.resourceLoaders.add(resourceLoader);
            return this;
        }

        public Builder load(ResourceLoader resourceLoader, Collection<? extends ResourceLoader> dependencyResourceLoaders) {
            this.resourceLoaders.add(resourceLoader);
            this.dependencyResourceLoaders.addAll(dependencyResourceLoaders);
            return this;
        }

        public Environment build() {
            return new Environment(this.resourceLoaders, this.dependencyResourceLoaders);
        }
    }
}

