/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceWriter {
    @Language(value="csv")
    public String toCsv(RecipeMarketplace marketplace) {
        StringWriter sw = new StringWriter();
        this.toCsv(marketplace, sw);
        return sw.toString();
    }

    public void toCsv(RecipeMarketplace marketplace, Path csvFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(csvFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.toCsv(marketplace, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toCsv(RecipeMarketplace marketplace, Writer writer) {
        CsvWriterSettings settings = new CsvWriterSettings();
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        try (CsvWriter csv = new CsvWriter(writer, settings);){
            int i;
            int maxCategoryDepth = this.calculateMaxCategoryDepth(marketplace.getRoot(), -1) + 1;
            int maxOptions = this.calculateMaxOptions(marketplace.getRoot());
            boolean hasVersion = this.hasAnyVersion(marketplace);
            boolean hasTeam = this.hasAnyTeam(marketplace);
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("ecosystem");
            headers.add("packageName");
            if (hasVersion) {
                headers.add("version");
            }
            headers.add("name");
            headers.add("displayName");
            headers.add("description");
            for (i = 1; i <= maxCategoryDepth; ++i) {
                headers.add("category" + i);
            }
            for (i = 1; i <= maxOptions; ++i) {
                headers.add("option" + i + "Name");
                headers.add("option" + i + "DisplayName");
                headers.add("option" + i + "Description");
            }
            if (hasTeam) {
                headers.add("team");
            }
            csv.writeHeaders(headers);
            this.writeCsvRecursive(csv, marketplace.getRoot(), Collections.emptyList(), maxCategoryDepth, maxOptions, hasTeam, hasVersion);
        }
    }

    private void writeCsvRecursive(CsvWriter csv, RecipeMarketplace.Category category, List<String> categoryPath, int maxCategoryDepth, int maxOptions, boolean hasTeam, boolean hasVersion) {
        for (RecipeListing recipe : category.getRecipes()) {
            ArrayList<String> row = new ArrayList<String>();
            RecipeBundle bundle = recipe.getBundle();
            row.add(bundle.getPackageEcosystem());
            row.add(bundle.getPackageName());
            if (hasVersion) {
                row.add(StringUtils.isBlank((String)bundle.getVersion()) ? "" : bundle.getVersion());
            }
            row.add(recipe.getName());
            row.add(recipe.getDisplayName());
            row.add(recipe.getDescription());
            int padding = maxCategoryDepth - categoryPath.size();
            for (int i = 0; i < maxCategoryDepth; ++i) {
                if (i < padding) {
                    row.add("");
                    continue;
                }
                row.add(categoryPath.get(i - padding));
            }
            List<? extends RecipeListing.Option> options = recipe.getOptions();
            for (int i = 0; i < maxOptions; ++i) {
                if (i < options.size()) {
                    RecipeListing.Option option = options.get(i);
                    row.add(option.getName());
                    row.add(option.getDisplayName());
                    row.add(option.getDescription());
                    continue;
                }
                row.add("");
                row.add("");
                row.add("");
            }
            if (hasTeam) {
                row.add(StringUtils.isBlank((String)bundle.getTeam()) ? "" : bundle.getTeam());
            }
            csv.writeRow(row.toArray(new String[0]));
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            ArrayList<String> childPath = new ArrayList<String>(categoryPath);
            childPath.add(0, child.getDisplayName());
            this.writeCsvRecursive(csv, child, childPath, maxCategoryDepth, maxOptions, hasTeam, hasVersion);
        }
    }

    private int calculateMaxCategoryDepth(RecipeMarketplace.Category category, int currentDepth) {
        int max = currentDepth;
        for (RecipeMarketplace.Category child : category.getCategories()) {
            int childDepth = this.calculateMaxCategoryDepth(child, currentDepth + 1);
            max = Math.max(max, childDepth);
        }
        return max;
    }

    private int calculateMaxOptions(RecipeMarketplace.Category category) {
        int max = 0;
        for (RecipeListing recipe : category.getRecipes()) {
            max = Math.max(max, recipe.getOptions().size());
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            max = Math.max(max, this.calculateMaxOptions(child));
        }
        return max;
    }

    private boolean hasAnyTeam(RecipeMarketplace marketplace) {
        for (RecipeListing recipe : marketplace.getAllRecipes()) {
            RecipeBundle bundle = recipe.getBundle();
            if (!StringUtils.isNotBlank((String)bundle.getTeam())) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyVersion(RecipeMarketplace marketplace) {
        for (RecipeListing recipe : marketplace.getAllRecipes()) {
            RecipeBundle bundle = recipe.getBundle();
            if (!StringUtils.isNotBlank((String)bundle.getVersion())) continue;
            return true;
        }
        return false;
    }
}

