/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class ClasspathReport
extends DataTable<Row> {
    public ClasspathReport(Recipe recipe) {
        super(recipe, "Classpath report", "Contains a report of the runtime classpath and any other jars found inside each classpath entry.");
    }

    public static final class Row {
        @Column(displayName="Classpath entry URI", description="The URI where a particular classpath entry can be found. May point to a jar or a directory containing class files. Local to the system running the recipe.")
        private final String uri;
        @Column(displayName="Classpath entry resource", description="Path within a classpath entry to a jar file it contains. Resources not ending in \"jar\" are ignored.")
        private final String resource;

        public Row(String uri, String resource) {
            this.uri = uri;
            this.resource = resource;
        }

        public String getUri() {
            return this.uri;
        }

        public String getResource() {
            return this.resource;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            return !(this$resource == null ? other$resource != null : !this$resource.equals(other$resource));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ClasspathReport.Row(uri=" + this.getUri() + ", resource=" + this.getResource() + ")";
        }
    }
}

