/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.GradleMultiDependency;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradeDependencyVersion
extends ScanningRecipe<DependencyVersionState> {
    private static final String GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    private final @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    private static final String UPDATE_VERSION_ERROR_KEY = "UPDATE_VERSION_ERROR_KEY";
    private static final MethodMatcher PROPERTY_METHOD = new MethodMatcher("* property(String)");
    private static final MethodMatcher FIND_PROPERTY_METHOD = new MethodMatcher("* findProperty(String)");

    public String getDisplayName() {
        return "Upgrade Gradle dependency versions";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Upgrade the version of a dependency in a build.gradle file. Supports updating dependency declarations of various forms:\n * `String` notation: `\"group:artifact:version\"` \n * `Map` notation: `group: 'group', name: 'artifact', version: 'version'`\nCan update version numbers which are defined earlier in the same file in variable declarations.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public DependencyVersionState getInitialValue(ExecutionContext ctx) {
        return new DependencyVersionState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final DependencyVersionState acc) {
        return new JavaVisitor<ExecutionContext>(){
            @Nullable GradleProject gradleProject;

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile instanceof G.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle") || sourceFile instanceof K.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle.kts");
            }

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    this.gradleProject = tree.getMarkers().findFirst(GradleProject.class).orElse(null);
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                GradleMultiDependency.matcher().matcher(new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, UpgradeDependencyVersion.this.getVersionComparator())).get(this.getCursor()).ifPresent(multiDependency -> multiDependency.forEach(dep -> this.scanDependency((GradleDependency)dep, ctx)));
                return m;
            }

            private void scanDependency(GradleDependency gradleDependency, ExecutionContext ctx) {
                this.gatherVariables(gradleDependency);
                String groupId = gradleDependency.getGroupId();
                String artifactId = gradleDependency.getArtifactId();
                GroupArtifact ga = new GroupArtifact(groupId, artifactId);
                String configName = gradleDependency.getConfigurationName();
                if (this.gradleProject != null) {
                    acc.getConfigurationPerGAPerModule().computeIfAbsent(UpgradeDependencyVersion.getGradleProjectKey(this.gradleProject), k -> new HashMap()).computeIfAbsent(ga, k -> new HashSet()).add(configName);
                }
                if (!acc.gaToNewVersion.containsKey(ga) && this.shouldResolveVersion(groupId, artifactId)) {
                    try {
                        String newVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(ga, configName, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                        String versionVar = gradleDependency.getVersionVariable();
                        if (versionVar != null) {
                            acc.versionPropNameToGA.computeIfAbsent(versionVar, k -> new HashMap()).computeIfAbsent(ga, k -> new HashSet()).add(configName);
                        }
                        acc.gaToNewVersion.put(ga, newVersion);
                    }
                    catch (MavenDownloadingException e) {
                        acc.gaToNewVersion.put(ga, e);
                    }
                }
            }

            private boolean shouldResolveVersion(String declaredGroupId, String declaredArtifactId) {
                return UpgradeDependencyVersion.this.groupId == null || UpgradeDependencyVersion.this.artifactId == null || new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null).matches(declaredGroupId, declaredArtifactId);
            }

            private void gatherVariables(GradleDependency gradleDependency) {
                String artifactId;
                String versionVariableName = gradleDependency.getVersionVariable();
                if (versionVariableName == null) {
                    return;
                }
                String groupId = gradleDependency.getGroupId();
                if (this.shouldResolveVersion(groupId, artifactId = gradleDependency.getArtifactId())) {
                    J.MethodInvocation method = (J.MethodInvocation)gradleDependency.getTree();
                    acc.variableNames.computeIfAbsent(versionVariableName, it -> new HashMap()).computeIfAbsent(new GroupArtifact(groupId, artifactId), it -> new HashSet()).add(method.getSimpleName());
                }
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final DependencyVersionState acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){
            private final UpdateGradle updateGradle;
            private final UpdateProperties updateProperties;
            {
                this.updateGradle = new UpdateGradle(acc);
                this.updateProperties = new UpdateProperties(acc);
            }

            public boolean isAcceptable(SourceFile sf, ExecutionContext ctx) {
                return this.updateProperties.isAcceptable(sf, ctx) || this.updateGradle.isAcceptable(sf, ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t = tree;
                if (t instanceof SourceFile) {
                    SourceFile sf = (SourceFile)t;
                    if (this.updateProperties.isAcceptable(sf, ctx)) {
                        t = this.updateProperties.visitNonNull(t, ctx);
                    } else if (this.updateGradle.isAcceptable(sf, ctx)) {
                        t = this.updateGradle.visitNonNull(t, ctx);
                    }
                    Optional projectMarker = t.getMarkers().findFirst(GradleProject.class);
                    if (tree != t && projectMarker.isPresent()) {
                        try {
                            GradleProject gradleProject = (GradleProject)projectMarker.get();
                            Map configurationsPerGa = acc.getConfigurationPerGAPerModule().getOrDefault(UpgradeDependencyVersion.getGradleProjectKey(gradleProject), Collections.emptyMap());
                            ArrayList<GroupArtifactVersion> upgrades = new ArrayList<GroupArtifactVersion>();
                            if (acc.gaToNewVersion.isEmpty()) {
                                DependencyMatcher matcher = new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null);
                                DependencyVersionSelector versionSelector = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, gradleProject, null);
                                for (GroupArtifact groupArtifact : configurationsPerGa.keySet()) {
                                    if (!matcher.matches(groupArtifact.getGroupId(), groupArtifact.getArtifactId())) continue;
                                    String selectedVersion = versionSelector.select(groupArtifact, null, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                                    GroupArtifactVersion gav = new GroupArtifactVersion(groupArtifact.getGroupId(), groupArtifact.getArtifactId(), selectedVersion);
                                    upgrades.add(gav);
                                }
                            } else {
                                for (Map.Entry newVersion : acc.gaToNewVersion.entrySet()) {
                                    if (!(newVersion.getValue() instanceof String)) continue;
                                    GroupArtifactVersion gav = new GroupArtifactVersion(((GroupArtifact)newVersion.getKey()).getGroupId(), ((GroupArtifact)newVersion.getKey()).getArtifactId(), (String)newVersion.getValue());
                                    upgrades.add(gav);
                                }
                            }
                            gradleProject = gradleProject.upgradeDirectDependencyVersions(upgrades, ctx).upgradeBuildscriptDirectDependencyVersions(upgrades, ctx);
                            if (projectMarker.get() != gradleProject) {
                                t = t.withMarkers(t.getMarkers().setByType((Marker)gradleProject));
                            }
                        }
                        catch (MavenDownloadingException e) {
                            t = Markup.warn((Tree)t, (Throwable)e);
                        }
                    }
                }
                return t;
            }
        };
    }

    private @Nullable VersionComparator getVersionComparator() {
        return (VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)this.newVersion) ? "latest.release" : this.newVersion), (String)this.versionPattern).getValue();
    }

    static String getGradleProjectKey(GradleProject project) {
        if (StringUtils.isBlank((String)project.getGroup())) {
            return project.getName();
        }
        if (":".equals(project.getPath())) {
            return project.getGroup();
        }
        return project.getGroup() + project.getPath().replace(":", ".");
    }

    @Generated
    public UpgradeDependencyVersion(String groupId, String artifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    public static final class DependencyVersionState {
        private final Map<String, Map<GroupArtifact, Set<String>>> variableNames = new HashMap<String, Map<GroupArtifact, Set<String>>>();
        private final Map<String, Map<GroupArtifact, Set<String>>> versionPropNameToGA = new HashMap<String, Map<GroupArtifact, Set<String>>>();
        private final Map<GroupArtifact, @Nullable Object> gaToNewVersion = new HashMap<GroupArtifact, Object>();
        private final Map<String, Map<GroupArtifact, Set<String>>> configurationPerGAPerModule = new HashMap<String, Map<GroupArtifact, Set<String>>>();

        @Generated
        public DependencyVersionState() {
        }

        @Generated
        public Map<String, Map<GroupArtifact, Set<String>>> getVariableNames() {
            return this.variableNames;
        }

        @Generated
        public Map<String, Map<GroupArtifact, Set<String>>> getVersionPropNameToGA() {
            return this.versionPropNameToGA;
        }

        @Generated
        public Map<GroupArtifact, @Nullable Object> getGaToNewVersion() {
            return this.gaToNewVersion;
        }

        @Generated
        public Map<String, Map<GroupArtifact, Set<String>>> getConfigurationPerGAPerModule() {
            return this.configurationPerGAPerModule;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyVersionState)) {
                return false;
            }
            DependencyVersionState other = (DependencyVersionState)o;
            Map<String, Map<GroupArtifact, Set<String>>> this$variableNames = this.getVariableNames();
            Map<String, Map<GroupArtifact, Set<String>>> other$variableNames = other.getVariableNames();
            if (this$variableNames == null ? other$variableNames != null : !((Object)this$variableNames).equals(other$variableNames)) {
                return false;
            }
            Map<String, Map<GroupArtifact, Set<String>>> this$versionPropNameToGA = this.getVersionPropNameToGA();
            Map<String, Map<GroupArtifact, Set<String>>> other$versionPropNameToGA = other.getVersionPropNameToGA();
            if (this$versionPropNameToGA == null ? other$versionPropNameToGA != null : !((Object)this$versionPropNameToGA).equals(other$versionPropNameToGA)) {
                return false;
            }
            Map<GroupArtifact, Object> this$gaToNewVersion = this.getGaToNewVersion();
            Map<GroupArtifact, Object> other$gaToNewVersion = other.getGaToNewVersion();
            if (this$gaToNewVersion == null ? other$gaToNewVersion != null : !((Object)this$gaToNewVersion).equals(other$gaToNewVersion)) {
                return false;
            }
            Map<String, Map<GroupArtifact, Set<String>>> this$configurationPerGAPerModule = this.getConfigurationPerGAPerModule();
            Map<String, Map<GroupArtifact, Set<String>>> other$configurationPerGAPerModule = other.getConfigurationPerGAPerModule();
            return !(this$configurationPerGAPerModule == null ? other$configurationPerGAPerModule != null : !((Object)this$configurationPerGAPerModule).equals(other$configurationPerGAPerModule));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Map<GroupArtifact, Set<String>>> $variableNames = this.getVariableNames();
            result = result * 59 + ($variableNames == null ? 43 : ((Object)$variableNames).hashCode());
            Map<String, Map<GroupArtifact, Set<String>>> $versionPropNameToGA = this.getVersionPropNameToGA();
            result = result * 59 + ($versionPropNameToGA == null ? 43 : ((Object)$versionPropNameToGA).hashCode());
            Map<GroupArtifact, Object> $gaToNewVersion = this.getGaToNewVersion();
            result = result * 59 + ($gaToNewVersion == null ? 43 : ((Object)$gaToNewVersion).hashCode());
            Map<String, Map<GroupArtifact, Set<String>>> $configurationPerGAPerModule = this.getConfigurationPerGAPerModule();
            result = result * 59 + ($configurationPerGAPerModule == null ? 43 : ((Object)$configurationPerGAPerModule).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeDependencyVersion.DependencyVersionState(variableNames=" + this.getVariableNames() + ", versionPropNameToGA=" + this.getVersionPropNameToGA() + ", gaToNewVersion=" + this.getGaToNewVersion() + ", configurationPerGAPerModule=" + this.getConfigurationPerGAPerModule() + ")";
        }
    }

    private class UpdateVariable
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames;
        private final @Nullable GradleProject gradleProject;

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)ctx);
            if (!(v.getInitializer() instanceof J.Literal) || ((J.Literal)v.getInitializer()).getValue() == null || ((J.Literal)v.getInitializer()).getType() != JavaType.Primitive.String) {
                return v;
            }
            Map.Entry<GroupArtifact, Set<String>> gaWithConfigs = this.getGroupArtifactWithConfigs(v.getSimpleName());
            if (gaWithConfigs == null) {
                return v;
            }
            try {
                J.Literal newVersion = this.getNewVersion((J.Literal)v.getInitializer(), gaWithConfigs, ctx);
                return newVersion == null ? v : v.withInitializer((Expression)newVersion);
            }
            catch (MavenDownloadingException e) {
                return (J.VariableDeclarations.NamedVariable)e.warn((Tree)v);
            }
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J.Assignment a = super.visitAssignment(assignment, (Object)ctx);
            if (!(a.getVariable() instanceof J.Identifier) || !(a.getAssignment() instanceof J.Literal) || ((J.Literal)a.getAssignment()).getValue() == null || ((J.Literal)a.getAssignment()).getType() != JavaType.Primitive.String) {
                return a;
            }
            Map.Entry<GroupArtifact, Set<String>> gaWithConfigs = this.getGroupArtifactWithConfigs(((J.Identifier)a.getVariable()).getSimpleName());
            if (gaWithConfigs == null) {
                return a;
            }
            try {
                J.Literal newVersion = this.getNewVersion((J.Literal)a.getAssignment(), gaWithConfigs, ctx);
                return newVersion == null ? a : a.withAssignment((Expression)newVersion);
            }
            catch (MavenDownloadingException e) {
                return (J.Assignment)e.warn((Tree)a);
            }
        }

        private @Nullable Map.Entry<GroupArtifact, Set<String>> getGroupArtifactWithConfigs(String identifier) {
            for (Map.Entry<String, Map<GroupArtifact, Set<String>>> versionVariableNameEntry : this.versionVariableNames.entrySet()) {
                if (!versionVariableNameEntry.getKey().equals(identifier)) continue;
                return versionVariableNameEntry.getValue().entrySet().iterator().next();
            }
            return null;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal getNewVersion(J.Literal literal, Map.Entry<GroupArtifact, Set<String>> gaWithConfigurations, ExecutionContext ctx) throws MavenDownloadingException {
            String selectedVersion;
            GroupArtifact ga = gaWithConfigurations.getKey();
            DependencyVersionSelector dependencyVersionSelector = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null);
            GroupArtifactVersion gav = new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), (String)literal.getValue());
            try {
                selectedVersion = dependencyVersionSelector.select(gav, null, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
            }
            catch (MavenDownloadingException e) {
                if (!gaWithConfigurations.getValue().contains("classpath")) {
                    throw e;
                }
                selectedVersion = dependencyVersionSelector.select(gav, "classpath", UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
            }
            if (selectedVersion == null) {
                return null;
            }
            return ChangeStringLiteral.withStringValue(literal, selectedVersion);
        }

        @Generated
        public UpdateVariable(@Nullable Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames, GradleProject gradleProject) {
            this.versionVariableNames = versionVariableNames;
            this.gradleProject = gradleProject;
        }
    }

    private class UpdateGradle
    extends JavaVisitor<ExecutionContext> {
        final DependencyVersionState acc;
        @Nullable GradleProject gradleProject;
        final DependencyMatcher dependencyMatcher;

        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
            return sourceFile instanceof G.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle") || sourceFile instanceof K.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle.kts");
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile sourceFile = (JavaSourceFile)tree;
                this.gradleProject = sourceFile.getMarkers().findFirst(GradleProject.class).orElse(null);
                return (J)super.visit((Tree)sourceFile, (Object)ctx);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        public J postVisit(J tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)tree;
                if (!this.acc.variableNames.isEmpty()) {
                    cu = (JavaSourceFile)new UpdateVariable(this.acc.variableNames, this.gradleProject).visitNonNull((Tree)cu, ctx);
                }
                return cu;
            }
            return tree;
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            GradleMultiDependency multiDependency = GradleMultiDependency.matcher().matcher(this.dependencyMatcher).get(this.getCursor()).orElse(null);
            if (multiDependency != null) {
                m = multiDependency.map(dep -> {
                    Object scanResult = this.acc.gaToNewVersion.get(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()));
                    if (scanResult instanceof Exception) {
                        return (J.MethodInvocation)Markup.warn((Tree)((J.MethodInvocation)dep.getTree()), (Throwable)((Exception)scanResult));
                    }
                    return this.updateDependency((GradleDependency)dep, ctx);
                });
            }
            if ("ext".equals(method.getSimpleName()) && ((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().endsWith("settings.gradle")) {
                m = (J.MethodInvocation)new JavaIsoVisitor<ExecutionContext>(){

                    public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext executionContext) {
                        String currentVersion;
                        Optional finalVersion;
                        J.Assignment a = super.visitAssignment(assignment, (Object)executionContext);
                        if (!(a.getVariable() instanceof J.Identifier)) {
                            return a;
                        }
                        Map groupArtifactSetMap = (Map)UpdateGradle.this.acc.versionPropNameToGA.get("gradle." + a.getVariable());
                        if (groupArtifactSetMap == null) {
                            return a;
                        }
                        GroupArtifact ga = groupArtifactSetMap.entrySet().stream().findFirst().map(Map.Entry::getKey).orElse(null);
                        if (ga == null) {
                            return a;
                        }
                        String newVersion = (String)UpdateGradle.this.acc.gaToNewVersion.get(ga);
                        if (newVersion == null) {
                            return a;
                        }
                        if (!(a.getAssignment() instanceof J.Literal)) {
                            return a;
                        }
                        J.Literal l = (J.Literal)a.getAssignment();
                        if (J.Literal.isLiteralValue((Expression)l, (Object)newVersion)) {
                            return a;
                        }
                        VersionComparator versionComparator = UpgradeDependencyVersion.this.getVersionComparator();
                        if (versionComparator != null && !(finalVersion = versionComparator.upgrade(currentVersion = (String)l.getValue(), Collections.singletonList(newVersion))).isPresent()) {
                            return a;
                        }
                        String quote = l.getValueSource() == null ? "\"" : l.getValueSource().substring(0, 1);
                        return a.withAssignment((Expression)l.withValue((Object)newVersion).withValueSource(quote + newVersion + quote));
                    }
                }.visitNonNull((Tree)m, (Object)ctx, this.getCursor().getParentTreeCursor());
            } else if ("ext".equals(m.getSimpleName())) {
                return m.withArguments(ListUtils.map((List)m.getArguments(), arg -> (Expression)new JavaIsoVisitor<ExecutionContext>(){

                    public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext executionContext) {
                        if (assignment.getVariable() instanceof J.Identifier && UpdateGradle.this.acc.versionPropNameToGA.containsKey(((J.Identifier)assignment.getVariable()).getSimpleName())) {
                            UpdateGradle.this.acc.variableNames.computeIfAbsent(((J.Identifier)assignment.getVariable()).getSimpleName(), it -> (Map)UpdateGradle.this.acc.versionPropNameToGA.get(((J.Identifier)assignment.getVariable()).getSimpleName()));
                        }
                        return super.visitAssignment(assignment, (Object)executionContext);
                    }
                }.visitNonNull((Tree)arg, (Object)ctx)));
            }
            return m;
        }

        private J.MethodInvocation updateDependency(GradleDependency dependency, ExecutionContext ctx) {
            String selectedVersion;
            String currentVersion = dependency.getDeclaredVersion();
            String groupId = dependency.getDeclaredGroupId();
            String artifactId = dependency.getDeclaredArtifactId();
            if (groupId == null || artifactId == null) {
                return (J.MethodInvocation)dependency.getTree();
            }
            Object scanResult = this.acc.gaToNewVersion.get(new GroupArtifact(groupId, artifactId));
            if (scanResult instanceof Exception) {
                return (J.MethodInvocation)dependency.getTree();
            }
            String versionVariable = dependency.getVersionVariable();
            if (versionVariable != null) {
                return (J.MethodInvocation)dependency.getTree();
            }
            if (currentVersion != null && currentVersion.startsWith("$")) {
                return (J.MethodInvocation)dependency.getTree();
            }
            try {
                String configName = dependency.getConfigurationName();
                if (currentVersion == null) {
                    if (!dependency.isPlatform()) {
                        return (J.MethodInvocation)dependency.getTree();
                    }
                    GroupArtifact ga = new GroupArtifact(groupId, artifactId);
                    selectedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(ga, configName, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                } else {
                    GroupArtifactVersion gav = new GroupArtifactVersion(groupId, artifactId, currentVersion);
                    selectedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(gav, configName, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                }
            }
            catch (MavenDownloadingException e) {
                return (J.MethodInvocation)dependency.getTree();
            }
            if (selectedVersion == null || currentVersion != null && currentVersion.equals(selectedVersion)) {
                return (J.MethodInvocation)dependency.getTree();
            }
            return (J.MethodInvocation)dependency.withDeclaredVersion(selectedVersion).getTree();
        }

        @Generated
        public UpdateGradle(DependencyVersionState acc) {
            this.dependencyMatcher = new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null);
            this.acc = acc;
        }
    }

    private class UpdateProperties
    extends PropertiesVisitor<ExecutionContext> {
        final DependencyVersionState acc;
        final DependencyMatcher dependencyMatcher;

        public Properties visitFile(Properties.File file, ExecutionContext ctx) {
            if (!file.getSourcePath().endsWith(UpgradeDependencyVersion.GRADLE_PROPERTIES_FILE_NAME)) {
                return file;
            }
            return super.visitFile(file, (Object)ctx);
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
            if (this.acc.versionPropNameToGA.containsKey(entry.getKey())) {
                GroupArtifact ga = ((Map)this.acc.versionPropNameToGA.get(entry.getKey())).keySet().stream().findFirst().orElse(null);
                if (ga == null || !this.dependencyMatcher.matches(ga.getGroupId(), ga.getArtifactId())) {
                    return entry;
                }
                Object result = this.acc.gaToNewVersion.get(ga);
                if (result == null || result instanceof Exception) {
                    return entry;
                }
                VersionComparator versionComparator = UpgradeDependencyVersion.this.getVersionComparator();
                if (versionComparator == null) {
                    return entry;
                }
                Optional finalVersion = versionComparator.upgrade(entry.getValue().getText(), Collections.singletonList((String)result));
                return (Properties)finalVersion.map(v -> entry.withValue(entry.getValue().withText(v))).orElse(entry);
            }
            return entry;
        }

        @Generated
        public UpdateProperties(DependencyVersionState acc) {
            this.dependencyMatcher = new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null);
            this.acc = acc;
        }
    }
}

