/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.style.TabsAndIndentsStyle;
import org.openrewrite.hcl.tree.Comment;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.HclLeftPadded;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;

public class TabsAndIndentsVisitor<P>
extends HclIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final TabsAndIndentsStyle style;
    private final String spacesForTab;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style) {
        this(style, null);
    }

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < style.getTabSize(); ++i) {
            s.append(' ');
        }
        this.spacesForTab = s.toString();
    }

    public @Nullable Hcl visit(@Nullable Tree tree, P p, Cursor parent) {
        this.setCursor(parent);
        for (Cursor c = parent; c != null; c = c.getParent()) {
            int indent;
            Object v = c.getValue();
            Space space = null;
            if (v instanceof Hcl) {
                space = ((Hcl)v).getPrefix();
            } else if (v instanceof HclRightPadded) {
                space = ((HclRightPadded)v).getAfter();
            } else if (v instanceof HclLeftPadded) {
                space = ((HclLeftPadded)v).getBefore();
            } else if (v instanceof HclContainer) {
                space = ((HclContainer)v).getBefore();
            }
            if (space == null || !space.getLastWhitespace().contains("\n") || (indent = this.findIndent(space)) == 0) continue;
            c.putMessage("lastIndent", (Object)indent);
        }
        Iterator path = parent.getPath(Hcl.class::isInstance);
        if (path.hasNext()) {
            this.preVisit((Hcl)path.next(), p);
        }
        return this.visit(tree, (Object)p);
    }

    public @Nullable Hcl preVisit(Hcl tree, P p) {
        if (tree instanceof Hcl.Block || tree instanceof Hcl.ObjectValue) {
            this.getCursor().putMessage("indentType", (Object)IndentType.INDENT);
        } else {
            this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
        }
        return (Hcl)super.preVisit((Tree)tree, p);
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        boolean alignBlockToParent;
        Cursor parent = this.getCursor().getParent();
        if (!space.getLastWhitespace().contains("\n") || parent == null) {
            return space;
        }
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        IndentType indentType = (IndentType)((Object)this.getCursor().getParentOrThrow().getNearestMessage("indentType", (Object)IndentType.ALIGN));
        boolean bl = alignBlockToParent = loc == Space.Location.BLOCK_CLOSE || loc == Space.Location.OBJECT_VALUE_ATTRIBUTE_SUFFIX;
        if (alignBlockToParent) {
            indentType = IndentType.ALIGN;
        }
        switch (indentType.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                indent += this.style.getIndentSize().intValue();
            }
        }
        Space s = this.indentTo(space, indent, loc);
        if (!(this.getCursor().getValue() instanceof HclLeftPadded)) {
            this.getCursor().putMessage("lastIndent", (Object)indent);
        }
        return s;
    }

    @Override
    public <T> @Nullable HclRightPadded<T> visitRightPadded(@Nullable HclRightPadded<T> right, HclRightPadded.Location loc, P p) {
        Space after;
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        if (right.getElement() instanceof Hcl) {
            Hcl elem = (Hcl)right.getElement();
            if (right.getAfter().getLastWhitespace().contains("\n") || elem.getPrefix().getLastWhitespace().contains("\n")) {
                switch (loc) {
                    case FUNCTION_CALL_ARGUMENT: 
                    case PARENTHESES: {
                        elem = (Hcl)this.visitAndCast(elem, p);
                        after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                        break;
                    }
                    default: {
                        elem = (Hcl)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                }
            } else {
                switch (loc) {
                    case FUNCTION_CALL_ARGUMENT: {
                        if (!elem.getPrefix().getLastWhitespace().contains("\n")) {
                            HclContainer args = (HclContainer)this.getCursor().getParentOrThrow().getValue();
                            boolean seenArg = false;
                            boolean anyOtherArgOnOwnLine = false;
                            for (HclRightPadded arg : args.getPadding().getElements()) {
                                if (arg == this.getCursor().getValue()) {
                                    seenArg = true;
                                    continue;
                                }
                                if (!seenArg || !((Expression)arg.getElement()).getPrefix().getLastWhitespace().contains("\n")) continue;
                                anyOtherArgOnOwnLine = true;
                                break;
                            }
                            if (!anyOtherArgOnOwnLine) {
                                elem = (Hcl)this.visitAndCast(elem, p);
                                after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                break;
                            }
                        }
                        elem = (Hcl)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                    default: {
                        elem = (Hcl)this.visitAndCast(elem, p);
                        after = right.getAfter();
                    }
                }
            }
            t = elem;
        } else {
            after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        }
        this.setCursor(this.getCursor().getParent());
        return after == right.getAfter() && t == right.getElement() ? right : new HclRightPadded<T>(t, after, right.getMarkers());
    }

    @Override
    public <H extends Hcl> HclContainer<H> visitContainer(HclContainer<H> container, HclContainer.Location loc, P p) {
        List js;
        Space before;
        this.setCursor(new Cursor(this.getCursor(), container));
        int indent = (Integer)this.getCursor().getNearestMessage("lastIndent", (Object)0);
        if (container.getBefore().getLastWhitespace().contains("\n")) {
            if (loc == HclContainer.Location.FUNCTION_CALL_ARGUMENTS) {
                before = this.indentTo(container.getBefore(), indent + this.style.getIndentSize(), loc.getBeforeLocation());
                this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
                this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getIndentSize()));
                js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((HclRightPadded)t, loc.getElementLocation(), p));
            } else {
                before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((HclRightPadded)t, loc.getElementLocation(), p));
            }
        } else {
            if (loc == HclContainer.Location.FUNCTION_CALL_ARGUMENTS) {
                this.getCursor().putMessage("indentType", (Object)IndentType.INDENT);
            }
            before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
            js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((HclRightPadded)t, loc.getElementLocation(), p));
        }
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : HclContainer.build(before, js, container.getMarkers());
    }

    @Override
    public Hcl.Attribute visitAttribute(Hcl.Attribute attribute, P p) {
        Hcl.Attribute a = attribute;
        if (attribute.getComma() != null) {
            a = attribute.withComma(attribute.getComma().withPrefix(Space.EMPTY));
        }
        return super.visitAttribute(a, (Object)p);
    }

    private Space indentTo(Space space, int column, Space.Location spaceLocation) {
        if (!space.getLastWhitespace().contains("\n")) {
            return space;
        }
        if (space.getComments().isEmpty()) {
            int indent = this.findIndent(space);
            if (indent != column) {
                int shift = column - indent;
                space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
            }
        } else {
            if (!StringUtils.isNullOrEmpty((String)space.getWhitespace()) && (Comment.Style.INLINE == space.getComments().get(0).getStyle() || Comment.Style.INLINE != space.getComments().get(0).getStyle() && (space.getWhitespace().contains("\n") || space.getWhitespace().contains("\r")))) {
                space = this.style.getUseTabCharacter() != false ? space.withWhitespace(space.getWhitespace().replaceAll(" ", "")) : space.withWhitespace(space.getWhitespace().replaceAll("\t", ""));
            }
            Comment lastElement = space.getComments().get(space.getComments().size() - 1);
            if ((space = space.withComments(ListUtils.map(space.getComments(), c -> {
                int incrementBy = spaceLocation == Space.Location.BLOCK_CLOSE && !c.equals(lastElement) ? this.style.getIndentSize() : 0;
                return c.getStyle() == Comment.Style.INLINE ? this.indentMultilineComment((Comment)c, column + incrementBy) : this.indentSingleLineComment((Comment)c, column + incrementBy);
            }))).getWhitespace().contains("\n") || spaceLocation == Space.Location.CONFIG_FILE) {
                int incrementBy = spaceLocation == Space.Location.BLOCK_CLOSE ? this.style.getIndentSize() : 0;
                int indent = this.getLengthOfWhitespace(space.getWhitespace());
                if (indent != column + incrementBy) {
                    int shift = column + incrementBy - indent;
                    space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
                }
            }
        }
        return space;
    }

    private Comment indentSingleLineComment(Comment comment, int column) {
        int indent = this.getLengthOfWhitespace(Space.format(comment.getSuffix()).getWhitespace());
        if (column == indent) {
            return comment;
        }
        StringBuilder newSuffix = new StringBuilder(comment.getSuffix());
        int shift = column - indent;
        this.shift(newSuffix, shift);
        return comment.withSuffix(newSuffix.toString());
    }

    private Comment indentMultilineComment(Comment comment, int column) {
        StringBuilder newSuffix;
        int shift;
        StringBuilder newTextBuilder = new StringBuilder();
        StringBuilder currentText = new StringBuilder();
        StringBuilder whitespace = new StringBuilder();
        boolean hasChanged = false;
        boolean isWhitespace = true;
        boolean isFirstLine = true;
        int indent = 0;
        int tabLength = 0;
        boolean alignToColumn = this.shouldAlignBlockComment(comment);
        int prev = 36;
        block7: for (int i = 0; i < comment.getText().length(); ++i) {
            char c = comment.getText().charAt(i);
            switch (c) {
                case '\t': {
                    if (!isFirstLine && isWhitespace) {
                        if (this.style.getUseTabCharacter().booleanValue()) {
                            whitespace.append(c);
                            indent += this.style.getTabSize().intValue();
                        } else {
                            for (int j = tabLength % this.style.getIndentSize(); j < this.style.getIndentSize(); ++j) {
                                whitespace.append(' ');
                                ++indent;
                                hasChanged = true;
                            }
                        }
                        tabLength = 0;
                        break;
                    }
                    currentText.append(c);
                    break;
                }
                case ' ': {
                    if (!isFirstLine && isWhitespace) {
                        if (this.style.getUseTabCharacter().booleanValue()) {
                            if (++tabLength == this.style.getTabSize() && (!alignToColumn || i + 1 < comment.getText().length() - 1 && comment.getText().charAt(i + 1) != '*')) {
                                whitespace.append('\t');
                                indent += this.style.getTabSize().intValue();
                                tabLength = 0;
                                hasChanged = true;
                            }
                        } else {
                            whitespace.append(c);
                            ++indent;
                            ++tabLength;
                        }
                        if (tabLength != (this.style.getUseTabCharacter() != false ? this.style.getTabSize() : this.style.getIndentSize())) break;
                        tabLength = 0;
                        break;
                    }
                    currentText.append(c);
                    break;
                }
                case '\r': {
                    if (i + 1 <= comment.getText().length() - 1 && comment.getText().charAt(i + 1) == '\n') {
                        whitespace.append(c);
                        continue block7;
                    }
                }
                case '\n': {
                    if (isFirstLine) {
                        isFirstLine = false;
                    } else if (alignToColumn && indent != column) {
                        shift = column - indent;
                        this.shift(whitespace, shift);
                        hasChanged = true;
                    }
                    newTextBuilder.append((CharSequence)whitespace.append((CharSequence)currentText));
                    whitespace.setLength(0);
                    currentText.setLength(0);
                    indent = 0;
                    tabLength = 0;
                    whitespace.append(c);
                    isWhitespace = true;
                    break;
                }
                case '*': {
                    if (alignToColumn && !isFirstLine && isWhitespace) {
                        if (this.style.getUseTabCharacter().booleanValue()) {
                            if (prev != 32) {
                                hasChanged = true;
                            }
                        } else if (whitespace.length() <= 1) {
                            hasChanged = true;
                        } else {
                            whitespace.setLength(whitespace.length() - 1);
                            --indent;
                        }
                        currentText.append(' ');
                    }
                }
                default: {
                    if (!isFirstLine && isWhitespace) {
                        isWhitespace = false;
                    }
                    currentText.append(c);
                }
            }
            prev = c;
        }
        if (!isFirstLine) {
            int incrementBy;
            int n = incrementBy = this.style.getUseTabCharacter() == false && currentText.length() == 0 ? 1 : 0;
            if (alignToColumn && indent != column + incrementBy) {
                int shift2 = column - indent;
                this.shift(whitespace, shift2);
                hasChanged = true;
            }
            if (currentText.length() == 0) {
                if (this.style.getUseTabCharacter().booleanValue()) {
                    if (whitespace.charAt(whitespace.length() - 1) != ' ') {
                        whitespace.append(' ');
                        if (!hasChanged && prev != 32) {
                            hasChanged = true;
                        }
                    }
                } else if (whitespace.length() - 1 == column) {
                    whitespace.append(' ');
                    hasChanged = true;
                }
            }
        }
        String suffix = null;
        if (this.style.getUseTabCharacter().booleanValue()) {
            if (comment.getSuffix().contains(" ")) {
                suffix = comment.getSuffix().replace(" ", "\t");
                hasChanged = true;
            }
        } else if (comment.getSuffix().contains("\t")) {
            suffix = comment.getSuffix().replace("\t", " ");
            hasChanged = true;
        }
        if ((indent = this.getLengthOfWhitespace((newSuffix = new StringBuilder(suffix = suffix == null ? comment.getSuffix() : suffix)).toString())) != column && newSuffix.toString().contains("\n")) {
            shift = column - indent;
            this.shift(newSuffix, shift);
            hasChanged = true;
        }
        if (!hasChanged) {
            return comment;
        }
        String newText = newTextBuilder.append((CharSequence)whitespace.append((CharSequence)currentText)).toString();
        return comment.withText(newText).withSuffix(newSuffix.toString());
    }

    private boolean shouldAlignBlockComment(Comment comment) {
        boolean alignComment = true;
        boolean isFirstLine = true;
        boolean isWhitespace = true;
        block4: for (char c : comment.getText().toCharArray()) {
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    if (isFirstLine) {
                        isFirstLine = false;
                    }
                    isWhitespace = true;
                    continue block4;
                }
                default: {
                    if (isFirstLine || !isWhitespace) continue block4;
                    isWhitespace = false;
                    if (c == '*') continue block4;
                    alignComment = false;
                    break block4;
                }
            }
        }
        return alignComment;
    }

    private String indent(String whitespace, int shift) {
        if (!this.style.getUseTabCharacter().booleanValue() && whitespace.contains("\t")) {
            whitespace = whitespace.replaceAll("\t", this.spacesForTab);
        }
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        int tabIndent = this.style.getTabSize();
        if (!this.style.getUseTabCharacter().booleanValue()) {
            tabIndent = Integer.MAX_VALUE;
        }
        if (shift > 0) {
            int i;
            for (i = 0; i < shift / tabIndent; ++i) {
                text.append('\t');
            }
            for (i = 0; i < shift % tabIndent; ++i) {
                text.append(' ');
            }
        } else {
            int len = this.style.getUseTabCharacter() != false ? text.length() + shift / tabIndent : text.length() + shift;
            if (len >= 0) {
                text.delete(len, text.length());
            }
        }
    }

    private int findIndent(Space space) {
        String indent = space.getIndent();
        return this.getLengthOfWhitespace(indent);
    }

    private int getLengthOfWhitespace(@Nullable String whitespace) {
        if (whitespace == null) {
            return 0;
        }
        int size = 0;
        for (char c : whitespace.toCharArray()) {
            size += c == '\t' ? this.style.getTabSize() : 1;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    public @Nullable Hcl postVisit(Hcl tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Hcl.ConfigFile.class, "stop", (Object)true);
        }
        return (Hcl)super.postVisit((Tree)tree, p);
    }

    public @Nullable Hcl visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Hcl)tree;
        }
        return (Hcl)super.visit(tree, p);
    }

    private static enum IndentType {
        ALIGN,
        INDENT;

    }
}

