/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.EmptyBlockVisitor;
import org.openrewrite.java.cleanup.RemoveUnneededBlock;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Statement;

public class SimplifyConstantIfBranchExecution
extends Recipe {
    public String getDisplayName() {
        return "Simplify constant if branch execution";
    }

    public String getDescription() {
        return "Checks for if expressions that are always `true` or `false` and simplifies them.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new SimplifyConstantIfBranchExecutionVisitor();
    }

    private static class SimplifyConstantIfBranchExecutionVisitor
    extends JavaVisitor<ExecutionContext> {
        private SimplifyConstantIfBranchExecutionVisitor() {
        }

        @Override
        public J visitBlock(J.Block block, ExecutionContext executionContext) {
            J.Block bl = (J.Block)super.visitBlock(block, executionContext);
            if (bl != block) {
                bl = (J.Block)new RemoveUnneededBlock.RemoveUnneededBlockStatementVisitor().visitNonNull(bl, executionContext, this.getCursor().getParentOrThrow());
                EmptyBlockStyle style = (EmptyBlockStyle)((SourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getStyle(EmptyBlockStyle.class);
                if (style == null) {
                    style = Checkstyle.emptyBlock();
                }
                bl = (J.Block)new EmptyBlockVisitor(style).visitNonNull(bl, executionContext, this.getCursor().getParentOrThrow());
            }
            return bl;
        }

        private <E extends Expression> E cleanupBooleanExpression(E expression, ExecutionContext context) {
            Expression ex1 = (Expression)new UnnecessaryParenthesesVisitor(Checkstyle.unnecessaryParentheses()).visitNonNull(expression, context, this.getCursor().getParentOrThrow());
            if (expression == (ex1 = (Expression)new SimplifyBooleanExpressionVisitor().visitNonNull(ex1, context, this.getCursor().getParentTreeCursor())) || SimplifyConstantIfBranchExecutionVisitor.isLiteralFalse(ex1) || SimplifyConstantIfBranchExecutionVisitor.isLiteralTrue(ex1)) {
                return (E)ex1;
            }
            return (E)this.cleanupBooleanExpression(ex1, context);
        }

        @Override
        public J visitIf(J.If if_, ExecutionContext context) {
            J.If if__ = (J.If)super.visitIf(if_, context);
            J.ControlParentheses<Expression> cp = this.cleanupBooleanExpression(if__.getIfCondition(), context);
            if (this.visitsKeyWord(if__ = if__.withIfCondition(cp))) {
                return if__;
            }
            Optional<Boolean> compileTimeConstantBoolean = SimplifyConstantIfBranchExecutionVisitor.isLiteralTrue(cp.getTree()) ? Optional.of(true) : (SimplifyConstantIfBranchExecutionVisitor.isLiteralFalse(cp.getTree()) ? Optional.of(false) : Optional.empty());
            if (!compileTimeConstantBoolean.isPresent()) {
                return if__;
            }
            if (compileTimeConstantBoolean.get().booleanValue()) {
                Statement s = if__.getThenPart();
                return this.maybeAutoFormat(if__, s, context);
            }
            if (if__.getElsePart() != null) {
                Statement s = if__.getElsePart().getBody();
                return this.maybeAutoFormat(if__, s, context);
            }
            return J.Block.createEmptyBlock();
        }

        private boolean visitsKeyWord(J.If iff) {
            if (SimplifyConstantIfBranchExecutionVisitor.isLiteralFalse(iff.getIfCondition().getTree())) {
                return false;
            }
            AtomicBoolean visitedCFKeyword = new AtomicBoolean(false);
            new JavaIsoVisitor<AtomicBoolean>(){

                @Override
                public J.Return visitReturn(J.Return _return, AtomicBoolean atomicBoolean) {
                    atomicBoolean.set(true);
                    return _return;
                }

                @Override
                public J.Continue visitContinue(J.Continue continueStatement, AtomicBoolean atomicBoolean) {
                    atomicBoolean.set(true);
                    return continueStatement;
                }

                @Override
                public J.Break visitBreak(J.Break breakStatement, AtomicBoolean atomicBoolean) {
                    atomicBoolean.set(true);
                    return breakStatement;
                }

                @Override
                public J.Throw visitThrow(J.Throw thrown, AtomicBoolean atomicBoolean) {
                    atomicBoolean.set(true);
                    return thrown;
                }
            }.visit(iff.getThenPart(), visitedCFKeyword);
            return visitedCFKeyword.get();
        }

        private static boolean isLiteralTrue(@Nullable Expression expression) {
            return J.Literal.isLiteralValue(expression, Boolean.TRUE);
        }

        private static boolean isLiteralFalse(@Nullable Expression expression) {
            return J.Literal.isLiteralValue(expression, Boolean.FALSE);
        }
    }
}

