/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.ClassHierarchy;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class FindClassHierarchy
extends Recipe {
    private final transient ClassHierarchy classHierarchy = new ClassHierarchy(this);

    public String getDisplayName() {
        return "Find class hierarchy";
    }

    public String getDescription() {
        return "Discovers all class declarations within a project, recording which files they appear in, their superclasses, and interfaces. That information is then recorded in a data table.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                JavaType.FullyQualified type = ((J.ClassDeclaration)cd).getType();
                if (type == null) {
                    return cd;
                }
                FindClassHierarchy.this.classHierarchy.insertRow(ctx, new ClassHierarchy.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), type.getFullyQualifiedName(), type.getSupertype() == null ? null : type.getSupertype().getFullyQualifiedName(), type.getInterfaces().isEmpty() ? null : type.getInterfaces().stream().map(JavaType.FullyQualified::getFullyQualifiedName).collect(Collectors.joining(","))));
                return cd;
            }
        };
    }

    public ClassHierarchy getClassHierarchy() {
        return this.classHierarchy;
    }

    @NonNull
    public String toString() {
        return "FindClassHierarchy(classHierarchy=" + (Object)((Object)this.getClassHierarchy()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindClassHierarchy)) {
            return false;
        }
        FindClassHierarchy other = (FindClassHierarchy)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindClassHierarchy;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

