/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeParentPom;
import org.openrewrite.semver.Semver;

public final class UpgradeParentVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.springframework.boot:spring-boot-parent:VERSION'.", example="org.springframework.boot")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.springframework.boot:spring-boot-parent:VERSION'.", example="spring-boot-parent")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Retain versions", description="Accepts a list of GAVs. For each GAV, if it is a project direct dependency, and it is removed from dependency management in the new parent pom, then it will be retained with an explicit version. The version can be omitted from the GAV to use the old value from dependency management", example="com.jcraft:jsch", required=false)
    @Nullable
    private final List<String> retainVersions;

    public String getDisplayName() {
        return "Upgrade Maven parent project version";
    }

    public String getDescription() {
        return "Set the parent pom version number according to a node-style semver selector or to a specific version number.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return this.changeParentPom().getVisitor();
    }

    private ChangeParentPom changeParentPom() {
        return new ChangeParentPom(this.groupId, null, this.artifactId, null, this.newVersion, null, null, this.versionPattern, false, this.retainVersions);
    }

    public UpgradeParentVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable List<String> retainVersions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.retainVersions = retainVersions;
    }

    @NonNull
    public String toString() {
        return "UpgradeParentVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", retainVersions=" + this.getRetainVersions() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeParentVersion)) {
            return false;
        }
        UpgradeParentVersion other = (UpgradeParentVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        List<String> this$retainVersions = this.getRetainVersions();
        List<String> other$retainVersions = other.getRetainVersions();
        return !(this$retainVersions == null ? other$retainVersions != null : !((Object)this$retainVersions).equals(other$retainVersions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeParentVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        List<String> $retainVersions = this.getRetainVersions();
        result = result * 59 + ($retainVersions == null ? 43 : ((Object)$retainVersions).hashCode());
        return result;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public List<String> getRetainVersions() {
        return this.retainVersions;
    }
}

