/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.HashSet;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class RemoveDuplicatePluginDeclarations
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    private static final XPathMatcher PLUGIN_MANAGEMENT_PLUGINS_MATCHER = new XPathMatcher("/project/build/pluginManagement/plugins");

    public String getDisplayName() {
        return "Remove duplicate plugin declarations";
    }

    public String getDescription() {
        return "Maven 4 rejects duplicate plugin declarations (same groupId and artifactId) with an error. This recipe removes duplicate plugin declarations, keeping only the first occurrence.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (PLUGINS_MATCHER.matches(this.getCursor()) || PLUGIN_MANAGEMENT_PLUGINS_MATCHER.matches(this.getCursor())) {
                    HashSet seenPlugins = new HashSet();
                    return t.withContent(ListUtils.filter((List)t.getContent(), content -> {
                        Xml.Tag pluginTag;
                        if (content instanceof Xml.Tag && "plugin".equals((pluginTag = (Xml.Tag)content).getName())) {
                            String groupId = pluginTag.getChildValue("groupId").orElse("org.apache.maven.plugins");
                            String artifactId = pluginTag.getChildValue("artifactId").orElse(null);
                            if (artifactId != null) {
                                return seenPlugins.add(groupId + ":" + artifactId);
                            }
                        }
                        return true;
                    }));
                }
                return t;
            }
        };
    }
}

