/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class FindProperties
extends Recipe {
    @Option(displayName="Property pattern", description="Regular expression pattern used to match property tag names.", example="guava.*")
    private final String propertyPattern;
    private final UUID searchId = Tree.randomId();

    public String getDisplayName() {
        return "Find Maven project properties";
    }

    public String getDescription() {
        return "Finds the specified Maven project properties within a pom.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern propertyMatcher = Pattern.compile(this.propertyPattern);
        final Pattern propertyUsageMatcher = Pattern.compile(".*\\$\\{" + propertyMatcher.pattern() + "}.*");
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext context) {
                Optional value;
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)context);
                if (this.isPropertyTag() && propertyMatcher.matcher(t.getName()).matches()) {
                    t = (Xml.Tag)SearchResult.found((Tree)t);
                }
                if ((value = t.getValue()).isPresent() && propertyUsageMatcher.matcher((CharSequence)value.get()).matches()) {
                    t = t.withContent(ListUtils.mapFirst((List)t.getContent(), v -> (Content)SearchResult.found((Tree)v, (String)this.getResolutionResult().getPom().getValue((String)value.get()))));
                }
                return t;
            }
        };
    }

    public static Set<Xml.Tag> find(Xml.Document xml, String propertyPattern) {
        final Pattern propertyMatcher = Pattern.compile(propertyPattern);
        HashSet<Xml.Tag> found = new HashSet<Xml.Tag>();
        new MavenVisitor<Set<Xml.Tag>>(){

            public Xml visitTag(Xml.Tag tag, Set<Xml.Tag> tags) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, tags);
                if (this.isPropertyTag() && propertyMatcher.matcher(tag.getName()).matches()) {
                    tags.add(t);
                }
                return t;
            }
        }.visit((Tree)xml, found);
        return found;
    }

    public FindProperties(String propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    public String getPropertyPattern() {
        return this.propertyPattern;
    }

    public UUID getSearchId() {
        return this.searchId;
    }

    @NonNull
    public String toString() {
        return "FindProperties(propertyPattern=" + this.getPropertyPattern() + ", searchId=" + this.getSearchId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindProperties)) {
            return false;
        }
        FindProperties other = (FindProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyPattern = this.getPropertyPattern();
        String other$propertyPattern = other.getPropertyPattern();
        if (this$propertyPattern == null ? other$propertyPattern != null : !this$propertyPattern.equals(other$propertyPattern)) {
            return false;
        }
        UUID this$searchId = this.getSearchId();
        UUID other$searchId = other.getSearchId();
        return !(this$searchId == null ? other$searchId != null : !((Object)this$searchId).equals(other$searchId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyPattern = this.getPropertyPattern();
        result = result * 59 + ($propertyPattern == null ? 43 : $propertyPattern.hashCode());
        UUID $searchId = this.getSearchId();
        result = result * 59 + ($searchId == null ? 43 : ((Object)$searchId).hashCode());
        return result;
    }
}

