/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PyTypeUtil {
    private PyTypeUtil() {
    }

    @NotNull
    public static <T extends PsiElement> List<T> getMembersOfType(@NotNull PyClassLikeType type, @NotNull Class<T> expectedMemberType, boolean inherited, @NotNull TypeEvalContext context) {
        if (type == null) {
            PyTypeUtil.$$$reportNull$$$0(0);
        }
        if (expectedMemberType == null) {
            PyTypeUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(2);
        }
        ArrayList result = new ArrayList();
        type.visitMembers(t -> {
            if (expectedMemberType.isInstance(t)) {
                PsiElement castedElement = t;
                result.add(castedElement);
            }
            return true;
        }, inherited, context);
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyTypeUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public static <T> T findData(@NotNull PyType type, @NotNull Key<T> key) {
        if (type == null) {
            PyTypeUtil.$$$reportNull$$$0(4);
        }
        if (key == null) {
            PyTypeUtil.$$$reportNull$$$0(5);
        }
        if (type instanceof UserDataHolder) {
            return ((UserDataHolder)((Object)type)).getUserData(key);
        }
        if (type instanceof PyUnionType) {
            for (PyType memberType : ((PyUnionType)type).getMembers()) {
                T result;
                if (memberType == null || (result = PyTypeUtil.findData(memberType, key)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public static PyTupleType toPositionalContainerType(@NotNull PsiElement anchor, @Nullable PyType elementType) {
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(6);
        }
        return PyTupleType.createHomogeneous(anchor, elementType);
    }

    @Nullable
    public static PyCollectionType toKeywordContainerType(@NotNull PsiElement anchor, @Nullable PyType valueType) {
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(7);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(anchor);
        return Optional.ofNullable(builtinCache.getDictType()).map(PyClassType::getPyClass).map(dictClass -> new PyCollectionTypeImpl((PyClass)dictClass, false, Arrays.asList(builtinCache.getStrType(), valueType))).orElse(null);
    }

    @NotNull
    public static StreamEx<PyType> toStream(@Nullable PyType type) {
        if (type instanceof PyUnionType) {
            StreamEx streamEx = StreamEx.of(((PyUnionType)type).getMembers());
            if (streamEx == null) {
                PyTypeUtil.$$$reportNull$$$0(8);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of((Object)type);
        if (streamEx == null) {
            PyTypeUtil.$$$reportNull$$$0(9);
        }
        return streamEx;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static Ref<PyType> notNullToRef(@Nullable PyType type) {
        return type == null ? null : Ref.create(type);
    }

    @NotNull
    public static Collector<Ref<PyType>, ?, Ref<PyType>> toUnionFromRef() {
        Collector<Object, ?, Object> collector = Collectors.reducing(null, (accType, hintType) -> {
            if (hintType == null) {
                return accType;
            }
            if (accType == null) {
                return hintType;
            }
            return Ref.create(PyUnionType.union((PyType)accType.get(), (PyType)hintType.get()));
        });
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(10);
        }
        return collector;
    }

    @NotNull
    public static Collector<PyType, ?, PyType> toUnion() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), PyUnionType::union);
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(11);
        }
        return collector;
    }

    public static boolean isDict(@Nullable PyType type) {
        return type instanceof PyCollectionType && "dict".equals(type.getName()) || type instanceof PyTypedDictType && ((PyTypedDictType)type).isInferred();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedMemberType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersOfType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toStream";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnionFromRef";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMembersOfType";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toPositionalContainerType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toKeywordContainerType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

