/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.FilterIterator;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.AbstractFilter;
import org.jdom.filter.Filter;
import org.jdom.filter2.ElementFilter;
import org.jdom.filter2.Filters;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Element
extends Content
implements Parent,
Serializable {
    protected String name;
    protected Namespace namespace;
    transient List<Namespace> additionalNamespaces;
    transient AttributeList attributes = null;
    protected transient ContentList content = new ContentList(this);

    protected Element() {
        super(Content.CType.Element);
    }

    public Element(String name, Namespace namespace) {
        super(Content.CType.Element);
        this.setName(name);
        this.setNamespace(namespace);
    }

    public Element(String name) {
        this(name, (Namespace)null);
    }

    public Element(String name, String uri) {
        this(name, Namespace.getNamespace("", uri));
    }

    public Element(String name, String prefix, String uri) {
        this(name, Namespace.getNamespace(prefix, uri));
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String name) {
        String reason = Verifier.checkElementName((String)name);
        if (reason != null) {
            throw new IllegalNameException(name, "element", reason);
        }
        this.name = name;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        String reason;
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (this.additionalNamespaces != null && (reason = Verifier.checkNamespaceCollision((Namespace)namespace, this.additionalNamespaces)) != null) {
            throw new IllegalAddException(this, namespace, reason);
        }
        if (this.hasAttributes()) {
            for (Attribute a : this.getAttributes()) {
                String reason2 = Verifier.checkNamespaceCollision((Namespace)namespace, (Attribute)a);
                if (reason2 == null) continue;
                throw new IllegalAddException(this, namespace, reason2);
            }
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace(String prefix) {
        if (prefix == null) {
            return null;
        }
        if ("xml".equals(prefix)) {
            return Namespace.XML_NAMESPACE;
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.additionalNamespaces != null) {
            for (Namespace ns : this.additionalNamespaces) {
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns;
            }
        }
        if (this.attributes != null) {
            for (Attribute a : this.attributes) {
                if (!prefix.equals(a.getNamespacePrefix())) continue;
                return a.getNamespace();
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(prefix);
        }
        return null;
    }

    public String getQualifiedName() {
        if ("".equals(this.namespace.getPrefix())) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ':' + this.name;
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList<Namespace>();
        } else {
            for (Namespace ns : this.additionalNamespaces) {
                if (ns != additionalNamespace) continue;
                return;
            }
        }
        String reason = Verifier.checkNamespaceCollision((Namespace)additionalNamespace, (Element)this);
        if (reason != null) {
            throw new IllegalAddException(this, additionalNamespace, reason);
        }
        this.additionalNamespaces.add(additionalNamespace);
    }

    public List<Namespace> getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    @Override
    public String getValue() {
        StringBuilder buffer = new StringBuilder();
        for (Content child : this.getContent()) {
            if (!(child instanceof Element) && !(child instanceof Text)) continue;
            buffer.append(child.getValue());
        }
        return buffer.toString();
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    @Override
    public int getContentSize() {
        return this.content.size();
    }

    @Override
    public int indexOf(Content child) {
        return this.content.indexOf(child);
    }

    public String getText() {
        if (this.content.size() == 0) {
            return "";
        }
        if (this.content.size() == 1) {
            Content obj = this.content.get(0);
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            return "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (Content obj : this.content) {
            if (!(obj instanceof Text)) continue;
            textContent.append(((Text)obj).getText());
            hasText = true;
        }
        if (!hasText) {
            return "";
        }
        return textContent.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getChildText(String cname) {
        Element child = this.getChild(cname);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildTextTrim(String cname) {
        Element child = this.getChild(cname);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildTextTrim(String cname, Namespace ns) {
        Element child = this.getChild(cname, ns);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildText(String cname, Namespace ns) {
        Element child = this.getChild(cname, ns);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public Element setText(String text) {
        this.content.clear();
        if (text != null) {
            this.addContent(new Text(text));
        }
        return this;
    }

    @Override
    public List<Content> getContent() {
        return this.content;
    }

    public <E extends Content> List<E> getContent(Filter<E> filter) {
        return this.content.getView(AbstractFilter.toFilter2(filter));
    }

    public Stream<Content> content() {
        return this.content.stream();
    }

    @Override
    public List<Content> removeContent() {
        ArrayList<Content> old = new ArrayList<Content>(this.content);
        this.content.clear();
        return old;
    }

    public <F extends Content> List<F> removeContent(Filter<F> filter) {
        ArrayList<Content> old = new ArrayList<Content>();
        Iterator iter = this.content.getView(AbstractFilter.toFilter2(filter)).iterator();
        while (iter.hasNext()) {
            Content child = (Content)iter.next();
            old.add(child);
            iter.remove();
        }
        return old;
    }

    public Element setContent(Collection<? extends Content> newContent) {
        this.content.clearAndSet(newContent);
        return this;
    }

    public Element setContent(int index, Content child) {
        this.content.set(index, child);
        return this;
    }

    public Parent setContent(int index, Collection<? extends Content> newContent) {
        this.content.remove(index);
        this.content.addAll(index, newContent);
        return this;
    }

    public Element addContent(String str) {
        return this.addContent(new Text(str));
    }

    @Override
    public Element addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public Element addContent(Element child) {
        this.content.add(child);
        return this;
    }

    @Override
    public Element addContent(Collection<? extends Content> newContent) {
        this.content.addAll(newContent);
        return this;
    }

    @Override
    public Element addContent(int index, Content child) {
        this.content.add(index, child);
        return this;
    }

    @Override
    public Element addContent(int index, Collection<? extends Content> newContent) {
        this.content.addAll(index, newContent);
        return this;
    }

    @Override
    public List<Content> cloneContent() {
        int size = this.getContentSize();
        ArrayList<Content> list = new ArrayList<Content>(size);
        for (int i = 0; i < size; ++i) {
            Content child = this.getContent(i);
            list.add(child.clone());
        }
        return list;
    }

    @Override
    public Content getContent(int index) {
        return this.content.get(index);
    }

    @Override
    public boolean removeContent(Content child) {
        return this.content.remove(child);
    }

    @Override
    public Content removeContent(int index) {
        return this.content.remove(index);
    }

    public Element setContent(Content child) {
        this.content.clear();
        this.content.add(child);
        return this;
    }

    public boolean isAncestor(Element element) {
        Parent p = element.getParent();
        while (p instanceof Element) {
            if (p == this) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasAdditionalNamespaces() {
        return this.additionalNamespaces != null && !this.additionalNamespaces.isEmpty();
    }

    private AttributeList getAttributeList() {
        if (this.attributes == null) {
            this.attributes = new AttributeList(this);
        }
        return this.attributes;
    }

    @ApiStatus.Internal
    public AttributeList initAttributeList(int attributeCount) {
        assert (this.attributes == null);
        this.attributes = new AttributeList(this, attributeCount);
        return this.attributes;
    }

    public List<Attribute> getAttributes() {
        return this.getAttributeList();
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute(name, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return null;
        }
        return this.getAttributeList().get(name, ns);
    }

    public String getAttributeValue(String name) {
        return this.attributes == null ? null : this.getAttributeValue(name, Namespace.NO_NAMESPACE, null);
    }

    public boolean getAttributeBooleanValue(@NotNull String name) {
        if (name == null) {
            Element.$$$reportNull$$$0(0);
        }
        return this.attributes != null && Boolean.parseBoolean(this.getAttributeValue(name, Namespace.NO_NAMESPACE, null));
    }

    public String getAttributeValue(String name, String def) {
        return this.attributes == null ? def : this.getAttributeValue(name, Namespace.NO_NAMESPACE, def);
    }

    public String getAttributeValue(String name, Namespace ns) {
        return this.getAttributeValue(name, ns, null);
    }

    public String getAttributeValue(String name, Namespace ns, String defaultValue) {
        Attribute attribute = this.attributes == null ? null : this.getAttributeList().get(name, ns);
        return attribute == null ? defaultValue : attribute.getValue();
    }

    public Element setAttributes(Collection<? extends Attribute> newAttributes) {
        this.getAttributeList().clearAndSet(newAttributes);
        return this;
    }

    public Element setAttributes(List<? extends Attribute> newAttributes) {
        this.getAttributeList().clearAndSet(newAttributes);
        return this;
    }

    public Element setAttribute(String name, String value) {
        Attribute attribute = this.getAttribute(name);
        if (attribute == null) {
            Attribute newAttribute = new Attribute(name, value);
            this.setAttribute(newAttribute);
        } else {
            attribute.setValue(value);
        }
        return this;
    }

    public Element setAttribute(String name, String value, Namespace ns) {
        Attribute attribute = this.getAttribute(name, ns);
        if (attribute == null) {
            Attribute newAttribute = new Attribute(name, value, ns);
            this.setAttribute(newAttribute);
        } else {
            attribute.setValue(value);
        }
        return this;
    }

    public Element setAttribute(Attribute attribute) {
        this.getAttributeList().add(attribute);
        return this;
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(name, Namespace.NO_NAMESPACE);
    }

    public void sortChildren(Comparator<? super Element> comparator) {
        this.content.getView(Filters.element()).sort(comparator);
    }

    public boolean removeAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return false;
        }
        return this.getAttributeList().remove(name, ns);
    }

    public boolean removeAttribute(Attribute attribute) {
        if (this.attributes == null) {
            return false;
        }
        return this.getAttributeList().remove(attribute);
    }

    public String toString() {
        StringBuilder stringForm = new StringBuilder(64).append("[Element: <").append(this.getQualifiedName());
        String namespaceUri = this.getNamespaceURI();
        if (!"".equals(namespaceUri)) {
            stringForm.append(" [Namespace: ").append(namespaceUri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    @Override
    public Element clone() {
        int i;
        Element element = (Element)super.clone();
        element.content = new ContentList(element);
        AttributeList attributeList = element.attributes = this.attributes == null ? null : new AttributeList(element);
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.size(); ++i) {
                Attribute attribute = this.attributes.get(i);
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        for (i = 0; i < this.content.size(); ++i) {
            Content c = this.content.get(i);
            element.content.add(c.clone());
        }
        return element;
    }

    @Override
    public Iterator<Content> getDescendants() {
        return new DescendantIterator(this);
    }

    @Deprecated
    public <F extends Content> Iterator<F> getDescendants(Filter<F> filter) {
        return new FilterIterator(new DescendantIterator(this), AbstractFilter.toFilter2(filter));
    }

    public <F extends Content> Iterator<F> getDescendants(org.jdom.filter2.Filter<F> filter) {
        return new FilterIterator<F>(new DescendantIterator(this), filter);
    }

    public List<Element> getChildren() {
        return this.content.getView(Filters.element());
    }

    public List<Element> getChildren(String cname) {
        return this.getChildren(cname, Namespace.NO_NAMESPACE);
    }

    public List<Element> getChildren(String cname, Namespace ns) {
        return this.content.getView(new ElementFilter(cname, ns));
    }

    public Element getChild(String cname, Namespace ns) {
        Iterator<Element> iterator2 = this.content.getView(new ElementFilter(cname, ns)).iterator();
        return iterator2.hasNext() ? iterator2.next() : null;
    }

    public Element getChild(String cname) {
        return this.getChild(cname, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String cname) {
        return this.removeChild(cname, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String cname, Namespace ns) {
        ElementFilter filter = new ElementFilter(cname, ns);
        List<Element> old = this.content.getView(filter);
        Iterator<Element> iter = old.iterator();
        if (iter.hasNext()) {
            iter.next();
            iter.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String cname) {
        return this.removeChildren(cname, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String cname, Namespace ns) {
        boolean deletedSome = false;
        ElementFilter filter = new ElementFilter(cname, ns);
        List<Element> old = this.content.getView(filter);
        Iterator<Element> iter = old.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
            deletedSome = true;
        }
        return deletedSome;
    }

    public List<Namespace> getNamespacesInScope() {
        Element pnt;
        TreeMap<String, Namespace> namespaces = new TreeMap<String, Namespace>();
        namespaces.put(Namespace.XML_NAMESPACE.getPrefix(), Namespace.XML_NAMESPACE);
        namespaces.put(this.getNamespacePrefix(), this.getNamespace());
        if (this.additionalNamespaces != null) {
            for (Namespace namespace : this.getAdditionalNamespaces()) {
                if (namespaces.containsKey(namespace.getPrefix())) continue;
                namespaces.put(namespace.getPrefix(), namespace);
            }
        }
        if (this.attributes != null) {
            for (Attribute attribute : this.getAttributes()) {
                Namespace ns = attribute.getNamespace();
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if ((pnt = this.getParentElement()) != null) {
            for (Namespace ns : pnt.getNamespacesInScope()) {
                if (namespaces.containsKey(ns.getPrefix())) continue;
                namespaces.put(ns.getPrefix(), ns);
            }
        }
        if (pnt == null && !namespaces.containsKey("")) {
            namespaces.put(Namespace.NO_NAMESPACE.getPrefix(), Namespace.NO_NAMESPACE);
        }
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>(namespaces.size());
        arrayList.add(this.getNamespace());
        namespaces.remove(this.getNamespacePrefix());
        arrayList.addAll(namespaces.values());
        return Collections.unmodifiableList(arrayList);
    }

    public List<Namespace> getNamespacesIntroduced() {
        if (this.getParentElement() == null) {
            ArrayList<Namespace> ret = new ArrayList<Namespace>(this.getNamespacesInScope());
            ret.removeIf(ns -> ns == Namespace.XML_NAMESPACE || ns == Namespace.NO_NAMESPACE);
            return Collections.unmodifiableList(ret);
        }
        HashMap<String, Namespace> parents = new HashMap<String, Namespace>();
        for (Namespace ns2 : this.getParentElement().getNamespacesInScope()) {
            parents.put(ns2.getPrefix(), ns2);
        }
        ArrayList<Namespace> al = new ArrayList<Namespace>();
        for (Namespace ns3 : this.getNamespacesInScope()) {
            if (parents.containsKey(ns3.getPrefix()) && ns3 == parents.get(ns3.getPrefix())) continue;
            al.add(ns3);
        }
        return Collections.unmodifiableList(al);
    }

    @Override
    public Element detach() {
        return (Element)super.detach();
    }

    @Override
    public void canContainContent(Content child, int index, boolean replace) throws IllegalAddException {
        if (child instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }

    public boolean isEmpty() {
        return !this.hasAttributes() && this.getContent().isEmpty();
    }

    public void sortAttributes(Comparator<? super Attribute> comparator) {
        if (this.attributes != null) {
            this.attributes.sort(comparator);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int ans;
        out.defaultWriteObject();
        if (this.hasAdditionalNamespaces()) {
            ans = this.additionalNamespaces.size();
            out.writeInt(ans);
            for (Namespace additionalNamespace : this.additionalNamespaces) {
                out.writeObject(additionalNamespace);
            }
        } else {
            out.writeInt(0);
        }
        if (this.hasAttributes()) {
            ans = this.attributes.size();
            out.writeInt(ans);
            for (Attribute attribute : this.attributes) {
                out.writeObject(attribute);
            }
        } else {
            out.writeInt(0);
        }
        int cs = this.content.size();
        out.writeInt(cs);
        for (Content value : this.content) {
            out.writeObject(value);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.content = new ContentList(this);
        int nss = in.readInt();
        while (--nss >= 0) {
            this.addNamespaceDeclaration((Namespace)in.readObject());
        }
        int ats = in.readInt();
        while (--ats >= 0) {
            this.setAttribute((Attribute)in.readObject());
        }
        int cs = in.readInt();
        while (--cs >= 0) {
            this.addContent((Content)in.readObject());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jdom/Element", "getAttributeBooleanValue"));
    }
}

