/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.python.psi.PyElementType;
import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.tree.PyComment;
import org.openrewrite.python.tree.PySpace;

public abstract class PsiUtils {
    private PsiUtils() {
    }

    public static boolean isHiddenElement(PsiElement element) {
        return element.getTextLength() == 0;
    }

    public static boolean isLeafToken(@Nullable PsiElement element, PyElementType elementType) {
        if (element instanceof LeafPsiElement) {
            LeafPsiElement leaf = (LeafPsiElement)element;
            return leaf.getElementType() == elementType;
        }
        return false;
    }

    @Nullable
    public static PsiElement maybeFindChildToken(PsiElement parent, PyElementType elementType) {
        ASTNode node = parent.getNode().findChildByType(elementType);
        if (node == null) {
            return null;
        }
        return node.getPsi();
    }

    @Nullable
    public static PsiElement maybeFindFirstChildToken(PsiElement parent, PyElementType elementType, PyElementType ... otherElementTypes) {
        PsiElement maybeMatch = PsiUtils.maybeFindChildToken(parent, elementType);
        for (PyElementType otherElementType : otherElementTypes) {
            PsiElement maybeOtherMatch = PsiUtils.maybeFindChildToken(parent, otherElementType);
            if (maybeOtherMatch == null || maybeMatch != null && maybeMatch.getTextOffset() <= maybeOtherMatch.getTextOffset()) continue;
            maybeMatch = maybeOtherMatch;
        }
        return maybeMatch;
    }

    public static PsiElement findFirstChildToken(PsiElement parent, PyElementType elementType, PyElementType ... otherElementTypes) {
        @Nullable PsiElement maybeMatch = PsiUtils.maybeFindFirstChildToken(parent, elementType, otherElementTypes);
        if (maybeMatch == null) {
            throw new IllegalStateException(String.format("Expected to find a child node of type %s (+%d others) match but found none", elementType, otherElementTypes.length));
        }
        return maybeMatch;
    }

    public static PsiElement findChildToken(PsiElement parent, PyElementType elementType) {
        PsiElement found = PsiUtils.maybeFindChildToken(parent, elementType);
        if (found == null) {
            throw new IllegalStateException(String.format("Expected to find a child node of type %s match but found none", elementType));
        }
        return found;
    }

    @Nullable
    public static PsiElement nextSiblingSkipWhitespace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        while ((element = element.getNextSibling()) instanceof PsiWhiteSpace || element instanceof PsiComment) {
        }
        return element;
    }

    @Nullable
    public static LeafPsiElement maybeFindPreviousSiblingToken(PsiElement element, PyElementType elementType) {
        while (element != null) {
            if (PsiUtils.isLeafToken(element, elementType)) {
                return (LeafPsiElement)element;
            }
            element = element.getPrevSibling();
        }
        return null;
    }

    public static Space findLeadingSpaceInTree(PsiElement current) {
        ArrayList<PsiElement> spaceElements = null;
        int startOffset = current.getNode().getStartOffset();
        do {
            if (PsiUtils.isWhitespaceOrComment(current = current.getPrevSibling() != null ? current.getPrevSibling() : current.getParent())) {
                if (spaceElements == null) {
                    spaceElements = new ArrayList<PsiElement>();
                }
                spaceElements.add(current);
                continue;
            }
            if (spaceElements != null) break;
        } while (current != null && current.getNode().getStartOffset() == startOffset);
        if (spaceElements == null) {
            return Space.EMPTY;
        }
        PySpace.SpaceBuilder builder = new PySpace.SpaceBuilder();
        for (int i = spaceElements.size() - 1; i >= 0; --i) {
            PsiElement spaceOrComment = (PsiElement)spaceElements.get(i);
            if (current instanceof PsiComment) {
                builder.addComment(spaceOrComment.getText());
                continue;
            }
            if (current instanceof PsiWhiteSpace) {
                builder.addWhitespace(spaceOrComment.getText());
                continue;
            }
            throw new IllegalStateException("unexpected");
        }
        return builder.build();
    }

    public static LeafPsiElement findPreviousSiblingToken(PsiElement element, PyElementType elementType) {
        LeafPsiElement found = PsiUtils.maybeFindPreviousSiblingToken(element, elementType);
        if (found == null) {
            throw new IllegalStateException(String.format("Expected to find a previous sibling of type %s match but found none", elementType));
        }
        return found;
    }

    public static boolean matchesTokenSequence(PsiElement current, PyElementType ... tokens) {
        for (PyElementType token : tokens) {
            if (current == null) {
                return false;
            }
            if (!PsiUtils.isLeafToken(current, token)) {
                return false;
            }
            current = current.getNextSibling();
            while (current instanceof PsiWhiteSpace) {
                current = current.getNextSibling();
            }
        }
        return true;
    }

    public static PsiElement findSpaceStart(@Nullable PsiElement spaceElement) {
        if (spaceElement == null) {
            return null;
        }
        if (!PsiUtils.isWhitespaceOrComment(spaceElement)) {
            throw new IllegalArgumentException("expected whitespace element; found: " + spaceElement);
        }
        while (PsiUtils.isWhitespaceOrComment(spaceElement.getPrevSibling())) {
            spaceElement = spaceElement.getPrevSibling();
        }
        return spaceElement;
    }

    public static PsiElement findSpaceEnd(@Nullable PsiElement spaceElement) {
        if (spaceElement == null) {
            return null;
        }
        if (!PsiUtils.isWhitespaceOrComment(spaceElement)) {
            throw new IllegalArgumentException("expected whitespace element; found: " + spaceElement);
        }
        while (PsiUtils.isWhitespaceOrComment(spaceElement.getNextSibling())) {
            spaceElement = spaceElement.getNextSibling();
        }
        return spaceElement;
    }

    public static Space spaceBefore(@Nullable PsiElement element) {
        PsiElement end;
        if (element == null) {
            return Space.EMPTY;
        }
        for (end = element.getPrevSibling(); end != null && PsiUtils.isHiddenElement(end); end = end.getPrevSibling()) {
        }
        if (!PsiUtils.isWhitespaceOrComment(end)) {
            return Space.EMPTY;
        }
        return PsiUtils.mergeSpace(PsiUtils.findSpaceStart(end), end);
    }

    public static Space spaceAfter(@Nullable PsiElement element) {
        PsiElement begin;
        if (element == null) {
            return Space.EMPTY;
        }
        for (begin = element.getNextSibling(); begin != null && PsiUtils.isHiddenElement(begin); begin = begin.getNextSibling()) {
        }
        if (!PsiUtils.isWhitespaceOrComment(begin)) {
            return Space.EMPTY;
        }
        return PsiUtils.mergeSpace(begin, PsiUtils.findSpaceEnd(begin));
    }

    public static Space trailingSpace(@Nullable PsiElement element) {
        if (element == null) {
            return Space.EMPTY;
        }
        PsiElement end = element.getLastChild();
        if (!PsiUtils.isWhitespaceOrComment(end)) {
            return Space.EMPTY;
        }
        PsiElement begin = end;
        while (PsiUtils.isWhitespaceOrComment(begin.getPrevSibling())) {
            begin = begin.getPrevSibling();
        }
        return PsiUtils.mergeSpace(begin, end);
    }

    public static Space mergeSpace(PsiElement firstSpaceOrComment, PsiElement lastSpaceOrComment) {
        PsiElementCursor psiElementCursor = PsiUtils.elementsBetween(firstSpaceOrComment, lastSpaceOrComment);
        String prefix = psiElementCursor.consumeWhitespace();
        ArrayList<PyComment> comments = null;
        while (!psiElementCursor.isPastEnd()) {
            if (comments == null) {
                comments = new ArrayList<PyComment>();
            }
            String commentText = psiElementCursor.consumeExpectingType(PsiComment.class).getText();
            String suffix = psiElementCursor.consumeWhitespace();
            if (!commentText.startsWith("#")) {
                throw new IllegalStateException(String.format("expected Python comment to start with `#`; found: `%s`", Character.valueOf(commentText.charAt(0))));
            }
            commentText = commentText.substring(1);
            comments.add(new PyComment(commentText, suffix, false, Markers.EMPTY));
        }
        return Space.build((String)prefix, comments == null ? Collections.emptyList() : comments);
    }

    public static boolean isWhitespaceOrComment(@Nullable PsiElement element) {
        return element instanceof PsiComment || element instanceof PsiWhiteSpace;
    }

    public static PsiElementCursor elementsBetween(@Nullable PsiElement begin, @Nullable PsiElement endInclusive) {
        return new PsiElementCursor(begin, endInclusive);
    }

    public static class PsiElementCursor {
        @Nullable
        private PsiElement current;
        @Nullable
        private final PsiElement end;

        public PsiElementCursor(@Nullable PsiElement current, @Nullable PsiElement end) {
            this.current = current;
            this.end = end;
        }

        public void advance() {
            this.current = this.current == null || this.current == this.end ? null : this.current.getNextSibling();
        }

        public PsiElement consume() {
            PsiElement element = this.current();
            this.advance();
            return element;
        }

        public <T extends PsiElement> T consumeExpectingType(Class<T> clazz) {
            PsiElement element = this.consume();
            if (!clazz.isInstance(element)) {
                throw new IllegalStateException(String.format("expected a %s, but next element is a %s", clazz.getName(), element.getClass().getName()));
            }
            return (T)element;
        }

        public String consumeWhitespace() {
            String whitespace = null;
            while (this.current instanceof PsiWhiteSpace) {
                String part = this.current.getText();
                whitespace = whitespace == null ? part : whitespace + part;
                this.advance();
            }
            return whitespace == null ? "" : whitespace;
        }

        public PsiElement current() {
            if (this.current == null) {
                throw new IllegalStateException("cannot call current() if cursor is past the end");
            }
            return this.current;
        }

        public boolean isPastEnd() {
            return this.current == null;
        }
    }
}

