/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.xml.XPathCompiler;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class XPathMatcher {
    private final String expression;
    private volatile XPathCompiler.CompiledXPath compiled;

    public XPathMatcher(String expression) {
        this.expression = expression;
    }

    public boolean matches(Cursor cursor) {
        XPathCompiler.CompiledXPath xpath = this.compile();
        if (xpath.isPathExpression() && xpath.steps.length > 0) {
            return this.matchBottomUp(cursor);
        }
        return this.matchTopDown(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathCompiler.CompiledXPath compile() {
        XPathCompiler.CompiledXPath result = this.compiled;
        if (result == null) {
            XPathMatcher xPathMatcher = this;
            synchronized (xPathMatcher) {
                result = this.compiled;
                if (result == null) {
                    this.compiled = result = XPathCompiler.compile(this.expression);
                }
            }
        }
        return result;
    }

    private boolean matchBottomUp(Cursor cursor) {
        XPathCompiler.CompiledStep[] steps = this.compiled.steps;
        Object cursorValue = cursor.getValue();
        XPathCompiler.CompiledStep lastStep = steps[steps.length - 1];
        if (lastStep.getType() == XPathCompiler.StepType.ATTRIBUTE_STEP) {
            if (!(cursorValue instanceof Xml.Attribute)) {
                return false;
            }
            Xml.Attribute attr = (Xml.Attribute)cursorValue;
            if (!XPathMatcher.matchesName(lastStep.getName(), attr.getKeyAsString())) {
                return false;
            }
            if (lastStep.getPredicates().length > 0 && !this.evaluateAttributePredicatesBottomUp(lastStep.getPredicates(), attr, cursor)) {
                return false;
            }
            Cursor parentCursor = cursor.getParent();
            if (parentCursor == null || !(parentCursor.getValue() instanceof Xml.Tag)) {
                return false;
            }
            return this.matchRemainingStepsBottomUp(parentCursor, steps.length - 2);
        }
        if (lastStep.getType() == XPathCompiler.StepType.NODE_TYPE_TEST) {
            return this.matchNodeTypeTestBottomUp(lastStep, cursor, steps.length - 2);
        }
        if (lastStep.getType() == XPathCompiler.StepType.ABBREVIATED_DOTDOT || lastStep.getType() == XPathCompiler.StepType.AXIS_STEP && lastStep.getAxisType() == XPathCompiler.AxisType.PARENT) {
            return this.matchParentStepAsLast(lastStep, cursor, steps.length - 2);
        }
        if (lastStep.getType() == XPathCompiler.StepType.ABBREVIATED_DOT || lastStep.getType() == XPathCompiler.StepType.AXIS_STEP && lastStep.getAxisType() == XPathCompiler.AxisType.SELF) {
            if (!(cursorValue instanceof Xml.Tag)) {
                return false;
            }
            Xml.Tag tag = (Xml.Tag)cursorValue;
            if (lastStep.getType() == XPathCompiler.StepType.AXIS_STEP && !XPathMatcher.matchesElementName(lastStep.getName(), tag.getName())) {
                return false;
            }
            return this.matchRemainingStepsBottomUp(cursor, steps.length - 2);
        }
        if (!(cursorValue instanceof Xml.Tag)) {
            return false;
        }
        Xml.Tag currentTag = (Xml.Tag)cursorValue;
        if (!this.matchStepAgainstTag(lastStep, currentTag, cursor)) {
            return false;
        }
        Cursor parentCursor = this.getParentTagCursor(cursor);
        return this.matchRemainingStepsBottomUp(parentCursor, steps.length - 2);
    }

    private boolean matchParentStepAsLast(XPathCompiler.CompiledStep parentStep, Cursor cursor, int prevStepIdx) {
        Object cursorValue = cursor.getValue();
        if (!(cursorValue instanceof Xml.Tag)) {
            return false;
        }
        Xml.Tag currentTag = (Xml.Tag)cursorValue;
        if (parentStep.type == XPathCompiler.StepType.AXIS_STEP && !XPathMatcher.matchesElementName(parentStep.name, currentTag.getName())) {
            return false;
        }
        if (prevStepIdx >= 0) {
            XPathCompiler.CompiledStep prevStep = this.compiled.steps[prevStepIdx];
            if (prevStep.type == XPathCompiler.StepType.NODE_TEST && prevStep.name != null && !this.hasChildWithName(currentTag, prevStep.name)) {
                return false;
            }
            return this.matchRemainingStepsBottomUp(cursor, prevStepIdx - 1);
        }
        return true;
    }

    private boolean hasChildWithName(Xml.Tag parent, String childName) {
        return this.findChildTag(parent, childName) != null;
    }

    private boolean matchParentStepInMiddle(@Nullable Cursor cursor, int prevStepIdx) {
        if (cursor == null || !(cursor.getValue() instanceof Xml.Tag)) {
            return false;
        }
        Xml.Tag currentTag = (Xml.Tag)cursor.getValue();
        if (prevStepIdx < 0) {
            if ((this.compiled.flags & 1) != 0 && !this.compiled.steps[0].isDescendant) {
                Cursor parentCursor = this.getParentTagCursor(cursor);
                return parentCursor == null || !(parentCursor.getValue() instanceof Xml.Tag);
            }
            return true;
        }
        XPathCompiler.CompiledStep prevStep = this.compiled.steps[prevStepIdx];
        if (prevStep.type == XPathCompiler.StepType.NODE_TEST && prevStep.name != null) {
            if (!this.hasChildWithName(currentTag, prevStep.name)) {
                return false;
            }
            return this.matchRemainingStepsBottomUp(cursor, prevStepIdx - 1);
        }
        return this.matchRemainingStepsBottomUp(cursor, prevStepIdx - 1);
    }

    private boolean evaluateAttributePredicatesBottomUp(XPathCompiler.CompiledExpr[] predicates, Xml.Attribute attr, Cursor cursor) {
        for (XPathCompiler.CompiledExpr predicate : predicates) {
            if (this.evaluateExpr(predicate, null, attr, cursor, 1, 1)) continue;
            return false;
        }
        return true;
    }

    private boolean matchNodeTypeTestBottomUp(XPathCompiler.CompiledStep step, Cursor cursor, int nextStepIdx) {
        Object cursorValue = cursor.getValue();
        switch (step.nodeTypeTestType) {
            case TEXT: {
                Xml.Tag tag;
                if (cursorValue instanceof Xml.CharData) {
                    Cursor parentCursor = this.getParentTagCursor(cursor);
                    return this.matchRemainingStepsBottomUp(parentCursor, nextStepIdx);
                }
                if (cursorValue instanceof Xml.Tag && (tag = (Xml.Tag)cursorValue).getValue().isPresent()) {
                    return this.matchRemainingStepsBottomUp(cursor, nextStepIdx);
                }
                return false;
            }
            case COMMENT: {
                if (cursorValue instanceof Xml.Comment) {
                    Cursor parentCursor = this.getParentTagCursor(cursor);
                    return this.matchRemainingStepsBottomUp(parentCursor, nextStepIdx);
                }
                return false;
            }
            case NODE: {
                Cursor parentCursor = this.getParentTagCursor(cursor);
                return this.matchRemainingStepsBottomUp(parentCursor, nextStepIdx);
            }
            case PROCESSING_INSTRUCTION: {
                if (cursorValue instanceof Xml.ProcessingInstruction) {
                    Cursor parentCursorPi = this.getParentTagCursor(cursor);
                    return this.matchRemainingStepsBottomUp(parentCursorPi, nextStepIdx);
                }
                return false;
            }
        }
        return false;
    }

    private boolean matchRemainingStepsBottomUp(@Nullable Cursor cursor, int stepIdx) {
        if (stepIdx < 0) {
            if ((this.compiled.flags & 1) != 0) {
                return cursor == null || !(cursor.getValue() instanceof Xml.Tag);
            }
            return true;
        }
        XPathCompiler.CompiledStep step = this.compiled.steps[stepIdx];
        switch (step.type) {
            case ABBREVIATED_DOT: {
                return this.matchRemainingStepsBottomUp(cursor, stepIdx - 1);
            }
            case ABBREVIATED_DOTDOT: {
                return this.matchParentStepInMiddle(cursor, stepIdx - 1);
            }
            case AXIS_STEP: {
                return this.matchAxisStepBottomUp(step, cursor, stepIdx);
            }
            case NODE_TYPE_TEST: {
                return this.matchNodeTypeStepBottomUp(step, cursor, stepIdx);
            }
        }
        XPathCompiler.CompiledStep nextStep = this.compiled.steps[stepIdx + 1];
        if (nextStep.isDescendant) {
            Cursor pos = cursor;
            while (pos != null && pos.getValue() instanceof Xml.Tag) {
                Cursor nextParent;
                Xml.Tag tag = (Xml.Tag)pos.getValue();
                if (this.matchStepAgainstTag(step, tag, pos) && this.matchRemainingStepsBottomUp(nextParent = this.getParentTagCursor(pos), stepIdx - 1)) {
                    return true;
                }
                pos = this.getParentTagCursor(pos);
            }
            return false;
        }
        if (cursor == null || !(cursor.getValue() instanceof Xml.Tag)) {
            return false;
        }
        Xml.Tag tag = (Xml.Tag)cursor.getValue();
        if (!this.matchStepAgainstTag(step, tag, cursor)) {
            return false;
        }
        Cursor nextParent = this.getParentTagCursor(cursor);
        return this.matchRemainingStepsBottomUp(nextParent, stepIdx - 1);
    }

    private boolean matchAxisStepBottomUp(XPathCompiler.CompiledStep step, @Nullable Cursor cursor, int stepIdx) {
        switch (step.axisType) {
            case PARENT: {
                Xml.Tag tag;
                if (cursor != null && cursor.getValue() instanceof Xml.Tag && !XPathMatcher.matchesElementName(step.name, (tag = (Xml.Tag)cursor.getValue()).getName())) {
                    return false;
                }
                return this.matchParentStepInMiddle(cursor, stepIdx - 1);
            }
            case SELF: {
                Xml.Tag tag;
                if (cursor != null && cursor.getValue() instanceof Xml.Tag && !XPathMatcher.matchesElementName(step.name, (tag = (Xml.Tag)cursor.getValue()).getName())) {
                    return false;
                }
                return this.matchRemainingStepsBottomUp(cursor, stepIdx - 1);
            }
            case CHILD: {
                if (cursor == null || !(cursor.getValue() instanceof Xml.Tag)) {
                    return false;
                }
                Xml.Tag tag = (Xml.Tag)cursor.getValue();
                if (!this.matchStepAgainstTag(step, tag, cursor)) {
                    return false;
                }
                return this.matchRemainingStepsBottomUp(this.getParentTagCursor(cursor), stepIdx - 1);
            }
        }
        return false;
    }

    private boolean matchNodeTypeStepBottomUp(XPathCompiler.CompiledStep step, @Nullable Cursor cursor, int stepIdx) {
        switch (step.nodeTypeTestType) {
            case NODE: {
                return this.matchRemainingStepsBottomUp(cursor, stepIdx - 1);
            }
        }
        return false;
    }

    private @Nullable Cursor getParentTagCursor(@Nullable Cursor cursor) {
        Cursor parent;
        if (cursor == null) {
            return null;
        }
        for (parent = cursor.getParent(); parent != null && !(parent.getValue() instanceof Xml.Tag); parent = parent.getParent()) {
            if (!(parent.getValue() instanceof Xml.Document)) continue;
            return null;
        }
        return parent;
    }

    private  @Nullable Xml.Tag getParentTag(Cursor cursor) {
        Cursor parentCursor = this.getParentTagCursor(cursor);
        if (parentCursor != null && parentCursor.getValue() instanceof Xml.Tag) {
            return (Xml.Tag)parentCursor.getValue();
        }
        return null;
    }

    private boolean matchStepAgainstTag(XPathCompiler.CompiledStep step, Xml.Tag tag, Cursor cursor) {
        switch (step.strategy) {
            case 0: {
                return step.name.equals(tag.getName());
            }
            case 1: {
                if (!step.name.equals(tag.getName())) {
                    return false;
                }
                return this.evaluatePredicates(step.predicates, tag, cursor);
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.evaluatePredicates(step.predicates, tag, cursor);
            }
            case 4: {
                return true;
            }
            case 5: {
                return step.nodeTypeTestType == XPathCompiler.NodeTypeTestType.NODE;
            }
        }
        return this.matchStepAgainstTagGeneric(step, tag, cursor);
    }

    private boolean matchStepAgainstTagGeneric(XPathCompiler.CompiledStep step, Xml.Tag tag, Cursor cursor) {
        switch (step.type) {
            case NODE_TEST: {
                if (XPathMatcher.matchesName(step.name, tag.getName())) break;
                return false;
            }
            case ABBREVIATED_DOT: {
                break;
            }
            case NODE_TYPE_TEST: {
                if (step.nodeTypeTestType == XPathCompiler.NodeTypeTestType.NODE) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if (step.predicates.length > 0) {
            return this.evaluatePredicates(step.predicates, tag, cursor);
        }
        return true;
    }

    private boolean evaluatePredicates(XPathCompiler.CompiledExpr[] predicates, Xml.Tag tag, Cursor cursor) {
        Xml.Tag parent;
        List<? extends Content> contents;
        int position = 1;
        int size = 1;
        Cursor parentCursor = cursor.getParent();
        if (parentCursor != null && parentCursor.getValue() instanceof Xml.Tag && (contents = (parent = (Xml.Tag)parentCursor.getValue()).getContent()) != null) {
            int count = 0;
            for (Content content : contents) {
                Xml.Tag child;
                if (!(content instanceof Xml.Tag) || !(child = (Xml.Tag)content).getName().equals(tag.getName())) continue;
                ++count;
                if (child != tag) continue;
                position = count;
            }
            size = count > 0 ? count : 1;
        }
        for (XPathCompiler.CompiledExpr predicate : predicates) {
            if (this.evaluateExpr(predicate, tag, null, cursor, position, size)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateExpr(XPathCompiler.CompiledExpr expr,  @Nullable Xml.Tag tag,  @Nullable Xml.Attribute attr, Cursor cursor, int position, int size) {
        switch (expr.type) {
            case NUMERIC: {
                return position == expr.numericValue;
            }
            case AND: {
                return this.evaluateExpr(expr.left, tag, attr, cursor, position, size) && this.evaluateExpr(expr.right, tag, attr, cursor, position, size);
            }
            case OR: {
                return this.evaluateExpr(expr.left, tag, attr, cursor, position, size) || this.evaluateExpr(expr.right, tag, attr, cursor, position, size);
            }
            case COMPARISON: {
                return this.evaluateComparison(expr, tag, attr, cursor, position, size);
            }
            case FUNCTION: {
                return this.evaluateFunction(expr, tag, attr, cursor, position, size);
            }
            case CHILD: {
                return tag != null && this.hasChildElement(tag, expr.name);
            }
            case PATH: {
                return tag != null && this.pathExists(tag, expr);
            }
            case ATTRIBUTE: {
                return tag != null && this.hasAttribute(tag, expr.name);
            }
            case BOOLEAN: {
                return expr.booleanValue;
            }
        }
        return false;
    }

    private boolean evaluateComparison(XPathCompiler.CompiledExpr expr,  @Nullable Xml.Tag tag,  @Nullable Xml.Attribute attr, Cursor cursor, int position, int size) {
        Object leftValue = this.resolveValue(expr.left, tag, attr, cursor, position, size);
        Object rightValue = this.resolveValue(expr.right, tag, attr, cursor, position, size);
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return XPathMatcher.compareValues(leftValue, rightValue, expr.op);
    }

    private @Nullable Object resolveValue(XPathCompiler.CompiledExpr expr,  @Nullable Xml.Tag tag,  @Nullable Xml.Attribute attr, Cursor cursor, int position, int size) {
        switch (expr.type) {
            case STRING: {
                return expr.stringValue;
            }
            case NUMERIC: {
                return expr.numericValue;
            }
            case CHILD: {
                return tag != null ? this.getChildElementValue(tag, expr.name) : null;
            }
            case ATTRIBUTE: {
                if (tag != null) {
                    return this.getAttributeValue(tag, expr.name);
                }
                if (attr != null) {
                    if (expr.name == null || "*".equals(expr.name)) {
                        return attr.getValueAsString();
                    }
                    Cursor parentCursor = cursor.getParent();
                    if (parentCursor != null && parentCursor.getValue() instanceof Xml.Tag) {
                        return this.getAttributeValue((Xml.Tag)parentCursor.getValue(), expr.name);
                    }
                }
                return null;
            }
            case PATH: {
                return tag != null ? this.resolvePathValue(expr, tag) : null;
            }
            case ABSOLUTE_PATH: {
                Set<Xml.Tag> pathMatches;
                Xml.Tag root;
                if (expr.stringValue != null && (root = this.getRootTag(cursor)) != null && !(pathMatches = this.findTagsByPath(root, expr.stringValue)).isEmpty()) {
                    return pathMatches.iterator().next().getValue().orElse("");
                }
                return "";
            }
            case FUNCTION: {
                return this.resolveFunctionValue(expr, tag, attr, cursor, position, size);
            }
        }
        return null;
    }

    private boolean evaluateFunction(XPathCompiler.CompiledExpr expr,  @Nullable Xml.Tag tag,  @Nullable Xml.Attribute attr, Cursor cursor, int position, int size) {
        if (expr.functionType == null) {
            return false;
        }
        switch (expr.functionType) {
            case POSITION: {
                return position > 0;
            }
            case LAST: {
                return position == size;
            }
            case NOT: {
                if (expr.args != null && expr.args.length > 0) {
                    return !this.evaluateExpr(expr.args[0], tag, attr, cursor, position, size);
                }
                return false;
            }
            case CONTAINS: 
            case STARTS_WITH: 
            case ENDS_WITH: {
                Object boolResult = this.resolveFunctionValue(expr, tag, attr, cursor, position, size);
                return Boolean.TRUE.equals(boolResult);
            }
            case STRING_LENGTH: {
                Object lenResult = this.resolveFunctionValue(expr, tag, attr, cursor, position, size);
                return lenResult instanceof Number && ((Number)lenResult).intValue() > 0;
            }
            case COUNT: {
                Object countResult = this.resolveFunctionValue(expr, tag, attr, cursor, position, size);
                return countResult instanceof Number && ((Number)countResult).intValue() > 0;
            }
            case TEXT: {
                return tag != null && tag.getValue().isPresent() && !tag.getValue().get().trim().isEmpty();
            }
            case LOCAL_NAME: 
            case NAMESPACE_URI: {
                return true;
            }
        }
        return false;
    }

    private @Nullable Object resolveFunctionValue(XPathCompiler.CompiledExpr expr,  @Nullable Xml.Tag tag,  @Nullable Xml.Attribute attr, Cursor cursor, int position, int size) {
        if (expr.functionType == null) {
            return null;
        }
        switch (expr.functionType) {
            case POSITION: {
                return position;
            }
            case LAST: {
                return size;
            }
            case LOCAL_NAME: {
                Xml.Tag targetTag = tag;
                if (expr.args != null && expr.args.length > 0) {
                    XPathCompiler.CompiledExpr argExpr = expr.args[0];
                    if (argExpr.type == XPathCompiler.ExprType.PARENT) {
                        targetTag = this.getParentTag(cursor);
                    }
                }
                if (targetTag != null) {
                    return XPathMatcher.localName(targetTag.getName());
                }
                if (attr != null && (expr.args == null || expr.args.length == 0)) {
                    return XPathMatcher.localName(attr.getKeyAsString());
                }
                return null;
            }
            case NAMESPACE_URI: {
                Xml.Tag targetTag = tag;
                Cursor targetCursor = cursor;
                if (expr.args != null && expr.args.length > 0) {
                    XPathCompiler.CompiledExpr argExpr = expr.args[0];
                    if (argExpr.type == XPathCompiler.ExprType.PARENT) {
                        Cursor parentCursor = this.getParentTagCursor(cursor);
                        if (parentCursor != null && parentCursor.getValue() instanceof Xml.Tag) {
                            targetTag = (Xml.Tag)parentCursor.getValue();
                            targetCursor = parentCursor;
                        } else {
                            return null;
                        }
                    }
                }
                if (targetTag != null) {
                    return this.resolveNamespaceUri(targetTag, targetCursor);
                }
                if (attr != null && (expr.args == null || expr.args.length == 0)) {
                    return this.resolveAttributeNamespaceUri(attr, cursor);
                }
                return null;
            }
            case TEXT: {
                return tag != null ? tag.getValue().orElse("") : null;
            }
            case STRING_LENGTH: {
                if (expr.args != null && expr.args.length > 0) {
                    Object val = this.resolveValue(expr.args[0], tag, attr, cursor, position, size);
                    String str = val != null ? val.toString() : null;
                    return str != null ? str.length() : 0;
                }
                return 0;
            }
            case SUBSTRING_BEFORE: {
                if (expr.args != null && expr.args.length >= 2) {
                    Object val0 = this.resolveValue(expr.args[0], tag, attr, cursor, position, size);
                    Object val1 = this.resolveValue(expr.args[1], tag, attr, cursor, position, size);
                    String str = val0 != null ? val0.toString() : null;
                    String delim = val1 != null ? val1.toString() : null;
                    String result = XPathMatcher.substringBefore(str, delim);
                    return result != null ? result : "";
                }
                return "";
            }
            case SUBSTRING_AFTER: {
                if (expr.args != null && expr.args.length >= 2) {
                    Object val0 = this.resolveValue(expr.args[0], tag, attr, cursor, position, size);
                    Object val1 = this.resolveValue(expr.args[1], tag, attr, cursor, position, size);
                    String str = val0 != null ? val0.toString() : null;
                    String delim = val1 != null ? val1.toString() : null;
                    String result = XPathMatcher.substringAfter(str, delim);
                    return result != null ? result : "";
                }
                return "";
            }
            case COUNT: {
                if (expr.args != null && expr.args.length > 0) {
                    Xml.Tag root;
                    XPathCompiler.CompiledExpr pathArg = expr.args[0];
                    if (pathArg.type == XPathCompiler.ExprType.ABSOLUTE_PATH && pathArg.stringValue != null && (root = this.getRootTag(cursor)) != null) {
                        Set<Xml.Tag> matches = this.findTagsByPath(root, pathArg.stringValue);
                        return matches.size();
                    }
                }
                return 0;
            }
            case CONTAINS: {
                if (expr.args != null && expr.args.length >= 2) {
                    Object val0 = this.resolveValue(expr.args[0], tag, attr, cursor, position, size);
                    Object val1 = this.resolveValue(expr.args[1], tag, attr, cursor, position, size);
                    String str = val0 != null ? val0.toString() : null;
                    String substr = val1 != null ? val1.toString() : null;
                    return str != null && substr != null && str.contains(substr);
                }
                return false;
            }
            case STARTS_WITH: {
                if (expr.args != null && expr.args.length >= 2) {
                    Object val0 = this.resolveValue(expr.args[0], tag, attr, cursor, position, size);
                    Object val1 = this.resolveValue(expr.args[1], tag, attr, cursor, position, size);
                    String str = val0 != null ? val0.toString() : null;
                    String prefix = val1 != null ? val1.toString() : null;
                    return str != null && prefix != null && str.startsWith(prefix);
                }
                return false;
            }
            case ENDS_WITH: {
                if (expr.args != null && expr.args.length >= 2) {
                    Object val0 = this.resolveValue(expr.args[0], tag, attr, cursor, position, size);
                    Object val1 = this.resolveValue(expr.args[1], tag, attr, cursor, position, size);
                    String str = val0 != null ? val0.toString() : null;
                    String suffix = val1 != null ? val1.toString() : null;
                    return str != null && suffix != null && str.endsWith(suffix);
                }
                return false;
            }
        }
        return null;
    }

    private boolean pathExists(Xml.Tag tag, XPathCompiler.CompiledExpr pathExpr) {
        if (pathExpr.args == null || pathExpr.args.length == 0) {
            return true;
        }
        Xml.Tag current = tag;
        for (XPathCompiler.CompiledExpr step : pathExpr.args) {
            if (step.type != XPathCompiler.ExprType.CHILD) {
                return false;
            }
            String childName = step.name;
            Xml.Tag child = this.findChildTag(current, childName);
            if (child == null) {
                return false;
            }
            current = child;
        }
        return true;
    }

    private  @Nullable Xml.Tag findChildTag(Xml.Tag parent, @Nullable String name) {
        List<? extends Content> contents = parent.getContent();
        if (contents == null) {
            return null;
        }
        for (Content content : contents) {
            if (!(content instanceof Xml.Tag)) continue;
            Xml.Tag child = (Xml.Tag)content;
            if (name != null && !"*".equals(name) && !child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private @Nullable String resolvePathValue(XPathCompiler.CompiledExpr expr, Xml.Tag tag) {
        if (expr.args == null || expr.args.length == 0) {
            if (expr.functionType == XPathCompiler.FunctionType.TEXT) {
                return tag.getValue().orElse("");
            }
            return null;
        }
        Xml.Tag current = tag;
        for (int i = 0; i < expr.args.length; ++i) {
            XPathCompiler.CompiledExpr step = expr.args[i];
            if (step.type != XPathCompiler.ExprType.CHILD) {
                return null;
            }
            Xml.Tag child = this.findChildTag(current, step.name);
            if (child == null) {
                return null;
            }
            current = child;
        }
        if (expr.functionType == XPathCompiler.FunctionType.TEXT) {
            return current.getValue().orElse("");
        }
        return current.getValue().orElse("");
    }

    static boolean compareValues(Object left, Object right, @Nullable XPathCompiler.ComparisonOp op) {
        if (op == null) {
            return left.equals(right);
        }
        if (left instanceof Number && right instanceof Number) {
            double leftNum = ((Number)left).doubleValue();
            double rightNum = ((Number)right).doubleValue();
            switch (op) {
                case EQ: {
                    return leftNum == rightNum;
                }
                case NE: {
                    return leftNum != rightNum;
                }
                case LT: {
                    return leftNum < rightNum;
                }
                case LE: {
                    return leftNum <= rightNum;
                }
                case GT: {
                    return leftNum > rightNum;
                }
                case GE: {
                    return leftNum >= rightNum;
                }
            }
            return false;
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            switch (op) {
                case EQ: {
                    return left.equals(right);
                }
                case NE: {
                    return !left.equals(right);
                }
            }
            return false;
        }
        String leftStr = left.toString();
        String rightStr = right.toString();
        switch (op) {
            case EQ: {
                return leftStr.equals(rightStr);
            }
            case NE: {
                return !leftStr.equals(rightStr);
            }
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                try {
                    double leftNum = Double.parseDouble(leftStr);
                    double rightNum = Double.parseDouble(rightStr);
                    switch (op) {
                        case LT: {
                            return leftNum < rightNum;
                        }
                        case LE: {
                            return leftNum <= rightNum;
                        }
                        case GT: {
                            return leftNum > rightNum;
                        }
                        case GE: {
                            return leftNum >= rightNum;
                        }
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    int cmp = leftStr.compareTo(rightStr);
                    switch (op) {
                        case LT: {
                            return cmp < 0;
                        }
                        case LE: {
                            return cmp <= 0;
                        }
                        case GT: {
                            return cmp > 0;
                        }
                        case GE: {
                            return cmp >= 0;
                        }
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static @Nullable String substringBefore(@Nullable String str, @Nullable String delim) {
        if (str == null || delim == null) {
            return null;
        }
        int idx = str.indexOf(delim);
        return idx >= 0 ? str.substring(0, idx) : "";
    }

    private static @Nullable String substringAfter(@Nullable String str, @Nullable String delim) {
        if (str == null || delim == null) {
            return null;
        }
        int idx = str.indexOf(delim);
        return idx >= 0 ? str.substring(idx + delim.length()) : "";
    }

    private static String localName(String name) {
        int colonIdx = name.indexOf(58);
        return colonIdx >= 0 ? name.substring(colonIdx + 1) : name;
    }

    private boolean hasChildElement(Xml.Tag tag, @Nullable String name) {
        return this.findChildTag(tag, name) != null;
    }

    private @Nullable String getChildElementValue(Xml.Tag tag, @Nullable String name) {
        Xml.Tag child = this.findChildTag(tag, name);
        return child != null ? child.getValue().orElse("") : null;
    }

    private boolean hasAttribute(Xml.Tag tag, @Nullable String name) {
        List<Xml.Attribute> attrs = tag.getAttributes();
        for (Xml.Attribute attr : attrs) {
            if (name != null && !"*".equals(name) && !attr.getKeyAsString().equals(name)) continue;
            return true;
        }
        return false;
    }

    private @Nullable String getAttributeValue(Xml.Tag tag, @Nullable String name) {
        List<Xml.Attribute> attrs = tag.getAttributes();
        for (Xml.Attribute attr : attrs) {
            if (name != null && !"*".equals(name) && !attr.getKeyAsString().equals(name)) continue;
            return attr.getValueAsString();
        }
        return null;
    }

    private @Nullable String resolveNamespaceUri(Xml.Tag tag, Cursor cursor) {
        String tagName = tag.getName();
        String prefix = "";
        int colonIdx = tagName.indexOf(58);
        if (colonIdx >= 0) {
            prefix = tagName.substring(0, colonIdx);
        }
        return this.findNamespaceUri(prefix, cursor);
    }

    private @Nullable String resolveAttributeNamespaceUri(Xml.Attribute attr, Cursor cursor) {
        String attrName = attr.getKeyAsString();
        int colonIdx = attrName.indexOf(58);
        if (colonIdx >= 0) {
            String prefix = attrName.substring(0, colonIdx);
            return this.findNamespaceUri(prefix, cursor);
        }
        return "";
    }

    private @Nullable String findNamespaceUri(String prefix, Cursor cursor) {
        String nsAttr = prefix.isEmpty() ? "xmlns" : "xmlns:" + prefix;
        for (Cursor c = cursor; c != null; c = c.getParent()) {
            if (!(c.getValue() instanceof Xml.Tag)) continue;
            Xml.Tag t = (Xml.Tag)c.getValue();
            for (Xml.Attribute attr : t.getAttributes()) {
                if (!attr.getKeyAsString().equals(nsAttr)) continue;
                return attr.getValueAsString();
            }
        }
        return prefix.isEmpty() ? "" : null;
    }

    private boolean matchTopDown(Cursor cursor) {
        switch (this.compiled.exprType) {
            case 1: {
                return this.matchBooleanExpr(cursor);
            }
            case 2: {
                return this.matchFilterExpr(cursor);
            }
        }
        return false;
    }

    private boolean matchBooleanExpr(Cursor cursor) {
        Cursor parentCursor;
        if (this.compiled.booleanExpr == null) {
            return false;
        }
        if (!(cursor.getValue() instanceof Xml.Tag)) {
            return false;
        }
        Xml.Tag currentTag = (Xml.Tag)cursor.getValue();
        if (this.compiled.booleanExpr.hasRelativePath() || !this.compiled.booleanExpr.hasPureAbsolutePath()) {
            return this.evaluateExpr(this.compiled.booleanExpr, currentTag, null, cursor, 1, 1);
        }
        for (parentCursor = cursor.getParent(); parentCursor != null && !(parentCursor.getValue() instanceof Xml.Tag) && !(parentCursor.getValue() instanceof Xml.Document); parentCursor = parentCursor.getParent()) {
        }
        if (parentCursor == null || !(parentCursor.getValue() instanceof Xml.Document)) {
            return false;
        }
        return this.evaluateExpr(this.compiled.booleanExpr, currentTag, null, cursor, 1, 1);
    }

    private boolean matchFilterExpr(Cursor cursor) {
        if (this.compiled.filterExpr == null) {
            return false;
        }
        Xml.Tag root = this.getRootTag(cursor);
        if (root == null) {
            return false;
        }
        Set<Xml.Tag> allMatches = this.findTagsByPath(root, this.compiled.filterExpr.pathExpr);
        if (allMatches.isEmpty()) {
            return false;
        }
        ArrayList<Xml.Tag> matchList = new ArrayList<Xml.Tag>(allMatches);
        int size = matchList.size();
        ArrayList<Xml.Tag> filteredMatches = new ArrayList<Xml.Tag>();
        for (int i = 0; i < matchList.size(); ++i) {
            Xml.Tag tag = (Xml.Tag)matchList.get(i);
            int position = i + 1;
            boolean allPredicatesMatch = true;
            for (XPathCompiler.CompiledExpr predicate : this.compiled.filterExpr.predicates) {
                if (this.evaluateFilterPredicate(predicate, tag, position, size)) continue;
                allPredicatesMatch = false;
                break;
            }
            if (!allPredicatesMatch) continue;
            filteredMatches.add(tag);
        }
        if (filteredMatches.isEmpty()) {
            return false;
        }
        Xml.Tag currentTag = null;
        if (cursor.getValue() instanceof Xml.Tag) {
            currentTag = (Xml.Tag)cursor.getValue();
        }
        if (currentTag == null) {
            return false;
        }
        if (this.compiled.filterExpr.trailingPath != null) {
            LinkedHashSet<Xml.Tag> trailingMatches = new LinkedHashSet<Xml.Tag>();
            for (Xml.Tag filteredTag : filteredMatches) {
                if (this.compiled.filterExpr.trailingIsDescendant) {
                    trailingMatches.addAll(this.findDescendants(filteredTag, this.compiled.filterExpr.trailingPath));
                    continue;
                }
                trailingMatches.addAll(this.findChildrenByPath(filteredTag, this.compiled.filterExpr.trailingPath));
            }
            return trailingMatches.contains(currentTag);
        }
        return filteredMatches.contains(currentTag);
    }

    private boolean evaluateFilterPredicate(XPathCompiler.CompiledExpr expr, Xml.Tag tag, int position, int size) {
        switch (expr.type) {
            case NUMERIC: {
                return position == expr.numericValue;
            }
            case FUNCTION: {
                if (expr.functionType == XPathCompiler.FunctionType.LAST) {
                    return position == size;
                }
                if (expr.functionType == XPathCompiler.FunctionType.POSITION) {
                    return position > 0;
                }
                return false;
            }
            case COMPARISON: {
                Object leftValue = this.resolveFilterValue(expr.left, tag, position, size);
                Object rightValue = this.resolveFilterValue(expr.right, tag, position, size);
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                return XPathMatcher.compareValues(leftValue, rightValue, expr.op);
            }
        }
        return true;
    }

    private @Nullable Object resolveFilterValue(XPathCompiler.CompiledExpr expr, Xml.Tag tag, int position, int size) {
        if (expr == null) {
            return null;
        }
        switch (expr.type) {
            case STRING: {
                return expr.stringValue;
            }
            case NUMERIC: {
                return expr.numericValue;
            }
            case FUNCTION: {
                if (expr.functionType == XPathCompiler.FunctionType.POSITION) {
                    return position;
                }
                if (expr.functionType == XPathCompiler.FunctionType.LAST) {
                    return size;
                }
                if (expr.functionType == XPathCompiler.FunctionType.LOCAL_NAME) {
                    return XPathMatcher.localName(tag.getName());
                }
                return null;
            }
        }
        return null;
    }

    private  @Nullable Xml.Tag getRootTag(Cursor cursor) {
        Cursor c = cursor;
        while (c.getParent() != null && !(c.getParent().getValue() instanceof Xml.Document)) {
            c = c.getParent();
        }
        return c.getValue() instanceof Xml.Tag ? (Xml.Tag)c.getValue() : null;
    }

    private Set<Xml.Tag> findTagsByPath(Xml.Tag startTag, String pathExpr) {
        Set<Object> currentMatches;
        block11: {
            String[] steps;
            block10: {
                if (pathExpr.startsWith("//")) {
                    String elementName = pathExpr.substring(2);
                    if (elementName.contains("/")) {
                        elementName = elementName.substring(0, elementName.indexOf(47));
                    }
                    return this.findDescendants(startTag, elementName);
                }
                boolean isAbsolute = pathExpr.startsWith("/");
                if (isAbsolute) {
                    pathExpr = pathExpr.substring(1);
                }
                if ((steps = pathExpr.split("/")).length == 0) {
                    return Collections.emptySet();
                }
                currentMatches = new LinkedHashSet();
                if (!isAbsolute) break block10;
                String firstStep = steps[0];
                if (!"*".equals(firstStep) && !startTag.getName().equals(firstStep)) break block11;
                if (steps.length == 1) {
                    currentMatches.add(startTag);
                } else {
                    currentMatches = this.findDirectChildren(startTag, steps[1]);
                    for (int i = 2; i < steps.length; ++i) {
                        LinkedHashSet<Xml.Tag> nextMatches = new LinkedHashSet<Xml.Tag>();
                        for (Xml.Tag tag : currentMatches) {
                            nextMatches.addAll(this.findDirectChildren(tag, steps[i]));
                        }
                        currentMatches = nextMatches;
                    }
                }
                break block11;
            }
            currentMatches = this.findDirectChildren(startTag, steps[0]);
            for (int i = 1; i < steps.length; ++i) {
                LinkedHashSet<Xml.Tag> nextMatches = new LinkedHashSet<Xml.Tag>();
                for (Xml.Tag tag : currentMatches) {
                    nextMatches.addAll(this.findDirectChildren(tag, steps[i]));
                }
                currentMatches = nextMatches;
            }
        }
        return currentMatches;
    }

    private Set<Xml.Tag> findDescendants(Xml.Tag tag, String elementName) {
        LinkedHashSet<Xml.Tag> result = new LinkedHashSet<Xml.Tag>();
        this.findDescendantsRecursive(tag, elementName, result);
        return result;
    }

    private void findDescendantsRecursive(Xml.Tag tag, String elementName, Set<Xml.Tag> result) {
        List<? extends Content> contents;
        if ("*".equals(elementName) || tag.getName().equals(elementName)) {
            result.add(tag);
        }
        if ((contents = tag.getContent()) != null) {
            for (Content content : contents) {
                if (!(content instanceof Xml.Tag)) continue;
                this.findDescendantsRecursive((Xml.Tag)content, elementName, result);
            }
        }
    }

    private Set<Xml.Tag> findDirectChildren(Xml.Tag parent, String elementName) {
        LinkedHashSet<Xml.Tag> result = new LinkedHashSet<Xml.Tag>();
        List<? extends Content> contents = parent.getContent();
        if (contents == null) {
            return result;
        }
        for (Content content : contents) {
            if (!(content instanceof Xml.Tag)) continue;
            Xml.Tag child = (Xml.Tag)content;
            if (!"*".equals(elementName) && !child.getName().equals(elementName)) continue;
            result.add(child);
        }
        return result;
    }

    private Set<Xml.Tag> findChildrenByPath(Xml.Tag parent, String path) {
        String[] steps = path.split("/");
        Set<Xml.Tag> currentMatches = this.findDirectChildren(parent, steps[0]);
        for (int i = 1; i < steps.length; ++i) {
            LinkedHashSet<Xml.Tag> nextMatches = new LinkedHashSet<Xml.Tag>();
            for (Xml.Tag match : currentMatches) {
                nextMatches.addAll(this.findDirectChildren(match, steps[i]));
            }
            currentMatches = nextMatches;
        }
        return currentMatches;
    }

    private static boolean matchesElementName(@Nullable String pattern, String actualName) {
        return pattern == null || "*".equals(pattern) || "node".equals(pattern) || actualName.equals(pattern);
    }

    private static boolean matchesName(@Nullable String pattern, String actualName) {
        return pattern == null || "*".equals(pattern) || actualName.equals(pattern);
    }
}

