/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.internal.YamlPrinter;
import org.openrewrite.yaml.tree.YamlKey;

public interface Yaml
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptYaml((YamlVisitor)v.adapt(YamlVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(YamlVisitor.class);
    }

    @Nullable
    default public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
        return (Yaml)v.defaultValue(this, p);
    }

    public Yaml copyPaste();

    public String getPrefix();

    public Yaml withPrefix(String var1);

    public static interface Block
    extends Yaml {
        @Override
        public Block copyPaste();

        @Override
        public Block withPrefix(String var1);
    }

    public static final class Anchor
    implements Yaml {
        private final UUID id;
        private final String prefix;
        private final String postfix;
        private final Markers markers;
        private final String key;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitAnchor(this, p);
        }

        @Override
        public Anchor copyPaste() {
            return new Anchor(Tree.randomId(), this.prefix, this.postfix, Markers.EMPTY, this.key);
        }

        public String toString() {
            return "Yaml.Anchor(" + this.key + ")";
        }

        public Anchor(UUID id, String prefix, String postfix, Markers markers, String key) {
            this.id = id;
            this.prefix = prefix;
            this.postfix = postfix;
            this.markers = markers;
            this.key = key;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Anchor)) {
                return false;
            }
            Anchor other = (Anchor)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Anchor withId(UUID id) {
            return this.id == id ? this : new Anchor(id, this.prefix, this.postfix, this.markers, this.key);
        }

        @Override
        @NonNull
        public Anchor withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Anchor(this.id, prefix, this.postfix, this.markers, this.key);
        }

        @NonNull
        public Anchor withPostfix(String postfix) {
            return this.postfix == postfix ? this : new Anchor(this.id, this.prefix, postfix, this.markers, this.key);
        }

        @NonNull
        public Anchor withMarkers(Markers markers) {
            return this.markers == markers ? this : new Anchor(this.id, this.prefix, this.postfix, markers, this.key);
        }

        @NonNull
        public Anchor withKey(String key) {
            return this.key == key ? this : new Anchor(this.id, this.prefix, this.postfix, this.markers, key);
        }
    }

    public static final class Alias
    implements Block,
    YamlKey {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Anchor anchor;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitAlias(this, p);
        }

        @Override
        public String getValue() {
            return this.anchor.key;
        }

        @Override
        public Alias copyPaste() {
            return new Alias(Tree.randomId(), this.prefix, Markers.EMPTY, this.anchor);
        }

        public String toString() {
            return "Yaml.Alias(" + this.anchor + ")";
        }

        public Alias(UUID id, String prefix, Markers markers, Anchor anchor) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.anchor = anchor;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Anchor getAnchor() {
            return this.anchor;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alias)) {
                return false;
            }
            Alias other = (Alias)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Alias withId(UUID id) {
            return this.id == id ? this : new Alias(id, this.prefix, this.markers, this.anchor);
        }

        @Override
        @NonNull
        public Alias withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Alias(this.id, prefix, this.markers, this.anchor);
        }

        @NonNull
        public Alias withMarkers(Markers markers) {
            return this.markers == markers ? this : new Alias(this.id, this.prefix, markers, this.anchor);
        }

        @NonNull
        public Alias withAnchor(Anchor anchor) {
            return this.anchor == anchor ? this : new Alias(this.id, this.prefix, this.markers, anchor);
        }
    }

    public static class Sequence
    implements Block {
        private final UUID id;
        private final Markers markers;
        @Nullable
        private final String openingBracketPrefix;
        private final List<Entry> entries;
        @Nullable
        private final String closingBracketPrefix;
        @Nullable
        private final Anchor anchor;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitSequence(this, p);
        }

        @Override
        public Sequence copyPaste() {
            return new Sequence(Tree.randomId(), Markers.EMPTY, this.openingBracketPrefix, this.entries.stream().map(Entry::copyPaste).collect(Collectors.toList()), this.closingBracketPrefix, this.anchor);
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public Sequence withPrefix(String prefix) {
            if (!prefix.isEmpty()) {
                throw new UnsupportedOperationException("Yaml.Sequence may not have a non-empty prefix");
            }
            return this;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sequence)) {
                return false;
            }
            Sequence other = (Sequence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Sequence;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Sequence(UUID id, Markers markers, @Nullable String openingBracketPrefix, List<Entry> entries, @Nullable String closingBracketPrefix, @Nullable Anchor anchor) {
            this.id = id;
            this.markers = markers;
            this.openingBracketPrefix = openingBracketPrefix;
            this.entries = entries;
            this.closingBracketPrefix = closingBracketPrefix;
            this.anchor = anchor;
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public String getOpeningBracketPrefix() {
            return this.openingBracketPrefix;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        @Nullable
        public String getClosingBracketPrefix() {
            return this.closingBracketPrefix;
        }

        @Nullable
        public Anchor getAnchor() {
            return this.anchor;
        }

        @NonNull
        public String toString() {
            return "Yaml.Sequence(id=" + this.getId() + ", markers=" + this.getMarkers() + ", openingBracketPrefix=" + this.getOpeningBracketPrefix() + ", entries=" + this.getEntries() + ", closingBracketPrefix=" + this.getClosingBracketPrefix() + ", anchor=" + this.getAnchor() + ")";
        }

        @NonNull
        public Sequence withId(UUID id) {
            return this.id == id ? this : new Sequence(id, this.markers, this.openingBracketPrefix, this.entries, this.closingBracketPrefix, this.anchor);
        }

        @NonNull
        public Sequence withMarkers(Markers markers) {
            return this.markers == markers ? this : new Sequence(this.id, markers, this.openingBracketPrefix, this.entries, this.closingBracketPrefix, this.anchor);
        }

        @NonNull
        public Sequence withOpeningBracketPrefix(@Nullable String openingBracketPrefix) {
            return this.openingBracketPrefix == openingBracketPrefix ? this : new Sequence(this.id, this.markers, openingBracketPrefix, this.entries, this.closingBracketPrefix, this.anchor);
        }

        @NonNull
        public Sequence withEntries(List<Entry> entries) {
            return this.entries == entries ? this : new Sequence(this.id, this.markers, this.openingBracketPrefix, entries, this.closingBracketPrefix, this.anchor);
        }

        @NonNull
        public Sequence withClosingBracketPrefix(@Nullable String closingBracketPrefix) {
            return this.closingBracketPrefix == closingBracketPrefix ? this : new Sequence(this.id, this.markers, this.openingBracketPrefix, this.entries, closingBracketPrefix, this.anchor);
        }

        @NonNull
        public Sequence withAnchor(@Nullable Anchor anchor) {
            return this.anchor == anchor ? this : new Sequence(this.id, this.markers, this.openingBracketPrefix, this.entries, this.closingBracketPrefix, anchor);
        }

        public static final class Entry
        implements Yaml {
            private final UUID id;
            private final String prefix;
            private final Markers markers;
            private final Block block;
            private final boolean dash;
            @Nullable
            private final String trailingCommaPrefix;

            @Override
            public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
                return v.visitSequenceEntry(this, p);
            }

            @Override
            public Entry copyPaste() {
                return new Entry(Tree.randomId(), this.prefix, Markers.EMPTY, this.block.copyPaste(), this.dash, this.trailingCommaPrefix);
            }

            public Entry(UUID id, String prefix, Markers markers, Block block, boolean dash, @Nullable String trailingCommaPrefix) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.block = block;
                this.dash = dash;
                this.trailingCommaPrefix = trailingCommaPrefix;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public Block getBlock() {
                return this.block;
            }

            public boolean isDash() {
                return this.dash;
            }

            @Nullable
            public String getTrailingCommaPrefix() {
                return this.trailingCommaPrefix;
            }

            @NonNull
            public String toString() {
                return "Yaml.Sequence.Entry(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", block=" + this.getBlock() + ", dash=" + this.isDash() + ", trailingCommaPrefix=" + this.getTrailingCommaPrefix() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            public Entry withId(UUID id) {
                return this.id == id ? this : new Entry(id, this.prefix, this.markers, this.block, this.dash, this.trailingCommaPrefix);
            }

            @NonNull
            public Entry withDash(boolean dash) {
                return this.dash == dash ? this : new Entry(this.id, this.prefix, this.markers, this.block, dash, this.trailingCommaPrefix);
            }

            @Override
            @NonNull
            public Entry withPrefix(String prefix) {
                return this.prefix == prefix ? this : new Entry(this.id, prefix, this.markers, this.block, this.dash, this.trailingCommaPrefix);
            }

            @NonNull
            public Entry withMarkers(Markers markers) {
                return this.markers == markers ? this : new Entry(this.id, this.prefix, markers, this.block, this.dash, this.trailingCommaPrefix);
            }

            @NonNull
            public Entry withBlock(Block block) {
                return this.block == block ? this : new Entry(this.id, this.prefix, this.markers, block, this.dash, this.trailingCommaPrefix);
            }

            @NonNull
            public Entry withTrailingCommaPrefix(@Nullable String trailingCommaPrefix) {
                return this.trailingCommaPrefix == trailingCommaPrefix ? this : new Entry(this.id, this.prefix, this.markers, this.block, this.dash, trailingCommaPrefix);
            }
        }
    }

    public static class Mapping
    implements Block {
        private final UUID id;
        private final Markers markers;
        @Nullable
        private final String openingBracePrefix;
        private final List<Entry> entries;
        @Nullable
        private final String closingBracePrefix;
        @Nullable
        private final Anchor anchor;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitMapping(this, p);
        }

        @Override
        public Mapping copyPaste() {
            return new Mapping(Tree.randomId(), Markers.EMPTY, this.openingBracePrefix, this.entries.stream().map(Entry::copyPaste).collect(Collectors.toList()), this.closingBracePrefix, this.anchor);
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public Mapping withPrefix(String prefix) {
            if (!prefix.isEmpty()) {
                throw new UnsupportedOperationException("Yaml.Mapping may not have a non-empty prefix");
            }
            return this;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Mapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Mapping(UUID id, Markers markers, @Nullable String openingBracePrefix, List<Entry> entries, @Nullable String closingBracePrefix, @Nullable Anchor anchor) {
            this.id = id;
            this.markers = markers;
            this.openingBracePrefix = openingBracePrefix;
            this.entries = entries;
            this.closingBracePrefix = closingBracePrefix;
            this.anchor = anchor;
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public String getOpeningBracePrefix() {
            return this.openingBracePrefix;
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        @Nullable
        public String getClosingBracePrefix() {
            return this.closingBracePrefix;
        }

        @Nullable
        public Anchor getAnchor() {
            return this.anchor;
        }

        @NonNull
        public String toString() {
            return "Yaml.Mapping(id=" + this.getId() + ", markers=" + this.getMarkers() + ", openingBracePrefix=" + this.getOpeningBracePrefix() + ", entries=" + this.getEntries() + ", closingBracePrefix=" + this.getClosingBracePrefix() + ", anchor=" + this.getAnchor() + ")";
        }

        @NonNull
        public Mapping withId(UUID id) {
            return this.id == id ? this : new Mapping(id, this.markers, this.openingBracePrefix, this.entries, this.closingBracePrefix, this.anchor);
        }

        @NonNull
        public Mapping withMarkers(Markers markers) {
            return this.markers == markers ? this : new Mapping(this.id, markers, this.openingBracePrefix, this.entries, this.closingBracePrefix, this.anchor);
        }

        @NonNull
        public Mapping withOpeningBracePrefix(@Nullable String openingBracePrefix) {
            return this.openingBracePrefix == openingBracePrefix ? this : new Mapping(this.id, this.markers, openingBracePrefix, this.entries, this.closingBracePrefix, this.anchor);
        }

        @NonNull
        public Mapping withEntries(List<Entry> entries) {
            return this.entries == entries ? this : new Mapping(this.id, this.markers, this.openingBracePrefix, entries, this.closingBracePrefix, this.anchor);
        }

        @NonNull
        public Mapping withClosingBracePrefix(@Nullable String closingBracePrefix) {
            return this.closingBracePrefix == closingBracePrefix ? this : new Mapping(this.id, this.markers, this.openingBracePrefix, this.entries, closingBracePrefix, this.anchor);
        }

        @NonNull
        public Mapping withAnchor(@Nullable Anchor anchor) {
            return this.anchor == anchor ? this : new Mapping(this.id, this.markers, this.openingBracePrefix, this.entries, this.closingBracePrefix, anchor);
        }

        public static final class Entry
        implements Yaml {
            private final UUID id;
            private final String prefix;
            private final Markers markers;
            private final YamlKey key;
            private final String beforeMappingValueIndicator;
            private final Block value;

            @Override
            public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
                return v.visitMappingEntry(this, p);
            }

            @Override
            public Entry copyPaste() {
                return new Entry(Tree.randomId(), this.prefix, Markers.EMPTY, this.key.copyPaste(), this.beforeMappingValueIndicator, this.value.copyPaste());
            }

            public Entry(UUID id, String prefix, Markers markers, YamlKey key, String beforeMappingValueIndicator, Block value) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.key = key;
                this.beforeMappingValueIndicator = beforeMappingValueIndicator;
                this.value = value;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public YamlKey getKey() {
                return this.key;
            }

            public String getBeforeMappingValueIndicator() {
                return this.beforeMappingValueIndicator;
            }

            public Block getValue() {
                return this.value;
            }

            @NonNull
            public String toString() {
                return "Yaml.Mapping.Entry(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", key=" + this.getKey() + ", beforeMappingValueIndicator=" + this.getBeforeMappingValueIndicator() + ", value=" + this.getValue() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            public Entry withId(UUID id) {
                return this.id == id ? this : new Entry(id, this.prefix, this.markers, this.key, this.beforeMappingValueIndicator, this.value);
            }

            @Override
            @NonNull
            public Entry withPrefix(String prefix) {
                return this.prefix == prefix ? this : new Entry(this.id, prefix, this.markers, this.key, this.beforeMappingValueIndicator, this.value);
            }

            @NonNull
            public Entry withMarkers(Markers markers) {
                return this.markers == markers ? this : new Entry(this.id, this.prefix, markers, this.key, this.beforeMappingValueIndicator, this.value);
            }

            @NonNull
            public Entry withKey(YamlKey key) {
                return this.key == key ? this : new Entry(this.id, this.prefix, this.markers, key, this.beforeMappingValueIndicator, this.value);
            }

            @NonNull
            public Entry withBeforeMappingValueIndicator(String beforeMappingValueIndicator) {
                return this.beforeMappingValueIndicator == beforeMappingValueIndicator ? this : new Entry(this.id, this.prefix, this.markers, this.key, beforeMappingValueIndicator, this.value);
            }

            @NonNull
            public Entry withValue(Block value) {
                return this.value == value ? this : new Entry(this.id, this.prefix, this.markers, this.key, this.beforeMappingValueIndicator, value);
            }
        }
    }

    public static final class Scalar
    implements Block,
    YamlKey {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Style style;
        @Nullable
        private final Anchor anchor;
        private final String value;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitScalar(this, p);
        }

        @Override
        public Scalar copyPaste() {
            return new Scalar(Tree.randomId(), this.prefix, Markers.EMPTY, this.style, this.anchor, this.value);
        }

        public String toString() {
            return "Yaml.Scalar(" + this.value + ")";
        }

        public Scalar(UUID id, String prefix, Markers markers, Style style, @Nullable Anchor anchor, String value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.style = style;
            this.anchor = anchor;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Style getStyle() {
            return this.style;
        }

        @Nullable
        public Anchor getAnchor() {
            return this.anchor;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Scalar)) {
                return false;
            }
            Scalar other = (Scalar)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Scalar withId(UUID id) {
            return this.id == id ? this : new Scalar(id, this.prefix, this.markers, this.style, this.anchor, this.value);
        }

        @Override
        @NonNull
        public Scalar withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Scalar(this.id, prefix, this.markers, this.style, this.anchor, this.value);
        }

        @NonNull
        public Scalar withMarkers(Markers markers) {
            return this.markers == markers ? this : new Scalar(this.id, this.prefix, markers, this.style, this.anchor, this.value);
        }

        @NonNull
        public Scalar withStyle(Style style) {
            return this.style == style ? this : new Scalar(this.id, this.prefix, this.markers, style, this.anchor, this.value);
        }

        @NonNull
        public Scalar withAnchor(@Nullable Anchor anchor) {
            return this.anchor == anchor ? this : new Scalar(this.id, this.prefix, this.markers, this.style, anchor, this.value);
        }

        @NonNull
        public Scalar withValue(String value) {
            return this.value == value ? this : new Scalar(this.id, this.prefix, this.markers, this.style, this.anchor, value);
        }

        public static enum Style {
            DOUBLE_QUOTED,
            SINGLE_QUOTED,
            LITERAL,
            FOLDED,
            PLAIN;

        }
    }

    public static final class Document
    implements Yaml {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final boolean explicit;
        private final Block block;
        private final End end;

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitDocument(this, p);
        }

        @Override
        public Document copyPaste() {
            return new Document(Tree.randomId(), this.prefix, Markers.EMPTY, this.explicit, this.block.copyPaste(), this.end == null ? null : this.end.copyPaste());
        }

        public Document(UUID id, String prefix, Markers markers, boolean explicit, Block block, End end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.explicit = explicit;
            this.block = block;
            this.end = end;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        public Block getBlock() {
            return this.block;
        }

        public End getEnd() {
            return this.end;
        }

        @NonNull
        public String toString() {
            return "Yaml.Document(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", explicit=" + this.isExplicit() + ", block=" + this.getBlock() + ", end=" + this.getEnd() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Document withId(UUID id) {
            return this.id == id ? this : new Document(id, this.prefix, this.markers, this.explicit, this.block, this.end);
        }

        @Override
        @NonNull
        public Document withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Document(this.id, prefix, this.markers, this.explicit, this.block, this.end);
        }

        @NonNull
        public Document withMarkers(Markers markers) {
            return this.markers == markers ? this : new Document(this.id, this.prefix, markers, this.explicit, this.block, this.end);
        }

        @NonNull
        public Document withExplicit(boolean explicit) {
            return this.explicit == explicit ? this : new Document(this.id, this.prefix, this.markers, explicit, this.block, this.end);
        }

        @NonNull
        public Document withBlock(Block block) {
            return this.block == block ? this : new Document(this.id, this.prefix, this.markers, this.explicit, block, this.end);
        }

        @NonNull
        public Document withEnd(End end) {
            return this.end == end ? this : new Document(this.id, this.prefix, this.markers, this.explicit, this.block, end);
        }

        public static final class End
        implements Yaml {
            private final UUID id;
            private final String prefix;
            private final Markers markers;
            private final boolean explicit;

            @Override
            public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
                return v.visitDocumentEnd(this, p);
            }

            @Override
            public End copyPaste() {
                return new End(Tree.randomId(), this.prefix, Markers.EMPTY, this.explicit);
            }

            public End(UUID id, String prefix, Markers markers, boolean explicit) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.explicit = explicit;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public String getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public boolean isExplicit() {
                return this.explicit;
            }

            @NonNull
            public String toString() {
                return "Yaml.Document.End(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", explicit=" + this.isExplicit() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof End)) {
                    return false;
                }
                End other = (End)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            public End withId(UUID id) {
                return this.id == id ? this : new End(id, this.prefix, this.markers, this.explicit);
            }

            @Override
            @NonNull
            public End withPrefix(String prefix) {
                return this.prefix == prefix ? this : new End(this.id, prefix, this.markers, this.explicit);
            }

            @NonNull
            public End withMarkers(Markers markers) {
                return this.markers == markers ? this : new End(this.id, this.prefix, markers, this.explicit);
            }

            @NonNull
            public End withExplicit(boolean explicit) {
                return this.explicit == explicit ? this : new End(this.id, this.prefix, this.markers, explicit);
            }
        }
    }

    public static final class Documents
    implements Yaml,
    SourceFile {
        private final UUID id;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<? extends Document> documents;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> Yaml acceptYaml(YamlVisitor<P> v, P p) {
            return v.visitDocuments(this, p);
        }

        @Override
        public Documents copyPaste() {
            return new Documents(Tree.randomId(), Markers.EMPTY, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.documents.stream().map(Document::copyPaste).collect(Collectors.toList()));
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public Documents withPrefix(String prefix) {
            if (!prefix.isEmpty()) {
                throw new UnsupportedOperationException("Yaml.Documents may not have a non-empty prefix");
            }
            return this;
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new YamlPrinter();
        }

        public Documents(UUID id, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<? extends Document> documents) {
            this.id = id;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.documents = documents;
        }

        public UUID getId() {
            return this.id;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Nullable
        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        public List<? extends Document> getDocuments() {
            return this.documents;
        }

        @NonNull
        public String toString() {
            return "Yaml.Documents(id=" + this.getId() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", documents=" + this.getDocuments() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Documents)) {
                return false;
            }
            Documents other = (Documents)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Documents withId(UUID id) {
            return this.id == id ? this : new Documents(id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.documents);
        }

        @NonNull
        public Documents withMarkers(Markers markers) {
            return this.markers == markers ? this : new Documents(this.id, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.documents);
        }

        @NonNull
        public Documents withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Documents(this.id, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.documents);
        }

        @NonNull
        public Documents withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new Documents(this.id, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.documents);
        }

        @NonNull
        public Documents withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new Documents(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.documents);
        }

        @NonNull
        public Documents withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new Documents(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.documents);
        }

        @NonNull
        public Documents withDocuments(List<? extends Document> documents) {
            return this.documents == documents ? this : new Documents(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, documents);
        }

        @NonNull
        private Documents withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new Documents(this.id, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.documents);
        }
    }
}

