/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangePropertyValue
extends Recipe {
    @Option(displayName="Property key", description="The key to look for. Supports glob patterns.", example="management.metrics.binders.*.enabled")
    private final String propertyKey;
    @Option(example="newValue", displayName="New value", description="The new value to be used for key specified by `propertyKey`.")
    private final String newValue;
    @Option(example="oldValue", displayName="Old value", required=false, description="Only change the property value if it matches the configured `oldValue`.")
    private final @Nullable String oldValue;
    @Option(displayName="Regex", description="Default `false`. If enabled, `oldValue` will be interpreted as a Regular Expression, to replace only all parts that match the regex. Capturing group can be used in `newValue`.", required=false)
    private final @Nullable Boolean regex;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    private final @Nullable Boolean relaxedBinding;
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root). Blank/null matches all.", required=false, example=".github/workflows/*.yml")
    private final @Nullable String filePattern;

    public String getDisplayName() {
        return "Change YAML property";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.propertyKey, this.newValue);
    }

    public String getDescription() {
        return "Change a YAML property. Expects dot notation for nested YAML mappings, similar to how Spring Boot interprets `application.yml` files.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"oldValue", (String)"is required if `regex` is enabled", (Object)this.oldValue, value -> !Boolean.TRUE.equals(this.regex) || !StringUtils.isNullOrEmpty((String)value)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(this.filePattern), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Block updatedValue;
                Yaml e = super.visitMappingEntry(entry, ctx);
                String prop = ChangePropertyValue.getProperty(this.getCursor());
                if (ChangePropertyValue.this.matchesPropertyKey(prop) && ChangePropertyValue.this.matchesOldValue(((Yaml.Mapping.Entry)e).getValue()) && (updatedValue = ChangePropertyValue.this.updateValue(((Yaml.Mapping.Entry)e).getValue())) != null) {
                    e = ((Yaml.Mapping.Entry)e).withValue(updatedValue);
                }
                return e;
            }
        });
    }

    private @Nullable Yaml.Block updateValue(Yaml.Block value) {
        if (value instanceof Yaml.Scalar) {
            Yaml.Scalar scalar = (Yaml.Scalar)value;
            Yaml.Scalar newScalar = scalar.withValue(Boolean.TRUE.equals(this.regex) ? scalar.getValue().replaceAll(Objects.requireNonNull(this.oldValue), this.newValue) : this.newValue);
            return scalar.getValue().equals(newScalar.getValue()) ? null : newScalar;
        }
        if (value instanceof Yaml.Sequence) {
            Yaml.Sequence sequence = (Yaml.Sequence)value;
            return sequence.withEntries(ListUtils.map(sequence.getEntries(), entry -> {
                Yaml.Block updatedValue;
                if (this.matchesOldValue(entry.getBlock()) && (updatedValue = this.updateValue(entry.getBlock())) != null) {
                    return entry.withBlock(updatedValue);
                }
                return entry;
            }));
        }
        return null;
    }

    private boolean matchesPropertyKey(String prop) {
        return !Boolean.FALSE.equals(this.relaxedBinding) ? NameCaseConvention.matchesGlobRelaxedBinding((String)prop, (String)this.propertyKey) : StringUtils.matchesGlob((String)prop, (String)this.propertyKey);
    }

    private boolean matchesOldValue(Yaml.Block value) {
        if (value instanceof Yaml.Scalar) {
            Yaml.Scalar scalar = (Yaml.Scalar)value;
            return StringUtils.isNullOrEmpty((String)this.oldValue) || (Boolean.TRUE.equals(this.regex) ? Pattern.compile(this.oldValue).matcher(scalar.getValue()).find() : scalar.getValue().equals(this.oldValue));
        }
        if (value instanceof Yaml.Sequence) {
            for (Yaml.Sequence.Entry entry : ((Yaml.Sequence)value).getEntries()) {
                if (!this.matchesOldValue(entry.getBlock())) continue;
                return true;
            }
        }
        return false;
    }

    private static String getProperty(Cursor cursor) {
        StringBuilder asProperty = new StringBuilder();
        Iterator path = cursor.getPath();
        int i = 0;
        while (path.hasNext()) {
            Object next = path.next();
            if (!(next instanceof Yaml.Mapping.Entry)) continue;
            Yaml.Mapping.Entry entry = (Yaml.Mapping.Entry)next;
            if (i++ > 0) {
                asProperty.insert(0, '.');
            }
            asProperty.insert(0, entry.getKey().getValue());
        }
        return asProperty.toString();
    }

    @Generated
    public ChangePropertyValue(String propertyKey, String newValue, @Nullable String oldValue, @Nullable Boolean regex, @Nullable Boolean relaxedBinding, @Nullable String filePattern) {
        this.propertyKey = propertyKey;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.regex = regex;
        this.relaxedBinding = relaxedBinding;
        this.filePattern = filePattern;
    }

    @Generated
    public String getPropertyKey() {
        return this.propertyKey;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Generated
    public @Nullable String getOldValue() {
        return this.oldValue;
    }

    @Generated
    public @Nullable Boolean getRegex() {
        return this.regex;
    }

    @Generated
    public @Nullable Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePropertyValue(propertyKey=" + this.getPropertyKey() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ", regex=" + this.getRegex() + ", relaxedBinding=" + this.getRelaxedBinding() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyValue)) {
            return false;
        }
        ChangePropertyValue other = (ChangePropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePropertyValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

