/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.jgit.lib.ObjectId;

public class AmbiguousObjectException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final AbbreviatedObjectId missing;
    private final Collection<ObjectId> candidates;

    public AmbiguousObjectException(AbbreviatedObjectId id, Collection<ObjectId> candidates) {
        super(MessageFormat.format(JGitText.get().ambiguousObjectAbbreviation, id.name()));
        this.missing = id;
        this.candidates = candidates;
    }

    public AbbreviatedObjectId getAbbreviatedObjectId() {
        return this.missing;
    }

    public Collection<ObjectId> getCandidates() {
        return this.candidates;
    }
}

