/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableEntityIDCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableEntityIDCredentialCriteria.class);
    private String entityID;

    public EvaluableEntityIDCredentialCriteria(EntityIDCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.entityID = criteria.getEntityID();
    }

    public EvaluableEntityIDCredentialCriteria(String newEntityID) {
        if (DatatypeHelper.isEmpty(newEntityID)) {
            throw new IllegalArgumentException("Entity ID may not be null");
        }
        this.entityID = newEntityID;
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (DatatypeHelper.isEmpty(target.getEntityId())) {
            this.log.info("Could not evaluate criteria, credential contained no entity ID");
            return null;
        }
        Boolean result = this.entityID.equals(target.getEntityId());
        return result;
    }
}

