/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.X509KeyManager;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.DatatypeHelper;

public class X509KeyManagerX509CredentialAdapter
extends BasicCredential
implements X509Credential {
    private String credentialAlias;
    private X509KeyManager keyManager;

    public X509KeyManagerX509CredentialAdapter(X509KeyManager manager, String alias) {
        if (manager == null) {
            throw new IllegalArgumentException("Key manager may not be null");
        }
        this.keyManager = manager;
        this.credentialAlias = DatatypeHelper.safeTrimOrNullString(alias);
        if (this.credentialAlias == null) {
            throw new IllegalArgumentException("Entity alias may not be null");
        }
    }

    @Override
    public Collection<X509CRL> getCRLs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public X509Certificate getEntityCertificate() {
        X509Certificate[] certs = this.keyManager.getCertificateChain(this.credentialAlias);
        if (certs != null && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    @Override
    public Collection<X509Certificate> getEntityCertificateChain() {
        X509Certificate[] certs = this.keyManager.getCertificateChain(this.credentialAlias);
        if (certs != null && certs.length > 0) {
            return Arrays.asList(certs);
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.keyManager.getPrivateKey(this.credentialAlias);
    }

    @Override
    public PublicKey getPublicKey() {
        return this.getEntityCertificate().getPublicKey();
    }
}

