/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.ApiClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.snapshot.CleanupRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.CleanupRepositoryResponse;
import org.opensearch.client.opensearch.snapshot.CloneSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.CloneSnapshotResponse;
import org.opensearch.client.opensearch.snapshot.CreateRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.CreateRepositoryResponse;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotResponse;
import org.opensearch.client.opensearch.snapshot.DeleteRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.DeleteRepositoryResponse;
import org.opensearch.client.opensearch.snapshot.DeleteSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.DeleteSnapshotResponse;
import org.opensearch.client.opensearch.snapshot.GetRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.GetRepositoryResponse;
import org.opensearch.client.opensearch.snapshot.GetSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.GetSnapshotResponse;
import org.opensearch.client.opensearch.snapshot.RestoreRequest;
import org.opensearch.client.opensearch.snapshot.RestoreResponse;
import org.opensearch.client.opensearch.snapshot.SnapshotStatusRequest;
import org.opensearch.client.opensearch.snapshot.SnapshotStatusResponse;
import org.opensearch.client.opensearch.snapshot.VerifyRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.VerifyRepositoryResponse;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.util.ObjectBuilder;

public class OpenSearchSnapshotAsyncClient
extends ApiClient<OpenSearchTransport, OpenSearchSnapshotAsyncClient> {
    public OpenSearchSnapshotAsyncClient(OpenSearchTransport transport) {
        super(transport, null);
    }

    public OpenSearchSnapshotAsyncClient(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public OpenSearchSnapshotAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new OpenSearchSnapshotAsyncClient((OpenSearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<CleanupRepositoryResponse> cleanupRepository(CleanupRepositoryRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)CleanupRepositoryRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CleanupRepositoryResponse> cleanupRepository(Function<CleanupRepositoryRequest.Builder, ObjectBuilder<CleanupRepositoryRequest>> fn) throws IOException, OpenSearchException {
        return this.cleanupRepository(fn.apply(new CleanupRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<CloneSnapshotResponse> clone(CloneSnapshotRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)CloneSnapshotRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CloneSnapshotResponse> clone(Function<CloneSnapshotRequest.Builder, ObjectBuilder<CloneSnapshotRequest>> fn) throws IOException, OpenSearchException {
        return this.clone(fn.apply(new CloneSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<CreateSnapshotResponse> create(CreateSnapshotRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)CreateSnapshotRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CreateSnapshotResponse> create(Function<CreateSnapshotRequest.Builder, ObjectBuilder<CreateSnapshotRequest>> fn) throws IOException, OpenSearchException {
        return this.create(fn.apply(new CreateSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)CreateRepositoryRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<CreateRepositoryResponse> createRepository(Function<CreateRepositoryRequest.Builder, ObjectBuilder<CreateRepositoryRequest>> fn) throws IOException, OpenSearchException {
        return this.createRepository(fn.apply(new CreateRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<DeleteSnapshotResponse> delete(DeleteSnapshotRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteSnapshotRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteSnapshotResponse> delete(Function<DeleteSnapshotRequest.Builder, ObjectBuilder<DeleteSnapshotRequest>> fn) throws IOException, OpenSearchException {
        return this.delete(fn.apply(new DeleteSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteRepositoryRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteRepositoryResponse> deleteRepository(Function<DeleteRepositoryRequest.Builder, ObjectBuilder<DeleteRepositoryRequest>> fn) throws IOException, OpenSearchException {
        return this.deleteRepository(fn.apply(new DeleteRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<GetSnapshotResponse> get(GetSnapshotRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetSnapshotRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetSnapshotResponse> get(Function<GetSnapshotRequest.Builder, ObjectBuilder<GetSnapshotRequest>> fn) throws IOException, OpenSearchException {
        return this.get(fn.apply(new GetSnapshotRequest.Builder()).build());
    }

    public CompletableFuture<GetRepositoryResponse> getRepository(GetRepositoryRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetRepositoryRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetRepositoryResponse> getRepository(Function<GetRepositoryRequest.Builder, ObjectBuilder<GetRepositoryRequest>> fn) throws IOException, OpenSearchException {
        return this.getRepository(fn.apply(new GetRepositoryRequest.Builder()).build());
    }

    public CompletableFuture<GetRepositoryResponse> getRepository() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new GetRepositoryRequest.Builder().build(), GetRepositoryRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<RestoreResponse> restore(RestoreRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)RestoreRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<RestoreResponse> restore(Function<RestoreRequest.Builder, ObjectBuilder<RestoreRequest>> fn) throws IOException, OpenSearchException {
        return this.restore(fn.apply(new RestoreRequest.Builder()).build());
    }

    public CompletableFuture<SnapshotStatusResponse> status(SnapshotStatusRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)SnapshotStatusRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<SnapshotStatusResponse> status(Function<SnapshotStatusRequest.Builder, ObjectBuilder<SnapshotStatusRequest>> fn) throws IOException, OpenSearchException {
        return this.status(fn.apply(new SnapshotStatusRequest.Builder()).build());
    }

    public CompletableFuture<SnapshotStatusResponse> status() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new SnapshotStatusRequest.Builder().build(), SnapshotStatusRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<VerifyRepositoryResponse> verifyRepository(VerifyRepositoryRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)VerifyRepositoryRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<VerifyRepositoryResponse> verifyRepository(Function<VerifyRepositoryRequest.Builder, ObjectBuilder<VerifyRepositoryRequest>> fn) throws IOException, OpenSearchException {
        return this.verifyRepository(fn.apply(new VerifyRepositoryRequest.Builder()).build());
    }
}

