/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.archetype;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archetype.Archetype;
import org.apache.maven.archetype.ArchetypeDescriptorException;
import org.apache.maven.archetype.ArchetypeNotFoundException;
import org.apache.maven.archetype.ArchetypeTemplateProcessingException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.ops4j.pax.construct.util.BndUtils;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.PomUtils;

public abstract class AbstractPaxArchetypeMojo
extends AbstractMojo {
    public static final String PAX_CONSTRUCT_GROUP_ID = "org.ops4j.pax.construct";
    private Archetype m_archetype;
    private ArtifactFactory m_factory;
    private ArtifactResolver m_resolver;
    private ArtifactMetadataSource m_source;
    private ArtifactRepositoryFactory m_repoFactory;
    private ArtifactRepositoryLayout m_defaultLayout;
    private ArtifactRepository m_localRepo;
    private List m_remoteRepos;
    private String remoteRepositories;
    private String pluginVersion;
    private String archetypeVersion;
    private File targetDirectory;
    private String contents;
    private boolean compactIds;
    private boolean attachPom;
    private boolean overwrite;
    private MavenProject m_project;
    private File m_pomFile;
    private FileSet m_tempFiles;
    private List m_customArchetypeIds;
    private PomUtils.Pom m_modulesPom;
    private PomUtils.Pom m_pom;
    private BndUtils.Bnd m_bnd;
    private Properties m_archetypeProperties;

    protected final ArtifactFactory getFactory() {
        return this.m_factory;
    }

    protected final ArtifactResolver getResolver() {
        return this.m_resolver;
    }

    protected final ArtifactMetadataSource getSource() {
        return this.m_source;
    }

    protected final ArtifactRepository getLocalRepo() {
        return this.m_localRepo;
    }

    protected final List getRemoteRepos() {
        return this.m_remoteRepos;
    }

    protected final boolean hasCustomContent() {
        return PomUtils.isNotEmpty(this.contents);
    }

    protected final String getInternalGroupId(String bundleGroupId) {
        if (PomUtils.isNotEmpty(bundleGroupId)) {
            return bundleGroupId;
        }
        if (null != this.m_modulesPom) {
            return this.getCompoundId(this.m_modulesPom.getGroupId(), this.m_modulesPom.getArtifactId());
        }
        return "examples";
    }

    protected final String getPluginVersion() {
        return this.pluginVersion;
    }

    protected final void addTempFiles(String pathExpression) {
        this.m_tempFiles.addInclude(pathExpression);
    }

    public final void execute() throws MojoExecutionException {
        this.updateFields();
        this.createModuleTree();
        do {
            this.scheduleCustomArchetypes();
            this.updateExtensionFields();
            this.prepareTarget();
            this.generateArchetype();
            this.cacheSettings();
            this.runCustomArchetypes();
            this.postProcess();
            this.cleanUp();
        } while (this.createMoreArtifacts());
    }

    private void updateFields() {
        this.m_archetypeProperties = new Properties();
        this.targetDirectory = DirUtils.resolveFile(this.targetDirectory, true);
        this.setArchetypeProperty("basedir", this.targetDirectory.getPath());
        if (PomUtils.isNotEmpty(this.remoteRepositories)) {
            this.getLog().info((CharSequence)("We are using command-line specified remote repositories: " + this.remoteRepositories));
            this.m_remoteRepos = new ArrayList();
            String[] s = this.remoteRepositories.split(",");
            for (int i = 0; i < s.length; ++i) {
                this.m_remoteRepos.add(this.createRemoteRepository("id" + i, s[i]));
            }
            this.m_remoteRepos.add(this.createRemoteRepository("central", "http://repo1.maven.org/maven2"));
        }
    }

    private void createModuleTree() throws MojoExecutionException {
        if (this.attachPom) {
            try {
                this.m_modulesPom = DirUtils.createModuleTree(this.m_project.getBasedir(), this.targetDirectory);
                if (null != this.m_modulesPom && !"pom".equals(this.m_modulesPom.getPackaging())) {
                    throw new MojoExecutionException("Containing project does not have packaging type 'pom'");
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to create module tree");
            }
        }
    }

    protected abstract void updateExtensionFields() throws MojoExecutionException;

    protected abstract String getParentId();

    protected void cacheOriginalFiles(File baseDir) {
    }

    protected void postProcess(PomUtils.Pom pom, BndUtils.Bnd bnd) throws MojoExecutionException {
    }

    protected boolean createMoreArtifacts() {
        return false;
    }

    private VersionRange getArchetypeVersionRange() {
        DefaultArtifactVersion version = new DefaultArtifactVersion(this.pluginVersion);
        int thisRelease = version.getMajorVersion();
        int prevRelease = thisRelease - 1;
        int nextRelease = thisRelease + 1;
        String spec = false == ArtifactUtils.isSnapshot((String)this.pluginVersion) ? "[" + thisRelease + ',' + nextRelease + ')' : "[" + prevRelease + ',' + nextRelease + ')';
        try {
            return VersionRange.createFromVersionSpec((String)spec);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
    }

    private String getArchetypeVersion(String groupId, String artifactId) {
        Artifact artifact = this.m_factory.createBuildArtifact(groupId, artifactId, this.pluginVersion, "jar");
        if (artifact.isSnapshot() && PomUtils.getFile(artifact, this.m_resolver, this.m_localRepo)) {
            return this.pluginVersion;
        }
        VersionRange range = this.getArchetypeVersionRange();
        try {
            this.getLog().info((CharSequence)("Selecting latest archetype release within version range " + range));
            return PomUtils.getReleaseVersion(artifact, this.m_source, this.m_remoteRepos, this.m_localRepo, range);
        }
        catch (MojoExecutionException e) {
            return this.pluginVersion;
        }
    }

    protected final void setMainArchetype(String archetypeArtifactId) {
        if (PomUtils.isEmpty(this.archetypeVersion)) {
            this.archetypeVersion = this.getArchetypeVersion(PAX_CONSTRUCT_GROUP_ID, archetypeArtifactId);
        }
        this.setArchetypeProperty("archetypeGroupId", PAX_CONSTRUCT_GROUP_ID);
        this.setArchetypeProperty("archetypeArtifactId", archetypeArtifactId);
        this.setArchetypeProperty("archetypeVersion", this.archetypeVersion);
    }

    private void prepareTarget() throws MojoExecutionException {
        String artifactId = this.getArchetypeProperty("artifactId");
        File pomDirectory = new File(this.targetDirectory, artifactId);
        this.m_pomFile = new File(pomDirectory, "pom.xml");
        if (this.m_pomFile.exists()) {
            if (this.overwrite) {
                this.m_pomFile.delete();
            } else {
                throw new MojoExecutionException("Project already exists, use -Doverwrite or -o to replace it");
            }
        }
        this.m_tempFiles = new FileSet();
        this.m_tempFiles.setDirectory(pomDirectory.getAbsolutePath());
        if (pomDirectory.exists()) {
            this.preserveExistingFiles(pomDirectory);
        } else {
            pomDirectory.mkdirs();
        }
        if (null != this.m_modulesPom) {
            this.setArchetypeProperty("isMultiModuleProject", "true");
            try {
                this.m_modulesPom.addModule(pomDirectory.getName(), true);
                this.m_modulesPom.write();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to attach POM to existing project");
            }
        }
    }

    private void preserveExistingFiles(File baseDir) throws MojoExecutionException {
        try {
            List excludes = FileUtils.getFileNames((File)baseDir, null, null, (boolean)false);
            Iterator i = excludes.iterator();
            while (i.hasNext()) {
                this.getLog().debug((CharSequence)("Preserving " + i.next()));
            }
            this.m_tempFiles.setExcludes(excludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error while protecting existing files from deletion", (Exception)e);
        }
    }

    private void cacheSettings() throws MojoExecutionException {
        try {
            if (null != this.m_modulesPom) {
                DirUtils.updateLogicalParent(this.m_pomFile, this.getParentId());
            }
            this.m_pom = PomUtils.readPom(this.m_pomFile);
            if (this.hasCustomContent()) {
                this.m_pom.getFile().delete();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error reading generated Maven POM " + this.m_pomFile, (Exception)e);
        }
        try {
            this.m_bnd = BndUtils.readBnd(this.m_pom.getBasedir());
            if (this.hasCustomContent()) {
                this.m_bnd.getFile().delete();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error reading generated Bnd instructions", (Exception)e);
        }
        if (this.hasCustomContent()) {
            this.cacheOriginalFiles(this.m_pom.getBasedir());
        }
    }

    private void runCustomArchetypes() throws MojoExecutionException {
        Iterator i = this.m_customArchetypeIds.iterator();
        while (i.hasNext()) {
            String[] fields = ((String)i.next()).split(":");
            this.setArchetypeProperty("archetypeGroupId", fields[0]);
            this.setArchetypeProperty("archetypeArtifactId", fields[1]);
            this.setArchetypeProperty("archetypeVersion", fields[2]);
            this.generateArchetype();
        }
    }

    private void postProcess() throws MojoExecutionException {
        this.postProcess(this.m_pom, this.m_bnd);
        try {
            this.saveProjectModel(this.m_pom);
            this.saveBndInstructions(this.m_bnd);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to save customized settings");
        }
    }

    protected final void saveProjectModel(PomUtils.Pom pom) throws IOException {
        if (this.hasCustomContent() && pom.getFile().exists()) {
            PomUtils.Pom customPom = PomUtils.readPom(pom.getBasedir());
            pom.overlayDetails(customPom);
        }
        pom.write();
    }

    protected final void saveBndInstructions(BndUtils.Bnd bnd) throws IOException {
        if (this.hasCustomContent() && bnd.getFile().exists()) {
            BndUtils.Bnd customBnd = BndUtils.readBnd(bnd.getBasedir());
            bnd.overlayInstructions(customBnd);
        }
        bnd.write();
    }

    protected final String getCompoundId(String groupId, String artifactId) {
        if (this.compactIds) {
            return PomUtils.getCompoundId(groupId, artifactId);
        }
        return groupId + '.' + artifactId;
    }

    private void scheduleCustomArchetypes() {
        this.m_customArchetypeIds = new ArrayList();
        if (!this.hasCustomContent()) {
            return;
        }
        String[] ids = this.contents.split(",");
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i].trim();
            String[] fields = id.split(":");
            if (fields.length > 2) {
                this.scheduleArchetype(fields[0], fields[1], fields[2]);
                continue;
            }
            if (fields.length > 1) {
                this.scheduleArchetype(fields[0], fields[0], fields[1]);
                continue;
            }
            this.scheduleArchetype(PAX_CONSTRUCT_GROUP_ID, fields[0], null);
        }
    }

    protected final void scheduleArchetype(String groupId, String artifactId, String version) {
        if (PomUtils.isEmpty(version)) {
            this.m_customArchetypeIds.add(groupId + ':' + artifactId + ':' + this.archetypeVersion);
        } else {
            this.m_customArchetypeIds.add(groupId + ':' + artifactId + ':' + version);
        }
    }

    protected final Set getFinalFilenames() {
        HashSet<String> finalFiles = new HashSet<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.m_tempFiles.getDirectory());
        scanner.setFollowSymlinks(false);
        scanner.addDefaultExcludes();
        scanner.setExcludes(this.m_tempFiles.getExcludesArray());
        scanner.setIncludes(this.m_tempFiles.getIncludesArray());
        scanner.scan();
        finalFiles.addAll(Arrays.asList(scanner.getNotIncludedFiles()));
        finalFiles.addAll(Arrays.asList(scanner.getExcludedFiles()));
        return finalFiles;
    }

    private void cleanUp() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.m_tempFiles.getDirectory());
        scanner.setFollowSymlinks(false);
        scanner.addDefaultExcludes();
        scanner.setExcludes(this.m_tempFiles.getExcludesArray());
        scanner.setIncludes(this.m_tempFiles.getIncludesArray());
        scanner.scan();
        String[] discardedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < discardedFiles.length; ++i) {
            String filename = discardedFiles[i];
            this.getLog().debug((CharSequence)("Discarding " + filename));
            new File(scanner.getBasedir(), filename).delete();
        }
        DirUtils.pruneEmptyFolders(scanner.getBasedir());
    }

    protected final void setArchetypeProperty(String name, String value) {
        this.m_archetypeProperties.setProperty(name, value);
        if ("packageName".equals(name)) {
            this.m_archetypeProperties.setProperty("package", value);
        }
    }

    protected final String getArchetypeProperty(String name) {
        return this.m_archetypeProperties.getProperty(name);
    }

    private void generateArchetype() throws MojoExecutionException {
        try {
            String groupId = this.getArchetypeProperty("archetypeGroupId");
            String artifactId = this.getArchetypeProperty("archetypeArtifactId");
            String version = this.getArchetypeProperty("archetypeVersion");
            this.m_archetype.createArchetype(groupId, artifactId, version, this.m_localRepo, this.m_remoteRepos, (Map)this.m_archetypeProperties);
        }
        catch (ArchetypeNotFoundException e) {
            throw new MojoExecutionException("Error creating from archetype", (Exception)((Object)e));
        }
        catch (ArchetypeDescriptorException e) {
            throw new MojoExecutionException("Error creating from archetype", (Exception)((Object)e));
        }
        catch (ArchetypeTemplateProcessingException e) {
            throw new MojoExecutionException("Error creating from archetype", (Exception)((Object)e));
        }
    }

    private ArtifactRepository createRemoteRepository(String id, String url) {
        ArtifactRepositoryPolicy snapshots = new ArtifactRepositoryPolicy(true, "always", null);
        ArtifactRepositoryPolicy releases = new ArtifactRepositoryPolicy(true, "always", null);
        return this.m_repoFactory.createArtifactRepository(id, url, this.m_defaultLayout, snapshots, releases);
    }
}

