/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.archetype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.ops4j.pax.construct.archetype.AbstractPaxArchetypeMojo;
import org.ops4j.pax.construct.archetype.OSGiBundleArchetypeMojo;
import org.ops4j.pax.construct.util.BndUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class OSGiWrapperArchetypeMojo
extends AbstractPaxArchetypeMojo {
    private static final String OSGI_WRAPPER_ARCHETYPE_ID = "maven-archetype-osgi-wrapper";
    private static final String TEMP_SETTINGS_PATH = "target/settings/";
    private static final String INITIAL_POM_VERSION = "001-SNAPSHOT";
    private MavenProjectBuilder m_projectBuilder;
    private String parentId;
    private String bundleGroupId;
    private String bundleName;
    private String bundleVersion;
    private String groupId;
    private String artifactId;
    private String version;
    private String exclusions;
    private boolean wrapTransitive;
    private boolean wrapOptional;
    private boolean embedTransitive;
    private String includeResource;
    private String importPackage;
    private String exportContents;
    private String requireBundle;
    private String dynamicImport;
    private boolean noUses;
    private boolean testMetadata;
    private boolean addVersion;
    private List m_candidateIds;
    private Set m_excludedIds;
    private Set m_wrappedIds;

    protected String getParentId() {
        return this.parentId;
    }

    protected void updateExtensionFields() throws MojoExecutionException {
        this.populateMissingFields();
        if (null == this.m_candidateIds) {
            this.setMainArchetype(OSGI_WRAPPER_ARCHETYPE_ID);
            this.setArchetypeProperty("groupId", this.getInternalGroupId(this.bundleGroupId));
            String rootId = this.groupId + ':' + this.artifactId + ':' + this.version;
            this.m_candidateIds = new ArrayList();
            this.m_excludedIds = new HashSet();
            this.m_wrappedIds = new HashSet();
            this.excludeCandidates(this.exclusions);
            this.m_candidateIds.add(rootId);
            this.m_wrappedIds.add(rootId);
        }
        String id = (String)this.m_candidateIds.remove(0);
        String[] fields = id.split(":");
        this.groupId = fields[0];
        this.artifactId = fields[1];
        this.version = fields[2];
        String compoundWrapperId = this.getBundleSymbolicName();
        if (this.addVersion) {
            compoundWrapperId = compoundWrapperId + '-' + this.version;
        }
        this.setArchetypeProperty("artifactId", compoundWrapperId);
        this.setArchetypeProperty("packageName", this.artifactId);
        this.setArchetypeProperty("version", this.version);
        this.setArchetypeProperty("wrappedGroupId", this.getWrappedGroupId());
        this.setArchetypeProperty("wrappedArtifactId", this.getWrappedArtifactId());
        this.setArchetypeProperty("symbolicName", this.getBundleSymbolicName());
        this.setArchetypeProperty("bundleVersion", this.getBundleVersion());
    }

    public String getBundleSymbolicName() {
        if (PomUtils.isNotEmpty(this.bundleName)) {
            return this.bundleName;
        }
        return this.getCompoundId(this.groupId, this.artifactId);
    }

    public String getBundleVersion() {
        if (PomUtils.isNotEmpty(this.bundleVersion)) {
            return this.bundleVersion;
        }
        if (this.addVersion) {
            return INITIAL_POM_VERSION;
        }
        return this.version + '-' + INITIAL_POM_VERSION;
    }

    public String getWrappedGroupId() {
        return this.groupId;
    }

    public String getWrappedArtifactId() {
        return this.artifactId;
    }

    private void populateMissingFields() throws MojoExecutionException {
        if (PomUtils.isEmpty(this.groupId)) {
            this.groupId = this.artifactId;
        }
        if (PomUtils.needReleaseVersion(this.version)) {
            Artifact artifact = this.getFactory().createBuildArtifact(this.groupId, this.artifactId, "RELEASE", "jar");
            this.version = PomUtils.getReleaseVersion(artifact, this.getSource(), this.getRemoteRepos(), this.getLocalRepo(), null);
        }
    }

    protected void postProcess(PomUtils.Pom pom, BndUtils.Bnd bnd) throws MojoExecutionException {
        if (null == pom.getParentId()) {
            OSGiBundleArchetypeMojo.makeStandalone(pom, "wrappers", this.getPluginVersion());
        }
        this.updatePomDependencies(pom);
        this.updateBndInstructions(bnd);
        this.addTempFiles(TEMP_SETTINGS_PATH);
    }

    private void updatePomDependencies(PomUtils.Pom pom) {
        if (this.wrapTransitive) {
            this.wrapDirectDependencies(pom);
            this.embedTransitive = false;
        } else {
            this.excludeDependencies(pom);
        }
    }

    private void updateBndInstructions(BndUtils.Bnd bnd) {
        if (this.embedTransitive) {
            bnd.setInstruction("Embed-Transitive", "true", true);
        }
        if (this.includeResource != null) {
            bnd.setInstruction("Include-Resource", this.includeResource, true);
        }
        if (this.importPackage != null) {
            bnd.setInstruction("Import-Package", this.importPackage, true);
        }
        if (this.exportContents != null) {
            bnd.setInstruction("-exportcontents", this.exportContents, true);
        }
        if (this.requireBundle != null) {
            bnd.setInstruction("Require-Bundle", this.requireBundle, true);
        }
        if (this.dynamicImport != null) {
            bnd.setInstruction("DynamicImport-Package", this.dynamicImport, true);
        }
        if (this.noUses) {
            bnd.setInstruction("-nouses", "true", true);
        }
    }

    protected boolean createMoreArtifacts() {
        return !this.m_candidateIds.isEmpty();
    }

    private void wrapDirectDependencies(PomUtils.Pom pom) {
        ArrayList<Artifact> dependencyPoms = new ArrayList<Artifact>();
        dependencyPoms.add(this.getFactory().createProjectArtifact(this.groupId, this.artifactId, this.version));
        while (!dependencyPoms.isEmpty()) {
            Artifact pomArtifact = (Artifact)dependencyPoms.remove(0);
            try {
                MavenProject p = this.m_projectBuilder.buildFromRepository(pomArtifact, this.getRemoteRepos(), this.getLocalRepo());
                Set artifacts = p.createArtifacts(this.getFactory(), null, null);
                dependencyPoms.addAll(this.processDependencies(pom, artifacts));
            }
            catch (ProjectBuildingException e) {
                this.getLog().warn((Throwable)e);
            }
            catch (InvalidDependencyVersionException e) {
                this.getLog().warn((Throwable)e);
            }
        }
    }

    private List processDependencies(PomUtils.Pom pom, Set artifacts) {
        ArrayList<Artifact> newDependencyPoms = new ArrayList<Artifact>();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            String candidateId = OSGiWrapperArchetypeMojo.getCandidateId(artifact);
            if (!this.isValidWrapperDependency(artifact)) continue;
            if ("pom".equals(artifact.getType())) {
                newDependencyPoms.add(artifact);
                continue;
            }
            if (!this.addWrapperDependency(pom, artifact)) continue;
            this.m_candidateIds.add(candidateId);
            this.m_wrappedIds.add(candidateId);
        }
        return newDependencyPoms;
    }

    private String getWrappedVersion(String candidateId) {
        int versionIndex = candidateId.lastIndexOf(58);
        String prefix = candidateId.substring(0, 1 + versionIndex);
        Iterator i = this.m_wrappedIds.iterator();
        while (i.hasNext()) {
            String wrappedId = (String)i.next();
            if (!wrappedId.startsWith(prefix)) continue;
            return wrappedId.substring(prefix.length());
        }
        return null;
    }

    private static String getCandidateId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + PomUtils.getMetaVersion(artifact);
    }

    private boolean isValidWrapperDependency(Artifact artifact) {
        String scope = artifact.getScope();
        if ("system".equals(scope) || "test".equals(scope)) {
            this.getLog().info((CharSequence)("Skipping dependency " + artifact));
            return false;
        }
        if (!this.wrapOptional && artifact.isOptional()) {
            this.getLog().info((CharSequence)("Skipping optional dependency " + artifact));
            return false;
        }
        return true;
    }

    private boolean addWrapperDependency(PomUtils.Pom pom, Artifact artifact) {
        if (this.m_excludedIds.contains(artifact.getGroupId() + ':' + artifact.getArtifactId())) {
            pom.addExclusion(artifact.getGroupId(), artifact.getArtifactId(), true);
            return false;
        }
        if (PomUtils.isBundleArtifact(artifact, this.getResolver(), this.getRemoteRepos(), this.getLocalRepo(), this.testMetadata)) {
            pom.addDependency(this.getBundleDependency(artifact), true);
            return false;
        }
        String existingVersion = this.getWrappedVersion(OSGiWrapperArchetypeMojo.getCandidateId(artifact));
        if (null != existingVersion) {
            artifact.setVersion(existingVersion);
        }
        pom.addDependency(this.getWrappedDependency(artifact), true);
        return null == existingVersion;
    }

    private Dependency getBundleDependency(Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(PomUtils.getMetaVersion(artifact));
        dependency.setScope("provided");
        return dependency;
    }

    private Dependency getWrappedDependency(Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.getInternalGroupId(this.bundleGroupId));
        String compoundWrapperId = this.getCompoundId(artifact.getGroupId(), artifact.getArtifactId());
        String metaVersion = PomUtils.getMetaVersion(artifact);
        if (this.addVersion) {
            dependency.setArtifactId(compoundWrapperId + '-' + metaVersion);
            dependency.setVersion(INITIAL_POM_VERSION);
        } else {
            dependency.setArtifactId(compoundWrapperId);
            dependency.setVersion(metaVersion + '-' + INITIAL_POM_VERSION);
        }
        dependency.setScope("provided");
        return dependency;
    }

    private void excludeCandidates(String artifacts) {
        if (PomUtils.isEmpty(artifacts)) {
            return;
        }
        String[] exclusionIds = artifacts.split(",");
        for (int i = 0; i < exclusionIds.length; ++i) {
            String id = exclusionIds[i].trim();
            String[] fields = id.split(":");
            if (fields.length > 1) {
                this.m_excludedIds.add(fields[0] + ':' + fields[1]);
                continue;
            }
            this.m_excludedIds.add(id + ':' + id);
        }
    }

    private void excludeDependencies(PomUtils.Pom pom) {
        Iterator i = this.m_excludedIds.iterator();
        while (i.hasNext()) {
            String[] fields = ((String)i.next()).split(":");
            pom.addExclusion(fields[0], fields[1], true);
        }
    }
}

