/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.clone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.ops4j.pax.construct.clone.ArchetypeModel;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.PomUtils;

public class ArchetypeFragment {
    private static final int NO_SUCH_FILE = -1;
    private static final int BINARY_FILE = 0;
    private static final int TEXT_FILE = 1;
    private static int m_fragmentCount;
    private ArchetypeModel m_model = new ArchetypeModel();
    private String m_namespace;
    private File m_tempDir;
    private List m_includedFiles;
    private boolean m_unify;

    public ArchetypeFragment(File tempDir, String namespace, boolean unify) {
        this.m_model.setAllowPartial(true);
        this.m_namespace = namespace;
        this.m_tempDir = new File(tempDir, "fragment" + m_fragmentCount++);
        this.m_includedFiles = new ArrayList();
        this.m_unify = unify;
    }

    public void addPom(File projectDir, PomUtils.Pom pom) {
        File toDir = new File(this.m_tempDir, "archetype-resources");
        File pomFile = null == pom ? new File(projectDir, "pom.xml") : pom.getFile();
        this.translateFile(pomFile.getParentFile(), pomFile.getName(), toDir, "pom.xml");
    }

    public void addSources(File projectDir, String path, boolean isTest) {
        String[] pivot = DirUtils.calculateRelativePath(projectDir, new File(path));
        if (null == pivot || pivot[2].length() == 0) {
            return;
        }
        String sourcePath = pivot[2];
        String packagePath = sourcePath + this.m_namespace.replace('.', '/') + '/';
        File to = new File(this.m_tempDir, "archetype-resources");
        Iterator i = ArchetypeFragment.getFilenames(projectDir, sourcePath, null, null).iterator();
        while (i.hasNext()) {
            String filename = (String)i.next();
            this.m_includedFiles.add(filename);
            String target = StringUtils.replace((String)filename, (String)packagePath, (String)sourcePath);
            int status = this.translateFile(projectDir, filename, to, target);
            if (-1 == status) continue;
            if (target.equals(filename) || 0 == status) {
                this.addResourceEntry(filename, isTest, 1 == status);
                continue;
            }
            this.addSourceEntry(target, isTest);
        }
    }

    public void addResources(File projectDir, String path, boolean isTest) {
        this.addResources(projectDir, path, null, null, isTest);
    }

    public void addResources(File projectDir, String path, List includes, List excludes, boolean isTest) {
        String[] pivot = DirUtils.calculateRelativePath(projectDir, new File(path));
        if (null == pivot || pivot[0].length() > 0) {
            return;
        }
        String resourcePath = pivot[2];
        File to = new File(this.m_tempDir, "archetype-resources");
        Iterator i = ArchetypeFragment.getFilenames(projectDir, resourcePath, includes, excludes).iterator();
        while (i.hasNext()) {
            int status;
            String filename = (String)i.next();
            this.m_includedFiles.add(filename);
            String target = filename;
            if (target.endsWith("details.bnd") || target.endsWith("osgi.bundle")) {
                target = "osgi.bnd";
            }
            if (-1 == (status = this.translateFile(projectDir, filename, to, target))) continue;
            this.addResourceEntry(target, isTest, 1 == status);
        }
    }

    private static List getFilenames(File dir, String path, List includes, List excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        String[] pathExclude = ArchetypeFragment.parseFilter(path, excludes, null);
        String[] pathInclude = ArchetypeFragment.parseFilter(path, includes, "**");
        scanner.setExcludes(pathExclude);
        scanner.setIncludes(pathInclude);
        scanner.setFollowSymlinks(false);
        scanner.addDefaultExcludes();
        scanner.setBasedir(dir);
        scanner.scan();
        ArrayList<String> filenames = new ArrayList<String>();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            filenames.add(includedFiles[i].replace(File.separatorChar, '/'));
        }
        return filenames;
    }

    private static String[] parseFilter(String path, List filters, String defaultFilter) {
        String[] filterArray = null;
        if (null != filters) {
            filterArray = filters.toArray(new String[filters.size()]);
            for (int i = 0; i < filterArray.length; ++i) {
                filterArray[i] = path + filterArray[i];
            }
        } else if (null != defaultFilter) {
            filterArray = new String[]{path + defaultFilter};
        }
        return filterArray;
    }

    private void addSourceEntry(String entry, boolean isTest) {
        if (isTest) {
            this.m_model.addTestSource(entry);
        } else {
            this.m_model.addSource(entry);
        }
    }

    private void addResourceEntry(String entry, boolean isTest, boolean isFiltered) {
        if (isTest) {
            this.m_model.addTestResource(entry, isFiltered);
        } else {
            this.m_model.addResource(entry, isFiltered);
        }
    }

    public void createArchive(String fragmentId, Archiver archiver) throws MojoExecutionException {
        File modelFile = new File(this.m_tempDir, "META-INF/archetype.xml");
        try {
            this.m_model.setId(fragmentId);
            this.m_model.write(modelFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error saving archetype model", (Exception)e);
        }
        File jarFile = new File(this.m_tempDir.getParentFile(), fragmentId + ".jar");
        try {
            archiver.setDestFile(jarFile);
            archiver.setIncludeEmptyDirs(false);
            archiver.addDirectory(this.m_tempDir);
            archiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to archive archetype directory", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O error archiving archetype directory", (Exception)e);
        }
        try {
            FileUtils.deleteDirectory((File)this.m_tempDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to remove archetype files", (Exception)e);
        }
    }

    private String translateTextFile(String text, String path) {
        String content = text;
        content = StringUtils.replace((String)content, (String)"$", (String)"${dollar}");
        content = StringUtils.replace((String)content, (String)"#", (String)"${hash}");
        content = "#set( $dollar = '$' )" + System.getProperty("line.separator") + content;
        content = "#set( $hash = '#' )" + System.getProperty("line.separator") + content;
        content = StringUtils.replace((String)content, (String)this.m_namespace, (String)"${package}");
        content = StringUtils.replace((String)content, (String)"bundle.package", (String)"bundle.namespace");
        content = StringUtils.replace((String)content, (String)"jar.groupId", (String)"wrapped.groupId");
        content = StringUtils.replace((String)content, (String)"jar.artifactId", (String)"wrapped.artifactId");
        content = StringUtils.replace((String)content, (String)"jar.version", (String)"wrapped.version");
        if (this.m_unify && path.endsWith("/pom.xml")) {
            content = StringUtils.replace((String)content, (String)"module>poms</module", (String)"!-- module>poms</module --");
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int translateFile(File fromDir, String originalPath, File toDir, String mappedPath) {
        int n;
        File from = new File(fromDir, originalPath);
        FileOutputStream out = null;
        try {
            String text;
            FileInputStream in = new FileInputStream(from);
            byte[] raw = IOUtil.toByteArray((InputStream)in);
            IOUtil.close((InputStream)in);
            try {
                text = IOUtil.toString((byte[])raw);
            }
            catch (IOException e) {
                text = "";
            }
            if (Arrays.equals(text.getBytes(), raw)) {
                File file = new File(toDir, mappedPath);
                file.getParentFile().mkdirs();
                out = new FileOutputStream(file);
                IOUtil.copy((String)this.translateTextFile(text, mappedPath), (OutputStream)out);
                int n2 = 1;
                IOUtil.close((OutputStream)out);
                return n2;
            }
            File file = new File(toDir, originalPath);
            file.getParentFile().mkdirs();
            out = new FileOutputStream(file);
            IOUtil.copy((byte[])raw, (OutputStream)out);
            n = 0;
            IOUtil.close((OutputStream)out);
        }
        catch (IOException e) {
            System.err.println("WARNING: unable to clone " + from);
            int n3 = -1;
            return n3;
        }
        finally {
            IOUtil.close(out);
        }
        return n;
    }

    public List getIncludedFiles() {
        return Collections.unmodifiableList(this.m_includedFiles);
    }
}

