/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.util.IOUtil;
import org.ops4j.pax.construct.util.BndUtils;
import org.ops4j.pax.construct.util.DirUtils;
import org.ops4j.pax.construct.util.StreamFactory;

public class RoundTripBndFile
implements BndUtils.Bnd {
    private final File m_file;
    private Properties m_newInstructions;
    private Properties m_oldInstructions;

    public RoundTripBndFile(File bndFile) throws IOException {
        this.m_file = DirUtils.resolveFile(bndFile, true);
        this.m_oldInstructions = new Properties();
        this.m_newInstructions = new Properties();
        if (this.m_file.exists()) {
            FileInputStream bndStream = new FileInputStream(this.m_file);
            this.m_oldInstructions.load(bndStream);
            IOUtil.close((InputStream)bndStream);
        }
        this.m_newInstructions.putAll((Map<?, ?>)this.m_oldInstructions);
    }

    public String getInstruction(String directive) {
        return this.m_newInstructions.getProperty(directive);
    }

    public void setInstruction(String directive, String instruction, boolean overwrite) throws BndUtils.ExistingInstructionException {
        if (overwrite || !this.m_newInstructions.containsKey(directive)) {
            if (null == instruction) {
                this.m_newInstructions.setProperty(directive, "");
            } else {
                this.m_newInstructions.setProperty(directive, instruction);
            }
        } else {
            throw new BndUtils.ExistingInstructionException(directive);
        }
    }

    public boolean removeInstruction(String directive) {
        return null != this.m_newInstructions.remove(directive);
    }

    public Set getDirectives() {
        return this.m_newInstructions.keySet();
    }

    public void overlayInstructions(BndUtils.Bnd bnd) {
        Set directives = bnd.getDirectives();
        if (directives.contains("Private-Package") || directives.contains("Export-Package")) {
            this.removeInstruction("Embed-Dependency");
        }
        Iterator i = directives.iterator();
        while (i.hasNext()) {
            String directive = (String)i.next();
            String instruction = bnd.getInstruction(directive);
            this.setInstruction(directive, instruction, true);
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public File getBasedir() {
        return this.m_file.getParentFile();
    }

    public void write() throws IOException {
        if (!this.m_newInstructions.equals(this.m_oldInstructions) || !this.m_file.exists()) {
            this.writeUpdatedInstructions();
        }
        this.m_oldInstructions.clear();
        this.m_oldInstructions.putAll((Map<?, ?>)this.m_newInstructions);
    }

    private void writeUpdatedInstructions() throws IOException {
        List lines = this.readLines();
        ArrayList<String> block = new ArrayList<String>();
        boolean skip = false;
        boolean echo = true;
        Properties instructions = new Properties();
        instructions.putAll((Map<?, ?>)this.m_newInstructions);
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            if (RoundTripBndFile.isWhitespaceOrComment(line)) {
                block.add(line);
                skip = false;
                continue;
            }
            if (!skip) {
                echo = this.checkInstructionLine(block, line, instructions);
            }
            if (echo) {
                block.add(line);
            }
            skip = RoundTripBndFile.isLineContinuation(line);
        }
        Enumeration<Object> e = instructions.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = instructions.getProperty(key);
            RoundTripBndFile.writeInstruction(block, key, value);
        }
        BufferedWriter writer = new BufferedWriter(StreamFactory.newPlatformWriter(this.m_file));
        RoundTripBndFile.writeInstructionBlock(writer, block);
        IOUtil.close((Writer)writer);
    }

    private static void writeInstructionBlock(BufferedWriter bndWriter, List block) throws IOException {
        boolean needSpace = false;
        Iterator i = block.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            boolean isSpace = RoundTripBndFile.isWhitespaceOrComment(line);
            if (needSpace && !isSpace) {
                bndWriter.newLine();
            }
            needSpace = false;
            if (!isSpace && !RoundTripBndFile.isLineContinuation(line)) {
                needSpace = true;
            }
            bndWriter.write(line);
            bndWriter.newLine();
        }
    }

    private List readLines() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.m_file.exists()) {
            BufferedReader bndReader = new BufferedReader(StreamFactory.newPlatformReader(this.m_file));
            while (bndReader.ready()) {
                lines.add(bndReader.readLine());
            }
            IOUtil.close((Reader)bndReader);
        }
        return lines;
    }

    private boolean checkInstructionLine(List block, String line, Properties instructions) {
        String[] keyAndValue = line.split("[=: \t\r\n\f]", 2);
        String key = keyAndValue[0].trim();
        if (instructions.containsKey(key)) {
            String newValue = (String)instructions.remove(key);
            if (newValue.equals(this.m_oldInstructions.getProperty(key))) {
                return true;
            }
            RoundTripBndFile.writeInstruction(block, key, newValue);
            return false;
        }
        RoundTripBndFile.removeInstructionComment(block);
        return false;
    }

    private static void removeInstructionComment(List block) {
        while (!block.isEmpty()) {
            String line = (String)block.remove(block.size() - 1);
            if (line.trim().length() != 0 && RoundTripBndFile.isWhitespaceOrComment(line)) continue;
            block.add(line);
            return;
        }
    }

    private static boolean isWhitespaceOrComment(String line) {
        String comment = line.trim();
        if (comment.length() == 0) {
            return true;
        }
        char c = comment.charAt(0);
        return '#' == c || '!' == c;
    }

    private static boolean isLineContinuation(String line) {
        boolean continueLine = false;
        for (int c = line.length() - 1; c >= 0 && '\\' == line.charAt(c); --c) {
            continueLine = !continueLine;
        }
        return continueLine;
    }

    private static String markInstructionClauses(String instruction) {
        StringBuffer buf = new StringBuffer();
        boolean inQuotes = false;
        char[] text = instruction.toCharArray();
        block4: for (int i = 0; i < text.length; ++i) {
            char c = text[i];
            buf.append(c);
            switch (c) {
                case '\"': 
                case '\'': {
                    inQuotes = !inQuotes;
                    continue block4;
                }
                case ',': {
                    if (inQuotes) continue block4;
                    buf.append('\\');
                    continue block4;
                }
            }
        }
        return buf.toString();
    }

    private static void writeInstruction(List block, String key, String value) {
        StringBuffer buf = new StringBuffer(key + ':');
        String instruction = RoundTripBndFile.markInstructionClauses(value);
        boolean multiLine = instruction.length() > 80;
        String[] clauses = instruction.split("\\\\");
        for (int i = 0; i < clauses.length; ++i) {
            if (multiLine) {
                buf.append('\\');
                block.add(buf.toString());
                buf.setLength(0);
                buf.append(' ');
            } else if (i == 0) {
                buf.append(' ');
            }
            buf.append(clauses[i].trim());
        }
        block.add(buf.toString());
    }
}

