/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.construct.util;

import org.codehaus.plexus.util.xml.Xpp3Dom;

public class Xpp3DomHelper {
    private static void mergeIntoXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        if (recessive == null) {
            return;
        }
        boolean mergeSelf = true;
        String selfMergeMode = dominant.getAttribute("combine.self");
        if (Xpp3DomHelper.isNotEmpty(selfMergeMode) && "override".equals(selfMergeMode)) {
            mergeSelf = false;
        }
        if (mergeSelf) {
            if (Xpp3DomHelper.isEmpty(dominant.getValue())) {
                dominant.setValue(recessive.getValue());
            }
            String[] recessiveAttrs = recessive.getAttributeNames();
            for (int i = 0; i < recessiveAttrs.length; ++i) {
                String attr = recessiveAttrs[i];
                if (!Xpp3DomHelper.isEmpty(dominant.getAttribute(attr))) continue;
                dominant.setAttribute(attr, recessive.getAttribute(attr));
            }
            boolean mergeChildren = true;
            if (childMergeOverride != null) {
                mergeChildren = childMergeOverride;
            } else {
                String childMergeMode = dominant.getAttribute("combine.children");
                if (Xpp3DomHelper.isNotEmpty(childMergeMode) && "append".equals(childMergeMode)) {
                    mergeChildren = false;
                }
            }
            Xpp3Dom[] children = recessive.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Xpp3Dom child = children[i];
                Xpp3Dom childDom = dominant.getChild(child.getName());
                if (mergeChildren && childDom != null) {
                    Xpp3DomHelper.mergeIntoXpp3Dom(childDom, child, childMergeOverride);
                    continue;
                }
                dominant.addChild(new Xpp3Dom(child));
            }
        }
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        if (dominant != null) {
            Xpp3DomHelper.mergeIntoXpp3Dom(dominant, recessive, childMergeOverride);
            return dominant;
        }
        return recessive;
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        if (dominant != null) {
            Xpp3DomHelper.mergeIntoXpp3Dom(dominant, recessive, null);
            return dominant;
        }
        return recessive;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

