/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ArchiveExtractor {
    private ArchiveExtractor() {
    }

    public static void extract(URL sourceURL, File targetFolder) throws IOException {
        if (sourceURL.getProtocol().equals("file")) {
            if (sourceURL.getFile().indexOf(".zip") > 0) {
                ArchiveExtractor.extractZipDistribution(sourceURL, targetFolder);
            } else if (sourceURL.getFile().indexOf(".tar.gz") > 0) {
                ArchiveExtractor.extractTarGzDistribution(sourceURL, targetFolder);
            } else {
                throw new IllegalStateException("Unknow packaging of distribution; only zip or tar.gz could be handled.");
            }
            return;
        }
        if (sourceURL.toExternalForm().indexOf("/zip") > 0) {
            ArchiveExtractor.extractZipDistribution(sourceURL, targetFolder);
        } else if (sourceURL.toExternalForm().indexOf("/tar.gz") > 0) {
            ArchiveExtractor.extractTarGzDistribution(sourceURL, targetFolder);
        } else {
            throw new IllegalStateException("Unknow packaging; only zip or tar.gz could be handled. URL was " + sourceURL);
        }
    }

    private static void extractTarGzDistribution(URL sourceDistribution, File _targetFolder) throws IOException {
        File uncompressedFile = File.createTempFile("uncompressedTarGz-", ".tar");
        ArchiveExtractor.extractGzArchive(sourceDistribution.openStream(), uncompressedFile);
        ArchiveExtractor.extract((ArchiveInputStream)new TarArchiveInputStream((InputStream)new FileInputStream(uncompressedFile)), _targetFolder);
        FileUtils.forceDelete((File)uncompressedFile);
    }

    private static void extractZipDistribution(URL sourceDistribution, File _targetFolder) throws IOException {
        ArchiveExtractor.extract((ArchiveInputStream)new ZipArchiveInputStream(sourceDistribution.openStream()), _targetFolder);
    }

    private static void extractGzArchive(InputStream tarGz, File tar) throws IOException {
        BufferedInputStream in = new BufferedInputStream(tarGz);
        FileOutputStream out = new FileOutputStream(tar);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
        byte[] buffer = new byte[1000];
        int n = 0;
        while (-1 != (n = gzIn.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.close();
        gzIn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(ArchiveInputStream is, File targetDir) throws IOException {
        try {
            if (targetDir.exists()) {
                FileUtils.forceDelete((File)targetDir);
            }
            targetDir.mkdirs();
            ArchiveEntry entry = is.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                name = name.substring(name.indexOf("/") + 1);
                File file = new File(targetDir, name);
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(file);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)os);
                    }
                }
                entry = is.getNextEntry();
            }
        }
        finally {
            is.close();
        }
    }
}

