/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.ops4j.pax.exam.karaf.container.internal.JoinUtil;
import org.ops4j.pax.exam.karaf.container.internal.KarafConfigurationFile;

public class KarafCfgFile
extends KarafConfigurationFile {
    private final Properties properties = new Properties();

    public KarafCfgFile(File karafHome, String location) {
        super(karafHome, location);
    }

    @Override
    public void store() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        this.properties.store(fos, "Modified by paxexam");
        fos.close();
    }

    @Override
    public void load() throws IOException {
        if (!this.file.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(this.file);
        this.properties.load(fis);
        fis.close();
    }

    @Override
    public void put(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public void extend(String key, Object value) {
        if (this.properties.get(key) == null) {
            this.properties.put(key, value);
            return;
        }
        this.properties.put(key, JoinUtil.join((String)this.properties.get(key), (String)value));
    }

    @Override
    public Object get(String key) {
        return this.properties.getProperty(key);
    }
}

