/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.options;

import java.util.ArrayList;
import java.util.List;
import org.ops4j.pax.exam.karaf.options.KarafDistributionBaseConfigurationOption;
import org.ops4j.pax.exam.options.MavenUrlReference;

public class KarafDistributionKitConfigurationOption
extends KarafDistributionBaseConfigurationOption {
    private Platform platform;
    private List<String> makeExec = new ArrayList<String>();
    private String exec;

    public KarafDistributionKitConfigurationOption(KarafDistributionBaseConfigurationOption base, Platform platform) {
        super(base);
        this.setPlatform(platform);
    }

    public KarafDistributionKitConfigurationOption(MavenUrlReference frameworkURLReference, String name, String karafVersion, Platform platform) {
        super(frameworkURLReference, name, karafVersion);
        this.setPlatform(platform);
    }

    public KarafDistributionKitConfigurationOption(MavenUrlReference frameworkURLReference, Platform platform) {
        super(frameworkURLReference);
        this.setPlatform(platform);
    }

    public KarafDistributionKitConfigurationOption(String frameworkURL, String name, String karafVersion, Platform platform) {
        super(frameworkURL, name, karafVersion);
        this.setPlatform(platform);
    }

    private void setPlatform(Platform platform) {
        this.platform = platform;
        this.exec = platform.equals((Object)Platform.WINDOWS) ? "bin\\karaf.bat" : "bin/karaf";
    }

    public KarafDistributionKitConfigurationOption filesToMakeExecutable(String ... platformRelativeFilePath) {
        for (String platformRelativePath : platformRelativeFilePath) {
            this.makeExec.add(platformRelativePath);
        }
        return this;
    }

    public KarafDistributionKitConfigurationOption executable(String platformRelativeFilePath) {
        this.exec = platformRelativeFilePath;
        return this;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public List<String> getMakeExec() {
        return this.makeExec;
    }

    public String getExec() {
        return this.exec;
    }

    public static enum Platform {
        WINDOWS,
        NIX;

    }
}

