/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.util.Locale;

public class JavaVersionUtil {
    public static int getMajorVersion() {
        return JavaVersionUtil.getMajorVersion(System.getProperty("java.specification.version"));
    }

    static int getMajorVersion(String javaSpecVersion) {
        try {
            if (javaSpecVersion.contains(".")) {
                return Integer.parseInt(javaSpecVersion.split("\\.")[1]);
            }
            return Integer.parseInt(javaSpecVersion);
        }
        catch (NumberFormatException e) {
            throw JavaVersionUtil.getUnableToParseVersionException(javaSpecVersion);
        }
    }

    private static IllegalArgumentException getUnableToParseVersionException(String version) {
        return new IllegalArgumentException(String.format(Locale.ROOT, "We are unable to parse Java version '%1$s'.", version));
    }
}

