/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.util.Map;
import java.util.Properties;

enum LoggingBackend {
    LOG4J{

        @Override
        void updatePaxLoggingConfiguration(Properties karafPropertyFile, String realLogLevel) {
            karafPropertyFile.put("log4j.rootLogger", realLogLevel + ", out, stdout, osgi:*");
        }
    }
    ,
    LOG4J2{

        @Override
        void updatePaxLoggingConfiguration(Properties karafPropertyFile, String realLogLevel) {
            karafPropertyFile.put("log4j2.rootLogger.level", realLogLevel);
            String consoleAppenderName = null;
            for (Map.Entry<Object, Object> property : karafPropertyFile.entrySet()) {
                String propertyName;
                String propertyValue = property.getValue().toString();
                if (!propertyValue.equals("Console") || !(propertyName = property.getKey().toString()).matches("log4j2\\.appender\\.[^\\.]+\\.type")) continue;
                consoleAppenderName = karafPropertyFile.getProperty(propertyName.replaceAll(".type", ".name"));
                break;
            }
            if (consoleAppenderName != null && consoleAppenderName.length() > 0) {
                boolean rootLoggerHasConsoleAppender = false;
                for (Map.Entry<Object, Object> property : karafPropertyFile.entrySet()) {
                    String propertyName;
                    String propertyValue = property.getValue().toString();
                    if (!propertyValue.equals(consoleAppenderName) || !(propertyName = property.getKey().toString()).matches("log4j2\\.rootLogger\\.appenderRef\\.[^\\.]+\\.ref")) continue;
                    rootLoggerHasConsoleAppender = true;
                    break;
                }
                if (!rootLoggerHasConsoleAppender) {
                    karafPropertyFile.put("log4j2.rootLogger.appenderRef." + consoleAppenderName + ".ref", consoleAppenderName);
                }
            }
        }
    };


    abstract void updatePaxLoggingConfiguration(Properties var1, String var2);
}

