/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.ScoreContext;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class HardMediumSoftBigDecimalScoreContext
extends ScoreContext<HardMediumSoftBigDecimalScore> {
    private final Consumer<BigDecimal> softScoreUpdater;
    private final Consumer<BigDecimal> mediumScoreUpdater;
    private final Consumer<BigDecimal> hardScoreUpdater;

    public HardMediumSoftBigDecimalScoreContext(AbstractScoreInliner<HardMediumSoftBigDecimalScore> parent, Constraint constraint, HardMediumSoftBigDecimalScore constraintWeight, Consumer<BigDecimal> hardScoreUpdater, Consumer<BigDecimal> mediumScoreUpdater, Consumer<BigDecimal> softScoreUpdater) {
        super(parent, constraint, constraintWeight);
        this.softScoreUpdater = softScoreUpdater;
        this.mediumScoreUpdater = mediumScoreUpdater;
        this.hardScoreUpdater = hardScoreUpdater;
    }

    public UndoScoreImpacter changeSoftScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal softImpact = ((HardMediumSoftBigDecimalScore)this.constraintWeight).softScore().multiply(matchWeight);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreUpdater.accept(softImpact.negate());
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftBigDecimalScore.ofSoft((BigDecimal)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeMediumScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal mediumImpact = ((HardMediumSoftBigDecimalScore)this.constraintWeight).mediumScore().multiply(matchWeight);
        this.mediumScoreUpdater.accept(mediumImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.mediumScoreUpdater.accept(mediumImpact.negate());
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftBigDecimalScore.ofMedium((BigDecimal)mediumImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal hardImpact = ((HardMediumSoftBigDecimalScore)this.constraintWeight).hardScore().multiply(matchWeight);
        this.hardScoreUpdater.accept(hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreUpdater.accept(hardImpact.negate());
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftBigDecimalScore.ofHard((BigDecimal)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        BigDecimal hardImpact = ((HardMediumSoftBigDecimalScore)this.constraintWeight).hardScore().multiply(matchWeight);
        BigDecimal mediumImpact = ((HardMediumSoftBigDecimalScore)this.constraintWeight).mediumScore().multiply(matchWeight);
        BigDecimal softImpact = ((HardMediumSoftBigDecimalScore)this.constraintWeight).softScore().multiply(matchWeight);
        this.hardScoreUpdater.accept(hardImpact);
        this.mediumScoreUpdater.accept(mediumImpact);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            this.hardScoreUpdater.accept(hardImpact.negate());
            this.mediumScoreUpdater.accept(mediumImpact.negate());
            this.softScoreUpdater.accept(softImpact.negate());
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftBigDecimalScore.of((BigDecimal)hardImpact, (BigDecimal)mediumImpact, (BigDecimal)softImpact), justificationsSupplier);
    }
}

