/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.variable.ListVariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;

public class ExternalizedSingletonListInverseVariableSupply<Solution_>
implements SourcedVariableListener<Solution_>,
ListVariableListener<Solution_, Object, Object>,
SingletonInverseVariableSupply {
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    protected Map<Object, Object> inverseEntityMap = null;

    public ExternalizedSingletonListInverseVariableSupply(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(ScoreDirector<Solution_> scoreDirector) {
        this.inverseEntityMap = new IdentityHashMap<Object, Object>();
        this.sourceVariableDescriptor.getEntityDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void close() {
        this.inverseEntityMap = null;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(entity);
    }

    @Override
    public void afterListVariableElementUnassigned(ScoreDirector<Solution_> scoreDirector, Object element) {
        Object oldInverseEntity = this.inverseEntityMap.remove(element);
        if (oldInverseEntity == null) {
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the element (" + element + ") has an oldInverseEntity (" + oldInverseEntity + ") which is not set.");
        }
    }

    @Override
    public void beforeListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
    }

    @Override
    public void afterListVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity, int fromIndex, int toIndex) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (int i = fromIndex; i < toIndex; ++i) {
            this.inverseEntityMap.put(listVariable.get(i), entity);
        }
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        for (Object element : this.sourceVariableDescriptor.getListVariable(entity)) {
            this.inverseEntityMap.remove(element);
        }
    }

    private void insert(Object entity) {
        List<Object> listVariable = this.sourceVariableDescriptor.getListVariable(entity);
        for (Object element : listVariable) {
            Object oldInverseEntity = this.inverseEntityMap.put(element, entity);
            if (oldInverseEntity == null) continue;
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the element (" + element + ") has an oldInverseEntity (" + oldInverseEntity + ") which is not null.");
        }
    }

    @Override
    public Object getInverseSingleton(Object element) {
        return this.inverseEntityMap.get(element);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

