/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.nearby;

import java.util.Iterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.util.MemoizingSupply;

final class OriginalNearbyValueIterator
extends SelectionIterator<Object> {
    private final MemoizingSupply<NearbyDistanceMatrix<Object, Object>> nearbyDistanceMatrixSupply;
    private final Iterator<Object> replayingIterator;
    private final long childSize;
    private boolean originSelected = false;
    private boolean originIsNotEmpty;
    private Object origin;
    private int nextNearbyIndex;

    public OriginalNearbyValueIterator(MemoizingSupply<NearbyDistanceMatrix<Object, Object>> nearbyDistanceMatrixSupply, Iterator<Object> replayingIterator, long childSize, boolean discardNearbyIndexZero) {
        this.nearbyDistanceMatrixSupply = nearbyDistanceMatrixSupply;
        this.replayingIterator = replayingIterator;
        this.childSize = childSize;
        this.nextNearbyIndex = discardNearbyIndexZero ? 1 : 0;
    }

    private void selectOrigin() {
        if (this.originSelected) {
            return;
        }
        this.originIsNotEmpty = this.replayingIterator.hasNext();
        this.origin = this.replayingIterator.next();
        this.originSelected = true;
    }

    @Override
    public boolean hasNext() {
        this.selectOrigin();
        return this.originIsNotEmpty && (long)this.nextNearbyIndex < this.childSize;
    }

    @Override
    public Object next() {
        this.selectOrigin();
        Object next = this.nearbyDistanceMatrixSupply.read().getDestination(this.origin, this.nextNearbyIndex);
        ++this.nextNearbyIndex;
        return next;
    }
}

