/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.io.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.optaplanner.core.impl.io.OptaPlannerXmlSerializationException;
import org.optaplanner.core.impl.io.jaxb.ElementNamespaceOverride;
import org.optaplanner.core.impl.io.jaxb.JaxbIO;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class GenericJaxbIO<T>
implements JaxbIO<T> {
    private static final int DEFAULT_INDENTATION = 2;
    private static final String ERR_MSG_WRITE = "Failed to marshall a root element class (%s) to XML.";
    private static final String ERR_MSG_READ = "Failed to unmarshall a root element class (%s) from XML.";
    private static final String ERR_MSG_READ_OVERRIDE_NAMESPACE = "Failed to unmarshall a root element class (%s) from XML with overriding elements' namespaces: (%s).";
    private final JAXBContext jaxbContext;
    private final Marshaller marshaller;
    private final Class<T> rootClass;
    private final int indentation;

    public GenericJaxbIO(Class<T> rootClass) {
        this(rootClass, 2);
    }

    public GenericJaxbIO(Class<T> rootClass, int indentation) {
        Objects.requireNonNull(rootClass);
        this.rootClass = rootClass;
        this.indentation = indentation;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{rootClass});
            this.marshaller = this.jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.toString());
        }
        catch (JAXBException jaxbException) {
            String errorMessage = String.format("Failed to create JAXB Marshaller for a root element class (%s).", rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, jaxbException);
        }
    }

    @Override
    public T read(Reader reader) {
        Objects.requireNonNull(reader);
        try {
            return (T)this.createUnmarshaller().unmarshal(reader);
        }
        catch (JAXBException jaxbException) {
            String errorMessage = String.format(ERR_MSG_READ, this.rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, jaxbException);
        }
    }

    public T readAndValidate(Reader reader, String schemaResource) {
        Objects.requireNonNull(reader);
        Schema schema = this.readSchemaResource(schemaResource);
        return this.readAndValidate(reader, schema);
    }

    public T readAndValidate(Document document, String schemaResource) {
        return this.readAndValidate(document, this.readSchemaResource(schemaResource));
    }

    private Schema readSchemaResource(String schemaResource) {
        String nonNullSchemaResource = Objects.requireNonNull(schemaResource);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException saxException) {
            String errorMessage = String.format("Failed to configure the %s to validate an XML for a root class (%s) using the (%s) XML Schema.", SchemaFactory.class.getSimpleName(), this.rootClass.getName(), schemaResource);
            throw new OptaPlannerXmlSerializationException(errorMessage, saxException);
        }
        try {
            return schemaFactory.newSchema(GenericJaxbIO.class.getResource(nonNullSchemaResource));
        }
        catch (SAXException saxException) {
            String errorMessage = String.format("Failed to read an XML Schema resource (%s) to validate an XML for a root class (%s).", nonNullSchemaResource, this.rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, saxException);
        }
    }

    public T readAndValidate(Reader reader, Schema schema) {
        Document document = this.parseXml(Objects.requireNonNull(reader));
        return this.readAndValidate(document, Objects.requireNonNull(schema));
    }

    public T readAndValidate(Document document, Schema schema) {
        Document nonNullDocument = Objects.requireNonNull(document);
        Schema nonNullSchema = Objects.requireNonNull(schema);
        Unmarshaller unmarshaller = this.createUnmarshaller();
        unmarshaller.setSchema(nonNullSchema);
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        try {
            unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
        }
        catch (JAXBException jaxbException) {
            String errorMessage = String.format("Failed to set a validation event handler to the %s for a root element class (%s).", Unmarshaller.class.getSimpleName(), this.rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, jaxbException);
        }
        try {
            return (T)unmarshaller.unmarshal((Node)nonNullDocument);
        }
        catch (JAXBException jaxbException) {
            if (validationEventCollector.hasEvents()) {
                String errorMessage = String.format("XML validation failed for a root element class (%s).", this.rootClass.getName());
                String validationErrors = Stream.of(validationEventCollector.getEvents()).map(ValidationEvent::getMessage).collect(Collectors.joining("\n"));
                String errorMessageWithValidationEvents = errorMessage + "\n" + validationErrors;
                throw new OptaPlannerXmlSerializationException(errorMessageWithValidationEvents, jaxbException);
            }
            String errorMessage = String.format(ERR_MSG_READ, this.rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, jaxbException);
        }
    }

    public T readOverridingNamespace(Reader reader, ElementNamespaceOverride ... elementNamespaceOverrides) {
        Objects.requireNonNull(reader);
        Objects.requireNonNull(elementNamespaceOverrides);
        return this.readOverridingNamespace(this.parseXml(reader), elementNamespaceOverrides);
    }

    public T readOverridingNamespace(Document document, ElementNamespaceOverride ... elementNamespaceOverrides) {
        Document translatedDocument = this.overrideNamespaces(Objects.requireNonNull(document), Objects.requireNonNull(elementNamespaceOverrides));
        try {
            return (T)this.createUnmarshaller().unmarshal((Node)translatedDocument);
        }
        catch (JAXBException e) {
            String errorMessage = String.format(ERR_MSG_READ_OVERRIDE_NAMESPACE, this.rootClass.getName(), Arrays.toString(elementNamespaceOverrides));
            throw new OptaPlannerXmlSerializationException(errorMessage, e);
        }
    }

    public Document parseXml(Reader reader) {
        Document errorMessage2;
        block11: {
            DocumentBuilder builder;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            documentBuilderFactory.setNamespaceAware(true);
            try {
                builder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                String errorMessage2 = String.format("Failed to create a %s instance to parse an XML for a root class (%s).", DocumentBuilder.class.getSimpleName(), this.rootClass.getName());
                throw new OptaPlannerXmlSerializationException(errorMessage2, e);
            }
            Reader nonNullReader = Objects.requireNonNull(reader);
            try {
                errorMessage2 = builder.parse(new InputSource(nonNullReader));
                if (nonNullReader == null) break block11;
            }
            catch (Throwable errorMessage2) {
                try {
                    if (nonNullReader != null) {
                        try {
                            nonNullReader.close();
                        }
                        catch (Throwable throwable) {
                            errorMessage2.addSuppressed(throwable);
                        }
                    }
                    throw errorMessage2;
                }
                catch (SAXException saxException) {
                    String errorMessage3 = String.format("Failed to parse an XML for a root class (%s).", this.rootClass.getName());
                    throw new OptaPlannerXmlSerializationException(errorMessage3, saxException);
                }
                catch (IOException ioException) {
                    String errorMessage4 = String.format("Failed to read an XML for a root class (%s).", this.rootClass.getName());
                    throw new OptaPlannerXmlSerializationException(errorMessage4, ioException);
                }
            }
            nonNullReader.close();
        }
        return errorMessage2;
    }

    private Unmarshaller createUnmarshaller() {
        try {
            return this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            String errorMessage = String.format("Failed to create a JAXB %s for a root element class (%s).", Unmarshaller.class.getSimpleName(), this.rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, e);
        }
    }

    public void validate(Document document, String schemaResource) {
        Schema schema = this.readSchemaResource(Objects.requireNonNull(schemaResource));
        this.validate(Objects.requireNonNull(document), schema);
    }

    public void validate(Document document, Schema schema) {
        Validator validator = Objects.requireNonNull(schema).newValidator();
        try {
            validator.validate(new DOMSource(Objects.requireNonNull(document)));
        }
        catch (SAXException saxException) {
            String errorMessage = String.format("XML validation failed for a root element class (%s).", this.rootClass.getName()) + "\n" + saxException.getMessage();
            throw new OptaPlannerXmlSerializationException(errorMessage, saxException);
        }
        catch (IOException ioException) {
            String errorMessage = String.format("Failed to read an XML for a root element class (%s) during validation.", this.rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, ioException);
        }
    }

    @Override
    public void write(T root, Writer writer) {
        DOMResult domResult = this.marshall(Objects.requireNonNull(root));
        this.formatXml(new DOMSource(domResult.getNode()), null, Objects.requireNonNull(writer));
    }

    public void writeWithoutNamespaces(T root, Writer writer) {
        DOMResult domResult = this.marshall(Objects.requireNonNull(root));
        Writer nonNullWriter = Objects.requireNonNull(writer);
        try (InputStream xsltInputStream = this.getClass().getResourceAsStream("removeNamespaces.xslt");){
            this.formatXml(new DOMSource(domResult.getNode()), new StreamSource(xsltInputStream), nonNullWriter);
        }
        catch (IOException e) {
            throw new OptaPlannerXmlSerializationException(String.format(ERR_MSG_WRITE, this.rootClass.getName()), e);
        }
    }

    private DOMResult marshall(T root) {
        Objects.requireNonNull(root);
        DOMResult domResult = new DOMResult();
        try {
            this.marshaller.marshal(root, (Result)domResult);
        }
        catch (JAXBException jaxbException) {
            throw new OptaPlannerXmlSerializationException(String.format(ERR_MSG_WRITE, this.rootClass.getName()), jaxbException);
        }
        return domResult;
    }

    private void formatXml(Source source, Source transformationTemplate, Writer writer) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformationTemplate == null ? transformerFactory.newTransformer() : transformerFactory.newTransformer(transformationTemplate);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(this.indentation));
            transformer.transform(source, new StreamResult(writer));
        }
        catch (TransformerException transformerException) {
            String errorMessage = String.format("Failed to format XML for a root element class (%s).", this.rootClass.getName());
            throw new OptaPlannerXmlSerializationException(errorMessage, transformerException);
        }
    }

    private Document overrideNamespaces(Document document, ElementNamespaceOverride ... elementNamespaceOverrides) {
        Document nonNullDocument = Objects.requireNonNull(document);
        HashMap<String, String> elementNamespaceOverridesMap = new HashMap<String, String>();
        for (ElementNamespaceOverride namespaceOverride : Objects.requireNonNull(elementNamespaceOverrides)) {
            elementNamespaceOverridesMap.put(namespaceOverride.getElementLocalName(), namespaceOverride.getNamespaceOverride());
        }
        LinkedList<NamespaceOverride> preOrderNodes = new LinkedList<NamespaceOverride>();
        preOrderNodes.push(new NamespaceOverride(nonNullDocument.getDocumentElement(), null));
        while (!preOrderNodes.isEmpty()) {
            String effectiveNamespaceOverride;
            NamespaceOverride currentNodeOverride = (NamespaceOverride)preOrderNodes.pop();
            Node currentNode = currentNodeOverride.node;
            String elementLocalName = currentNode.getLocalName() == null ? currentNode.getNodeName() : currentNode.getLocalName();
            String detectedNamespaceOverride = (String)elementNamespaceOverridesMap.get(elementLocalName);
            String string = effectiveNamespaceOverride = detectedNamespaceOverride != null ? detectedNamespaceOverride : currentNodeOverride.namespace;
            if (effectiveNamespaceOverride != null) {
                nonNullDocument.renameNode(currentNode, effectiveNamespaceOverride, elementLocalName);
            }
            this.processChildNodes(currentNode, childNode -> {
                if (childNode.getNodeType() == 1) {
                    preOrderNodes.push(new NamespaceOverride((Node)childNode, effectiveNamespaceOverride));
                }
            });
        }
        return nonNullDocument;
    }

    private void processChildNodes(Node node, Consumer<Node> nodeConsumer) {
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (childNode == null) continue;
                nodeConsumer.accept(childNode);
            }
        }
    }

    private static final class NamespaceOverride {
        private final Node node;
        private final String namespace;

        private NamespaceOverride(Node node, String namespace) {
            this.node = node;
            this.namespace = namespace;
        }
    }
}

