/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.Rule;
import org.drools.model.impl.ModelImpl;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.common.ConstraintGraph;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public final class DroolsConstraintFactory<Solution_>
extends InnerConstraintFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final String defaultConstraintPackage;
    private final ConstraintGraph constraintGraph = new ConstraintGraph();

    public DroolsConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        Package pack;
        this.solutionDescriptor = solutionDescriptor;
        ConstraintConfigurationDescriptor<Solution_> configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        this.defaultConstraintPackage = configurationDescriptor == null ? ((pack = solutionDescriptor.getSolutionClass().getPackage()) == null ? "" : pack.getName()) : configurationDescriptor.getConstraintPackage();
    }

    @Override
    public <A> UniConstraintStream<A> fromUnfiltered(Class<A> fromClass) {
        this.assertValidFromType(fromClass);
        return new DroolsFromUniConstraintStream(this, fromClass);
    }

    @Override
    public ConstraintSessionFactory<Solution_, ?> buildSessionFactory(Constraint[] constraints) {
        ModelImpl model = new ModelImpl();
        AbstractScoreHolder scoreHolder = this.solutionDescriptor.getScoreDefinition().buildScoreHolder(false);
        Class<?> scoreHolderClass = scoreHolder.getClass();
        Package pack = this.solutionDescriptor.getSolutionClass().getPackage();
        Global scoreHolderGlobal = DSL.globalOf(scoreHolderClass, (String)(pack == null ? "" : pack.getName()), (String)"scoreHolder");
        model.addGlobal(scoreHolderGlobal);
        ArrayList<DroolsConstraint> droolsConstraintList = new ArrayList<DroolsConstraint>(constraints.length);
        HashSet<String> constraintIdSet = new HashSet<String>(constraints.length);
        for (Constraint constraint : constraints) {
            if (constraint.getConstraintFactory() != this) {
                throw new IllegalStateException("The constraint (" + constraint.getConstraintId() + ") must be created from the same constraintFactory.");
            }
            boolean added = constraintIdSet.add(constraint.getConstraintId());
            if (!added) {
                throw new IllegalStateException("There are 2 constraints with the same constraintName (" + constraint.getConstraintName() + ") in the same constraintPackage (" + constraint.getConstraintPackage() + ").");
            }
            DroolsConstraint droolsConstraint = (DroolsConstraint)constraint;
            droolsConstraintList.add(droolsConstraint);
        }
        DroolsConstraint[] constraintArray = droolsConstraintList.toArray(new DroolsConstraint[0]);
        Map<Rule, Class[]> ruleToExpectedJustificationTypesMap = this.constraintGraph.generateRule(scoreHolderGlobal, constraintArray);
        ruleToExpectedJustificationTypesMap.keySet().forEach(arg_0 -> ((ModelImpl)model).addRule(arg_0));
        return new DroolsConstraintSessionFactory(this.solutionDescriptor, (Model)model, ruleToExpectedJustificationTypesMap, constraintArray);
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public ConstraintGraph getConstraintGraph() {
        return this.constraintGraph;
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

