/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAccumulateContext;

public abstract class DroolsAbstractAccumulateFunction<ResultContainer_, InTuple, OutTuple>
implements AccumulateFunction<DroolsAccumulateContext<ResultContainer_>> {
    public DroolsAccumulateContext<ResultContainer_> createContext() {
        return new DroolsAccumulateContext<ResultContainer_>(this.newContainer());
    }

    public void init(DroolsAccumulateContext<ResultContainer_> context) {
        context.getUndoMap().clear();
    }

    public void accumulate(DroolsAccumulateContext<ResultContainer_> context, Object value) {
        Runnable undo = this.accumulate(context.getContainer(), value);
        Runnable previousUndo = context.getUndoMap().put(value, undo);
        if (previousUndo != null) {
            throw new IllegalStateException("Undo for (" + value + ") already exists.");
        }
    }

    public void reverse(DroolsAccumulateContext<ResultContainer_> context, Object value) {
        Runnable undo = context.getUndoMap().remove(value);
        if (undo == null) {
            throw new IllegalStateException("Undo for (" + value + ") does not exist.");
        }
        undo.run();
    }

    public Object getResult(DroolsAccumulateContext<ResultContainer_> context) {
        return this.getResult(context.getContainer());
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput out) {
        throw new UnsupportedOperationException();
    }

    public void readExternal(ObjectInput in) {
        throw new UnsupportedOperationException();
    }

    protected abstract ResultContainer_ newContainer();

    protected abstract Runnable accumulate(ResultContainer_ var1, InTuple var2);

    protected abstract OutTuple getResult(ResultContainer_ var1);
}

