/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.nodes;

import java.util.Collections;
import java.util.List;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelChildNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNodeType;

public abstract class AbstractConstraintModelGroupingNode<FunctionType_, CollectorType_>
extends AbstractConstraintModelChildNode {
    private final List<FunctionType_> mappings;
    private final List<CollectorType_> collectors;

    AbstractConstraintModelGroupingNode(List<FunctionType_> mappings, List<CollectorType_> collectors) {
        super(AbstractConstraintModelGroupingNode.determineType(mappings, collectors));
        this.mappings = mappings.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(mappings);
        this.collectors = collectors.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(collectors);
    }

    private static ConstraintGraphNodeType determineType(List mappings, List collectors) {
        if (mappings.isEmpty()) {
            if (collectors.isEmpty()) {
                throw new IllegalStateException("Impossible state: Grouping node has no mappings or collectors.");
            }
            return ConstraintGraphNodeType.GROUPBY_COLLECTING_ONLY;
        }
        if (collectors.isEmpty()) {
            return ConstraintGraphNodeType.GROUPBY_MAPPING_ONLY;
        }
        return ConstraintGraphNodeType.GROUPBY_MAPPING_AND_COLLECTING;
    }

    public List<FunctionType_> getMappings() {
        return this.mappings;
    }

    public List<CollectorType_> getCollectors() {
        return this.collectors;
    }
}

