/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block6;
import org.drools.model.functions.Predicate5;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.ConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractGroupByMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadExistenceMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy0Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy1Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy1Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy1Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy1Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy2Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy2Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy2Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy2Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy2Map2CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadGroupBy2Map2CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniRuleAssembler;

final class QuadRuleAssembler
extends AbstractRuleAssembler<QuadPredicate> {
    private QuadPredicate filterToApplyToLastPrimaryPattern = null;

    public QuadRuleAssembler(DroolsVariableFactory variableFactory, int expectedGroupByCount, List<ViewItem> finishedExpressions, Variable aVariable, Variable bVariable, Variable cVariable, Variable dVariable, List<PatternDSL.PatternDef> primaryPatterns, Map<Integer, List<ViewItem>> dependentExpressionMap) {
        super(variableFactory, expectedGroupByCount, finishedExpressions, primaryPatterns, dependentExpressionMap, aVariable, bVariable, cVariable, dVariable);
    }

    @Override
    protected void addFilterToLastPrimaryPattern(QuadPredicate quadPredicate) {
        this.filterToApplyToLastPrimaryPattern = this.filterToApplyToLastPrimaryPattern == null ? quadPredicate : this.filterToApplyToLastPrimaryPattern.and(quadPredicate);
    }

    @Override
    protected AbstractRuleAssembler join(UniRuleAssembler ruleAssembler, ConstraintGraphNode joinNode) {
        throw new UnsupportedOperationException("Impossible state: Penta streams are not supported.");
    }

    @Override
    protected AbstractRuleAssembler andThenExists(AbstractConstraintModelJoiningNode joiningNode, boolean shouldExist) {
        return new QuadExistenceMutator(joiningNode, shouldExist).apply(this);
    }

    @Override
    protected AbstractGroupByMutator new0Map1CollectGroupByMutator(Object collector) {
        return new QuadGroupBy0Map1CollectMutator((QuadConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new1Map0CollectGroupByMutator(Object mapping) {
        if (this.getExpectedGroupByCount() == 1) {
            return new QuadGroupBy1Map0CollectFastMutator((QuadFunction)mapping);
        }
        return new QuadGroupBy1Map0CollectMutator((QuadFunction)mapping);
    }

    @Override
    protected AbstractGroupByMutator new1Map1CollectGroupByMutator(Object mapping, Object collector) {
        if (this.getExpectedGroupByCount() == 1) {
            return new QuadGroupBy1Map1CollectFastMutator((QuadFunction)mapping, (QuadConstraintCollector)collector);
        }
        return new QuadGroupBy1Map1CollectMutator((QuadFunction)mapping, (QuadConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new2Map0CollectGroupByMutator(Object mappingA, Object mappingB) {
        if (this.getExpectedGroupByCount() == 1) {
            return new QuadGroupBy2Map0CollectFastMutator((QuadFunction)mappingA, (QuadFunction)mappingB);
        }
        return new QuadGroupBy2Map0CollectMutator((QuadFunction)mappingA, (QuadFunction)mappingB);
    }

    @Override
    protected AbstractGroupByMutator new2Map1CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC) {
        if (this.getExpectedGroupByCount() == 1) {
            return new QuadGroupBy2Map1CollectFastMutator((QuadFunction)mappingA, (QuadFunction)mappingB, (QuadConstraintCollector)collectorC);
        }
        return new QuadGroupBy2Map1CollectMutator((QuadFunction)mappingA, (QuadFunction)mappingB, (QuadConstraintCollector)collectorC);
    }

    @Override
    protected AbstractGroupByMutator new2Map2CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC, Object collectorD) {
        if (this.getExpectedGroupByCount() == 1) {
            return new QuadGroupBy2Map2CollectFastMutator((QuadFunction)mappingA, (QuadFunction)mappingB, (QuadConstraintCollector)collectorC, (QuadConstraintCollector)collectorD);
        }
        return new QuadGroupBy2Map2CollectMutator((QuadFunction)mappingA, (QuadFunction)mappingB, (QuadConstraintCollector)collectorC, (QuadConstraintCollector)collectorD);
    }

    @Override
    protected ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable ... variables) {
        ConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntQuadFunction intMatchWeighter = (ToIntQuadFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2], (Variable)variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, intMatchWeighter.applyAsInt(a, b, c, d)));
            }
            case LONG: {
                ToLongQuadFunction longMatchWeighter = (ToLongQuadFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2], (Variable)variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, longMatchWeighter.applyAsLong(a, b, c, d)));
            }
            case BIG_DECIMAL: {
                QuadFunction bigDecimalMatchWeighter = (QuadFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2], (Variable)variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a, b, c, d)));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2], (Variable)variables[3]).execute((Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> QuadRuleAssembler.impactScore((Drools)drools, (AbstractScoreHolder)scoreHolder));
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }

    @Override
    protected void applyFilterToLastPrimaryPattern() {
        if (this.filterToApplyToLastPrimaryPattern == null) {
            return;
        }
        QuadPredicate predicate = this.filterToApplyToLastPrimaryPattern;
        this.getLastPrimaryPattern().expr("Filter using " + predicate, this.getVariable(0), this.getVariable(1), this.getVariable(2), this.getVariable(3), (Predicate5 & Serializable)(fact, a, b, c, d) -> predicate.test(a, b, c, d));
        this.filterToApplyToLastPrimaryPattern = null;
    }
}

