/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common.rules;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block5;
import org.drools.model.functions.Predicate4;
import org.drools.model.view.ViewItem;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsVariableFactory;
import org.optaplanner.core.impl.score.stream.drools.common.consequences.ConstraintConsequence;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.AbstractConstraintModelJoiningNode;
import org.optaplanner.core.impl.score.stream.drools.common.nodes.ConstraintGraphNode;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractGroupByMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.AbstractRuleAssembler;
import org.optaplanner.core.impl.score.stream.drools.common.rules.QuadJoinMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriExistenceMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy0Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy1Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy1Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy1Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy1Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy2Map0CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy2Map0CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy2Map1CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy2Map1CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy2Map2CollectFastMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.TriGroupBy2Map2CollectMutator;
import org.optaplanner.core.impl.score.stream.drools.common.rules.UniRuleAssembler;

final class TriRuleAssembler
extends AbstractRuleAssembler<TriPredicate> {
    private TriPredicate filterToApplyToLastPrimaryPattern = null;

    public TriRuleAssembler(DroolsVariableFactory variableFactory, int expectedGroupByCount, List<ViewItem> finishedExpressions, Variable aVariable, Variable bVariable, Variable cVariable, List<PatternDSL.PatternDef> primaryPatterns, Map<Integer, List<ViewItem>> dependentExpressionMap) {
        super(variableFactory, expectedGroupByCount, finishedExpressions, primaryPatterns, dependentExpressionMap, aVariable, bVariable, cVariable);
    }

    @Override
    protected void addFilterToLastPrimaryPattern(TriPredicate triPredicate) {
        this.filterToApplyToLastPrimaryPattern = this.filterToApplyToLastPrimaryPattern == null ? triPredicate : this.filterToApplyToLastPrimaryPattern.and(triPredicate);
    }

    @Override
    protected AbstractRuleAssembler join(UniRuleAssembler ruleAssembler, ConstraintGraphNode joinNode) {
        return new QuadJoinMutator((AbstractConstraintModelJoiningNode)joinNode).apply(this, ruleAssembler);
    }

    @Override
    protected AbstractRuleAssembler andThenExists(AbstractConstraintModelJoiningNode joiningNode, boolean shouldExist) {
        return new TriExistenceMutator(joiningNode, shouldExist).apply(this);
    }

    @Override
    protected AbstractGroupByMutator new0Map1CollectGroupByMutator(Object collector) {
        return new TriGroupBy0Map1CollectMutator((TriConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new1Map0CollectGroupByMutator(Object mapping) {
        if (this.getExpectedGroupByCount() == 1) {
            return new TriGroupBy1Map0CollectFastMutator((TriFunction)mapping);
        }
        return new TriGroupBy1Map0CollectMutator((TriFunction)mapping);
    }

    @Override
    protected AbstractGroupByMutator new1Map1CollectGroupByMutator(Object mapping, Object collector) {
        if (this.getExpectedGroupByCount() == 1) {
            return new TriGroupBy1Map1CollectFastMutator((TriFunction)mapping, (TriConstraintCollector)collector);
        }
        return new TriGroupBy1Map1CollectMutator((TriFunction)mapping, (TriConstraintCollector)collector);
    }

    @Override
    protected AbstractGroupByMutator new2Map0CollectGroupByMutator(Object mappingA, Object mappingB) {
        if (this.getExpectedGroupByCount() == 1) {
            return new TriGroupBy2Map0CollectFastMutator((TriFunction)mappingA, (TriFunction)mappingB);
        }
        return new TriGroupBy2Map0CollectMutator((TriFunction)mappingA, (TriFunction)mappingB);
    }

    @Override
    protected AbstractGroupByMutator new2Map1CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC) {
        if (this.getExpectedGroupByCount() == 1) {
            return new TriGroupBy2Map1CollectFastMutator((TriFunction)mappingA, (TriFunction)mappingB, (TriConstraintCollector)collectorC);
        }
        return new TriGroupBy2Map1CollectMutator((TriFunction)mappingA, (TriFunction)mappingB, (TriConstraintCollector)collectorC);
    }

    @Override
    protected AbstractGroupByMutator new2Map2CollectGroupByMutator(Object mappingA, Object mappingB, Object collectorC, Object collectorD) {
        if (this.getExpectedGroupByCount() == 1) {
            return new TriGroupBy2Map2CollectFastMutator((TriFunction)mappingA, (TriFunction)mappingB, (TriConstraintCollector)collectorC, (TriConstraintCollector)collectorD);
        }
        return new TriGroupBy2Map2CollectMutator((TriFunction)mappingA, (TriFunction)mappingB, (TriConstraintCollector)collectorC, (TriConstraintCollector)collectorD);
    }

    @Override
    protected ConsequenceBuilder.ValidBuilder buildConsequence(DroolsConstraint constraint, Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Variable ... variables) {
        ConstraintConsequence consequence = constraint.getConsequence();
        switch (consequence.getMatchWeightType()) {
            case INTEGER: {
                ToIntTriFunction intMatchWeighter = (ToIntTriFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2]).execute((Block5 & Serializable)(drools, scoreHolder, a, b, c) -> TriRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, intMatchWeighter.applyAsInt(a, b, c)));
            }
            case LONG: {
                ToLongTriFunction longMatchWeighter = (ToLongTriFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2]).execute((Block5 & Serializable)(drools, scoreHolder, a, b, c) -> TriRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, longMatchWeighter.applyAsLong(a, b, c)));
            }
            case BIG_DECIMAL: {
                TriFunction bigDecimalMatchWeighter = (TriFunction)((Supplier)((Object)consequence)).get();
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2]).execute((Block5 & Serializable)(drools, scoreHolder, a, b, c) -> TriRuleAssembler.impactScore(constraint, (Drools)drools, (AbstractScoreHolder)scoreHolder, (BigDecimal)bigDecimalMatchWeighter.apply(a, b, c)));
            }
            case DEFAULT: {
                return DSL.on(scoreHolderGlobal, (Variable)variables[0], (Variable)variables[1], (Variable)variables[2]).execute((Block5 & Serializable)(drools, scoreHolder, a, b, c) -> TriRuleAssembler.impactScore((Drools)drools, (AbstractScoreHolder)scoreHolder));
            }
        }
        throw new UnsupportedOperationException(consequence.getMatchWeightType().toString());
    }

    @Override
    protected void applyFilterToLastPrimaryPattern() {
        if (this.filterToApplyToLastPrimaryPattern == null) {
            return;
        }
        TriPredicate predicate = this.filterToApplyToLastPrimaryPattern;
        this.getLastPrimaryPattern().expr("Filter using " + predicate, this.getVariable(0), this.getVariable(1), this.getVariable(2), (Predicate4 & Serializable)(fact, a, b, c) -> predicate.test(a, b, c));
        this.filterToApplyToLastPrimaryPattern = null;
    }
}

