/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.geojson.GeoJsonDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class GeoJsonWrite
extends AbstractFunction
implements ScalarFunction {
    public GeoJsonWrite() {
        this.addProperty("remarks", "Export a spatial table to a GeoJSON 1.0 file.\n As optional argument an encoding value is supported.");
    }

    public String getJavaStaticMethod() {
        return "writeGeoJson";
    }

    public static void writeGeoJson(Connection connection, String fileName, String tableReference, String encoding) throws IOException, SQLException {
        GeoJsonDriverFunction geoJsonDriver = new GeoJsonDriverFunction();
        geoJsonDriver.exportTable(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor(), encoding);
    }

    public static void writeGeoJson(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        GeoJsonWrite.writeGeoJson(connection, fileName, tableReference, null);
    }
}

